/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConsts;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.NotSupportedRuntimeException;
import com.intel.bluetooth.SDPInputStream;
import com.intel.bluetooth.SDPOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

class ServiceRecordImpl
implements ServiceRecord {
    private BluetoothStack bluetoothStack;
    private RemoteDevice device;
    private long handle;
    Hashtable attributes;
    protected boolean attributeUpdated;
    int deviceServiceClasses;
    int deviceServiceClassesRegistered;

    ServiceRecordImpl(BluetoothStack bluetoothStack, RemoteDevice device, long handle) {
        this.bluetoothStack = bluetoothStack;
        this.device = device;
        this.handle = handle;
        this.deviceServiceClassesRegistered = 0;
        this.attributes = new Hashtable();
    }

    byte[] toByteArray() throws IOException {
        int i;
        DataElement element = new DataElement(48);
        boolean sort = true;
        int[] sortIDs = new int[this.attributes.size()];
        int k = 0;
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            sortIDs[k] = key;
            ++k;
        }
        for (i = 0; i < sortIDs.length; ++i) {
            for (int j = 0; j < sortIDs.length - i - 1; ++j) {
                if (sortIDs[j] <= sortIDs[j + 1]) continue;
                int temp = sortIDs[j];
                sortIDs[j] = sortIDs[j + 1];
                sortIDs[j + 1] = temp;
            }
        }
        for (i = 0; i < sortIDs.length; ++i) {
            element.addElement(new DataElement(9, sortIDs[i]));
            element.addElement(this.getAttributeValue(sortIDs[i]));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new SDPOutputStream(out).writeElement(element);
        return out.toByteArray();
    }

    void loadByteArray(byte[] data) throws IOException {
        DataElement element = new SDPInputStream(new ByteArrayInputStream(data)).readElement();
        if (element.getDataType() != 48) {
            throw new IOException("DATSEQ expected instead of " + element.getDataType());
        }
        Enumeration en = (Enumeration)element.getValue();
        while (en.hasMoreElements()) {
            DataElement id = (DataElement)en.nextElement();
            if (id.getDataType() != 9) {
                throw new IOException("U_INT_2 expected instead of " + id.getDataType());
            }
            DataElement value = (DataElement)en.nextElement();
            this.populateAttributeValue((int)id.getLong(), value);
        }
    }

    public DataElement getAttributeValue(int attrID) {
        if (attrID < 0 || attrID > 65535) {
            throw new IllegalArgumentException();
        }
        return (DataElement)this.attributes.get(new Integer(attrID));
    }

    public RemoteDevice getHostDevice() {
        return this.device;
    }

    public int[] getAttributeIDs() {
        int[] attrIDs = new int[this.attributes.size()];
        int i = 0;
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            attrIDs[i++] = (Integer)e.nextElement();
        }
        return attrIDs;
    }

    public boolean populateRecord(int[] attrIDs) throws IOException {
        int i;
        if (this.device == null) {
            throw new RuntimeException("This is local device service record");
        }
        if (attrIDs == null) {
            throw new NullPointerException("attrIDs is null");
        }
        if (attrIDs.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < attrIDs.length; ++i2) {
            if (attrIDs[i2] >= 0 && attrIDs[i2] <= 65535) continue;
            throw new IllegalArgumentException();
        }
        int[] sortIDs = new int[attrIDs.length];
        System.arraycopy(attrIDs, 0, sortIDs, 0, attrIDs.length);
        for (i = 0; i < sortIDs.length; ++i) {
            for (int j = 0; j < sortIDs.length - i - 1; ++j) {
                if (sortIDs[j] <= sortIDs[j + 1]) continue;
                int temp = sortIDs[j];
                sortIDs[j] = sortIDs[j + 1];
                sortIDs[j + 1] = temp;
            }
        }
        for (i = 0; i < sortIDs.length - 1; ++i) {
            if (sortIDs[i] == sortIDs[i + 1]) {
                throw new IllegalArgumentException();
            }
            DebugLog.debug0x("srvRec query for attr", sortIDs[i]);
        }
        DebugLog.debug0x("srvRec query for attr", sortIDs[sortIDs.length - 1]);
        return this.bluetoothStack.populateServicesRecordAttributeValues(this, sortIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionURL(int requiredSecurity, boolean mustBeMaster) {
        int commChannel = -1;
        DataElement protocolDescriptor = this.getAttributeValue(4);
        if (protocolDescriptor == null || protocolDescriptor.getDataType() != 48) {
            return null;
        }
        boolean isL2CAP = false;
        boolean isRFCOMM = false;
        boolean isOBEX = false;
        Enumeration protocolsSeqEnum = (Enumeration)protocolDescriptor.getValue();
        while (protocolsSeqEnum.hasMoreElements()) {
            DataElement protocolPSMElement;
            DataElement protocolElement;
            Enumeration elementSeqEnum;
            DataElement elementSeq = (DataElement)protocolsSeqEnum.nextElement();
            if (elementSeq.getDataType() != 48 || !(elementSeqEnum = (Enumeration)elementSeq.getValue()).hasMoreElements() || (protocolElement = (DataElement)elementSeqEnum.nextElement()).getDataType() != 24) continue;
            Object uuid = protocolElement.getValue();
            if (BluetoothConsts.OBEX_PROTOCOL_UUID.equals(uuid)) {
                isOBEX = true;
                isRFCOMM = false;
                isL2CAP = false;
                continue;
            }
            if (elementSeqEnum.hasMoreElements() && BluetoothConsts.RFCOMM_PROTOCOL_UUID.equals(uuid)) {
                protocolPSMElement = (DataElement)elementSeqEnum.nextElement();
                switch (protocolPSMElement.getDataType()) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        long val = protocolPSMElement.getLong();
                        if (val < 1L || val > 30L) break;
                        commChannel = (int)val;
                        isRFCOMM = true;
                        isL2CAP = false;
                    }
                }
                continue;
            }
            if (!elementSeqEnum.hasMoreElements() || !BluetoothConsts.L2CAP_PROTOCOL_UUID.equals(uuid)) continue;
            protocolPSMElement = (DataElement)elementSeqEnum.nextElement();
            switch (protocolPSMElement.getDataType()) {
                case 8: 
                case 9: 
                case 10: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    long pcm = protocolPSMElement.getLong();
                    if (pcm < 5L || pcm > 65535L) break;
                    commChannel = (int)pcm;
                    isL2CAP = true;
                }
            }
        }
        if (commChannel == -1) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (isOBEX) {
            buf.append("btgoep");
        } else if (isRFCOMM) {
            buf.append("btspp");
        } else if (isL2CAP) {
            buf.append("btl2cap");
        } else {
            return null;
        }
        buf.append("://");
        if (this.device == null) {
            try {
                Object saveID = BlueCoveImpl.getCurrentThreadBluetoothStackID();
                try {
                    BlueCoveImpl.setThreadBluetoothStack(this.bluetoothStack);
                    buf.append(LocalDevice.getLocalDevice().getBluetoothAddress());
                }
                finally {
                    if (saveID != null) {
                        BlueCoveImpl.setThreadBluetoothStackID(saveID);
                    }
                }
            }
            catch (BluetoothStateException bse) {
                DebugLog.error("can't read LocalAddress", bse);
                buf.append("localhost");
            }
        } else {
            buf.append(this.getHostDevice().getBluetoothAddress());
        }
        buf.append(":");
        if (isL2CAP) {
            String hex = Integer.toHexString(commChannel);
            for (int i = hex.length(); i < 4; ++i) {
                buf.append('0');
            }
            buf.append(hex);
        } else {
            buf.append(commChannel);
        }
        switch (requiredSecurity) {
            case 0: {
                buf.append(";authenticate=false;encrypt=false");
                break;
            }
            case 1: {
                buf.append(";authenticate=true;encrypt=false");
                break;
            }
            case 2: {
                buf.append(";authenticate=true;encrypt=true");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (mustBeMaster) {
            buf.append(";master=true");
        } else {
            buf.append(";master=false");
        }
        return buf.toString();
    }

    int getChannel(UUID protocolUUID) {
        int channel = -1;
        DataElement protocolDescriptor = this.getAttributeValue(4);
        if (protocolDescriptor == null || protocolDescriptor.getDataType() != 48) {
            return -1;
        }
        Enumeration protocolsSeqEnum = (Enumeration)protocolDescriptor.getValue();
        while (protocolsSeqEnum.hasMoreElements()) {
            DataElement protocolElement;
            Enumeration elementSeqEnum;
            DataElement elementSeq = (DataElement)protocolsSeqEnum.nextElement();
            if (elementSeq.getDataType() != 48 || !(elementSeqEnum = (Enumeration)elementSeq.getValue()).hasMoreElements() || (protocolElement = (DataElement)elementSeqEnum.nextElement()).getDataType() != 24) continue;
            Object uuid = protocolElement.getValue();
            if (!elementSeqEnum.hasMoreElements() || !protocolUUID.equals(uuid)) continue;
            DataElement protocolPSMElement = (DataElement)elementSeqEnum.nextElement();
            switch (protocolPSMElement.getDataType()) {
                case 8: 
                case 9: 
                case 10: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    channel = (int)protocolPSMElement.getLong();
                }
            }
        }
        return channel;
    }

    public void setDeviceServiceClasses(int classes) {
        if (this.device != null) {
            throw new RuntimeException("Service record obtained from a remote device");
        }
        if ((classes & 0xFF002003) != 0) {
            throw new IllegalArgumentException();
        }
        if ((classes & 0x1FFC) != 0) {
            throw new IllegalArgumentException();
        }
        if ((this.bluetoothStack.getFeatureSet() & 4) == 0) {
            throw new NotSupportedRuntimeException(this.bluetoothStack.getStackID());
        }
        this.deviceServiceClasses = classes;
    }

    public boolean setAttributeValue(int attrID, DataElement attrValue) {
        if (this.device != null) {
            throw new IllegalArgumentException();
        }
        if (attrID < 0 || attrID > 65535) {
            throw new IllegalArgumentException();
        }
        if (attrID == 0) {
            throw new IllegalArgumentException();
        }
        this.attributeUpdated = true;
        if (attrValue == null) {
            return this.attributes.remove(new Integer(attrID)) != null;
        }
        this.attributes.put(new Integer(attrID), attrValue);
        return true;
    }

    void populateAttributeValue(int attrID, DataElement attrValue) {
        if (attrID < 0 || attrID > 65535) {
            throw new IllegalArgumentException();
        }
        if (attrValue == null) {
            this.attributes.remove(new Integer(attrID));
        } else {
            this.attributes.put(new Integer(attrID), attrValue);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{\n");
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            Integer i = (Integer)e.nextElement();
            buf.append("0x");
            buf.append(Integer.toHexString(i));
            buf.append(":\n\t");
            DataElement d = (DataElement)this.attributes.get(i);
            buf.append(d);
            buf.append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    long getHandle() {
        return this.handle;
    }

    void setHandle(long handle) {
        this.handle = handle;
    }

    boolean hasServiceClassUUID(UUID uuid) {
        DataElement attrDataElement = this.getAttributeValue(1);
        if (attrDataElement == null || attrDataElement.getDataType() != 48 || attrDataElement.getSize() == 0) {
            return false;
        }
        Object value = attrDataElement.getValue();
        if (value == null || !(value instanceof Enumeration)) {
            DebugLog.debug("Bogus Value in DATSEQ");
            if (value != null) {
                DebugLog.error("DATSEQ class " + value.getClass().getName());
            }
            return false;
        }
        Enumeration e = (Enumeration)value;
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (!(element instanceof DataElement)) {
                DebugLog.debug("Bogus element in DATSEQ, " + value.getClass().getName());
                continue;
            }
            DataElement dataElement = (DataElement)element;
            if (dataElement.getDataType() != 24 || !uuid.equals(dataElement.getValue())) continue;
            return true;
        }
        return false;
    }

    boolean hasProtocolClassUUID(UUID uuid) {
        DataElement protocolDescriptor = this.getAttributeValue(4);
        if (protocolDescriptor == null || protocolDescriptor.getDataType() != 48) {
            return false;
        }
        Enumeration protocolsSeqEnum = (Enumeration)protocolDescriptor.getValue();
        while (protocolsSeqEnum.hasMoreElements()) {
            DataElement protocolElement;
            Enumeration elementSeqEnum;
            DataElement elementSeq = (DataElement)protocolsSeqEnum.nextElement();
            if (elementSeq.getDataType() != 48 || !(elementSeqEnum = (Enumeration)elementSeq.getValue()).hasMoreElements() || (protocolElement = (DataElement)elementSeqEnum.nextElement()).getDataType() != 24 || !uuid.equals(protocolElement.getValue())) continue;
            return true;
        }
        return false;
    }

    DataElement clone(DataElement de) {
        DataElement c = null;
        switch (de.getDataType()) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: {
                c = new DataElement(de.getDataType(), de.getLong());
                break;
            }
            case 12: 
            case 19: 
            case 20: 
            case 24: 
            case 32: 
            case 64: {
                c = new DataElement(de.getDataType(), de.getValue());
                break;
            }
            case 0: {
                c = new DataElement(de.getDataType());
                break;
            }
            case 40: {
                c = new DataElement(de.getBoolean());
                break;
            }
            case 48: 
            case 56: {
                c = new DataElement(de.getDataType());
                Enumeration en = (Enumeration)de.getValue();
                while (en.hasMoreElements()) {
                    DataElement dataElement = (DataElement)en.nextElement();
                    c.addElement(this.clone(dataElement));
                }
                break;
            }
        }
        return c;
    }

    void populateRFCOMMAttributes(long handle, int channel, UUID uuid, String name, boolean obex) {
        this.populateAttributeValue(0, new DataElement(10, handle));
        DataElement serviceClassIDList = new DataElement(48);
        serviceClassIDList.addElement(new DataElement(24, uuid));
        if (!obex) {
            serviceClassIDList.addElement(new DataElement(24, BluetoothConsts.SERIAL_PORT_UUID));
        }
        this.populateAttributeValue(1, serviceClassIDList);
        DataElement protocolDescriptorList = new DataElement(48);
        DataElement L2CAPDescriptor = new DataElement(48);
        L2CAPDescriptor.addElement(new DataElement(24, BluetoothConsts.L2CAP_PROTOCOL_UUID));
        protocolDescriptorList.addElement(L2CAPDescriptor);
        DataElement RFCOMMDescriptor = new DataElement(48);
        RFCOMMDescriptor.addElement(new DataElement(24, BluetoothConsts.RFCOMM_PROTOCOL_UUID));
        RFCOMMDescriptor.addElement(new DataElement(8, channel));
        protocolDescriptorList.addElement(RFCOMMDescriptor);
        if (obex) {
            DataElement OBEXDescriptor = new DataElement(48);
            OBEXDescriptor.addElement(new DataElement(24, BluetoothConsts.OBEX_PROTOCOL_UUID));
            protocolDescriptorList.addElement(OBEXDescriptor);
        }
        this.populateAttributeValue(4, protocolDescriptorList);
        if (name != null) {
            this.populateAttributeValue(256, new DataElement(32, name));
        }
    }

    void populateL2CAPAttributes(int handle, int channel, UUID uuid, String name) {
        this.populateAttributeValue(0, new DataElement(10, handle));
        DataElement serviceClassIDList = new DataElement(48);
        serviceClassIDList.addElement(new DataElement(24, uuid));
        this.populateAttributeValue(1, serviceClassIDList);
        DataElement protocolDescriptorList = new DataElement(48);
        DataElement L2CAPDescriptor = new DataElement(48);
        L2CAPDescriptor.addElement(new DataElement(24, BluetoothConsts.L2CAP_PROTOCOL_UUID));
        L2CAPDescriptor.addElement(new DataElement(9, channel));
        protocolDescriptorList.addElement(L2CAPDescriptor);
        this.populateAttributeValue(4, protocolDescriptorList);
        if (name != null) {
            this.populateAttributeValue(256, new DataElement(32, name));
        }
    }
}

