/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CSSLengthValueHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

final class ComputedValueHandler
extends CSSLengthValueHandler {
    ComputedValueHandler(DimensionHandle dimensionHandle) {
        super(dimensionHandle);
    }

    DimensionValue getAbsoluteValueForLength(DimensionValue relativeDimensionValue) {
        DimensionValue absoluteFontSizeValueTemp;
        FactoryPropertyHandle factoryHandle = this.dimensionHandle.getElementHandle().getFactoryPropertyHandle(this.dimensionHandle.getPropertyDefn().getName());
        DesignElementHandle containerHandle = this.dimensionHandle.getElementHandle().getContainer();
        DimensionHandle dimensionHandleFromContainer = containerHandle.getDimensionProperty(this.dimensionHandle.getPropertyDefn().getName());
        DimensionValue absoluteFontSizeValue = this.getDefaultFontSizeValue();
        DimensionHandle factualFontSizeHanle = this.getFactualFontSizeHandle();
        if (factualFontSizeHanle != null && (absoluteFontSizeValueTemp = factualFontSizeHanle.getAbsoluteValue()) != null) {
            absoluteFontSizeValue = absoluteFontSizeValueTemp;
        }
        if (factoryHandle != null) {
            return this.computeRelativeValue(absoluteFontSizeValue, relativeDimensionValue);
        }
        if (this.dimensionHandle.getPropertyDefn().canInherit()) {
            return dimensionHandleFromContainer.getAbsoluteValue();
        }
        Object defaultValue = this.dimensionHandle.getPropertyDefn().getDefault();
        if (defaultValue instanceof DimensionValue) {
            DimensionValue defaultDimensionValue = (DimensionValue)defaultValue;
            if (CSSLengthValueHandler.isAbsoluteUnit(defaultDimensionValue.getUnits())) {
                return defaultDimensionValue;
            }
            return this.computeRelativeValue(absoluteFontSizeValue, defaultDimensionValue);
        }
        return null;
    }

    private DimensionHandle getFactualFontSizeHandle() {
        String unit = this.dimensionHandle.getUnits();
        if (!("em".equalsIgnoreCase(unit) || "ex".equalsIgnoreCase(unit) || "%".equalsIgnoreCase(unit))) {
            assert (false);
            return this.dimensionHandle.elementHandle.getDimensionProperty("fontSize");
        }
        Object propValue = null;
        ElementPropertyDefn fontSizePropDefn = (ElementPropertyDefn)MetaDataDictionary.getInstance().getElement("Style").getProperty("fontSize");
        DesignElementHandle e = this.dimensionHandle.getElementHandle();
        boolean computedPropertyFound = false;
        while (e != null) {
            if (!computedPropertyFound && (propValue = e.getElement().getStrategy().getPropertyFromElement(this.dimensionHandle.getModule(), e.getElement(), this.dimensionHandle.propDefn)) != null) {
                computedPropertyFound = true;
            }
            if (computedPropertyFound && (propValue = e.getElement().getStrategy().getPropertyFromElement(this.dimensionHandle.getModule(), e.getElement(), fontSizePropDefn)) != null || !this.dimensionHandle.propDefn.canInherit()) break;
            e = e.getContainer();
        }
        if (e != null) {
            return e.getDimensionProperty("fontSize");
        }
        return null;
    }
}

