/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.impl.SizeBasedContent;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.SizeBasedPageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class HTMLLayoutPageHintManager {
    protected HTMLLayoutContext context;
    protected HashMap layoutHint = new HashMap();
    protected HashMap<String, SizeBasedContent> sizeBasedContentMapping = new HashMap();
    protected ArrayList pageHints = new ArrayList();
    protected HashMap<String, UnresolvedRowHint> currentHints = new HashMap();
    protected HashMap<String, UnresolvedRowHint> hints = new HashMap();
    protected HashMap<String, UnresolvedRowHint> pageRowHint = new HashMap();
    protected ArrayList columnHints = new ArrayList();

    public HTMLLayoutPageHintManager(HTMLLayoutContext context) {
        this.context = context;
    }

    public void setPageHint(List hints) {
        this.pageHints.addAll(hints);
    }

    public ArrayList getPageHint() {
        ArrayList hints = new ArrayList();
        hints.addAll(this.pageHints);
        return hints;
    }

    public void reset() {
        this.layoutHint = new HashMap();
        this.sizeBasedContentMapping = new HashMap();
        this.context.setFinish(false);
        this.context.setAllowPageBreak(true);
        this.context.setMasterPage(null);
    }

    public void addLayoutHint(IContent content, boolean finished) {
        this.layoutHint.put(content, finished);
    }

    public void removeLayoutHint(IContent content) {
        this.layoutHint.remove(content);
    }

    public boolean getLayoutHint(IContent content) {
        Object finished = this.layoutHint.get(content);
        if (finished != null && finished instanceof Boolean) {
            return (Boolean)finished;
        }
        return true;
    }

    public void removeLayoutHint() {
        this.layoutHint.clear();
    }

    public void generatePageRowHints(Collection<String> keys) {
        this.pageRowHint.clear();
        for (String key : keys) {
            UnresolvedRowHint hint = this.hints.get(key);
            if (hint == null) continue;
            this.pageRowHint.put(key, hint);
        }
    }

    public HashMap<String, UnresolvedRowHint> getUnresolvedRowHints() {
        return this.pageRowHint;
    }

    public List getTableColumnHints() {
        return this.columnHints;
    }

    public void addTableColumnHints(List hints) {
        this.columnHints.addAll(hints);
    }

    public void addTableColumnHint(TableColumnHint hint) {
        this.columnHints.add(hint);
    }

    public UnresolvedRowHint getUnresolvedRowHint(String key) {
        if (this.hints.size() > 0) {
            return this.hints.get(key);
        }
        return null;
    }

    public void addUnresolvedRowHint(String key, UnresolvedRowHint hint) {
        this.currentHints.put(key, hint);
    }

    public void clearPageHint() {
        this.columnHints.clear();
        this.pageHints.clear();
    }

    public void resetRowHint() {
        if (!this.context.emptyPage) {
            this.hints.clear();
            this.hints.putAll(this.currentHints);
            this.currentHints.clear();
        }
    }

    public void setLayoutPageHint(IPageHint pageHint) {
        if (pageHint != null) {
            this.context.pageNumber = pageHint.getPageNumber();
            this.context.masterPage = pageHint.getMasterPage();
            int count = pageHint.getTableColumnHintCount();
            int i = 0;
            while (i < count) {
                this.columnHints.add(pageHint.getTableColumnHint(i));
                ++i;
            }
            count = pageHint.getUnresolvedRowCount();
            if (count > 0) {
                i = 0;
                while (i < count) {
                    UnresolvedRowHint hint = pageHint.getUnresolvedRowHint(i);
                    String key = this.getHintMapKey(hint.getTableId());
                    this.hints.put(key, hint);
                    ++i;
                }
            }
            i = 0;
            while (i < pageHint.getSectionCount()) {
                PageSection section = pageHint.getSection(i);
                if (section instanceof SizeBasedPageSection) {
                    InstanceID endID;
                    InstanceID startID;
                    SizeBasedPageSection sizeBasedSection = (SizeBasedPageSection)section;
                    if (sizeBasedSection.start.dimension != -1 && (startID = sizeBasedSection.starts[sizeBasedSection.starts.length - 1].getInstanceID()) != null) {
                        this.sizeBasedContentMapping.put(startID.toUniqueString(), sizeBasedSection.start);
                    }
                    if (sizeBasedSection.end.dimension != -1 && (endID = sizeBasedSection.ends[sizeBasedSection.ends.length - 1].getInstanceID()) != null) {
                        this.sizeBasedContentMapping.put(endID.toUniqueString(), sizeBasedSection.end);
                    }
                }
                ++i;
            }
        }
    }

    public HashMap<String, SizeBasedContent> getSizeBasedContentMapping() {
        return this.sizeBasedContentMapping;
    }

    public String getHintMapKey(String tableId) {
        String key = tableId;
        List hints = this.getTableColumnHint(key);
        Iterator iter = hints.iterator();
        StringBuffer keyBuf = new StringBuffer(key);
        while (iter.hasNext()) {
            int[] vs = (int[])iter.next();
            keyBuf.append('-');
            keyBuf.append(vs[0]);
            keyBuf.append('-');
            keyBuf.append(vs[1]);
        }
        return keyBuf.toString();
    }

    public List getTableColumnHint(String tableId) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (this.columnHints.size() > 0) {
            for (TableColumnHint hint : this.columnHints) {
                if (!tableId.equals(hint.getTableId())) continue;
                list.add(new int[]{hint.getStart(), hint.getStart() + hint.getColumnCount()});
            }
        }
        return list;
    }
}

