/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoFactoryImpl;
import fr.ifremer.adagio.synchro.dao.Daos;
import fr.ifremer.adagio.synchro.dao.DataIntegrityViolationOnDeleteException;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.dao.SynchroTableDaoUtils;
import fr.ifremer.adagio.synchro.intercept.SynchroDeletedRowException;
import fr.ifremer.adagio.synchro.intercept.SynchroDuplicateRowException;
import fr.ifremer.adagio.synchro.intercept.SynchroRejectRowException;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroMetadataUtils;
import fr.ifremer.adagio.synchro.meta.SynchroSchemaValidationException;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.RejectedRowStatus;
import fr.ifremer.adagio.synchro.service.RejectedRowStrategy;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import fr.ifremer.adagio.synchro.service.SynchroService;
import fr.ifremer.adagio.synchro.service.SynchroTableOperation;
import fr.ifremer.adagio.synchro.type.ProgressionModel;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.TimeLog;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class SynchroServiceImpl
implements SynchroService {
    private static final Log log = LogFactory.getLog(SynchroServiceImpl.class);
    protected static final TimeLog TIME = new TimeLog(SynchroServiceImpl.class);
    protected static final TimeLog TIME_DELETION = new TimeLog(SynchroServiceImpl.class, 3000000000L, 5000000000L);
    protected final SynchroConfiguration config;
    protected final int MAX_ROW_COUNT_FOR_PK_PRELOADING = 50000;
    protected final int batchSize;
    protected final boolean debug;
    protected final DataSource dataSource;
    private final boolean disableIntegrityConstraints;
    private final boolean allowMissingOptionalColumn;
    private final boolean allowAdditionalMandatoryColumnInSourceSchema;
    private final boolean keepWhereClauseOnQueriesByFks;
    private int daoCacheSize = -1;
    private int statementCacheSize = -1;
    private final LoadingCache<SynchroContext, Map<String, Object>> defaultBindingCache;

    public SynchroServiceImpl(DataSource dataSource, SynchroConfiguration config, boolean disableIntegrityConstraints, boolean allowMissingOptionalColumn, boolean allowAdditionalMandatoryColumnInSourceSchema, boolean keepWhereClauseOnQueriesByFks) {
        Preconditions.checkNotNull((Object)config);
        this.dataSource = dataSource;
        this.config = config;
        this.batchSize = config.getImportJdbcBatchSize();
        this.defaultBindingCache = this.initBindingCache(5);
        this.disableIntegrityConstraints = disableIntegrityConstraints;
        this.allowMissingOptionalColumn = allowMissingOptionalColumn;
        this.allowAdditionalMandatoryColumnInSourceSchema = allowAdditionalMandatoryColumnInSourceSchema;
        this.keepWhereClauseOnQueriesByFks = keepWhereClauseOnQueriesByFks;
        this.debug = log.isTraceEnabled();
    }

    public SynchroServiceImpl(boolean couldDisableIntegrityConstraints, boolean allowMissingOptionalColumn, boolean allowAdditionalMandatoryColumnInSourceSchema, boolean keepWhereClauseOnQueriesByFks) {
        this(null, SynchroConfiguration.getInstance(), couldDisableIntegrityConstraints, allowMissingOptionalColumn, allowAdditionalMandatoryColumnInSourceSchema, keepWhereClauseOnQueriesByFks);
    }

    @Override
    public SynchroContext createSynchroContext(File sourceDbDirectory, Set<String> tableToIncludes) {
        String dbName = this.config.getDbName();
        Properties targetConnectionProperties = this.config.getConnectionProperties();
        Properties sourceConnectionProperties = new Properties(targetConnectionProperties);
        sourceConnectionProperties.setProperty("hibernate.connection.url", Daos.getJdbcUrl(sourceDbDirectory, dbName));
        return this.createSynchroContext(sourceConnectionProperties, tableToIncludes);
    }

    @Override
    public SynchroContext createSynchroContext(Properties sourceConnectionProperties, Set<String> tableToIncludes) {
        Preconditions.checkNotNull((Object)sourceConnectionProperties);
        Properties targetConnectionProperties = this.config.getConnectionProperties();
        SynchroContext context = SynchroContext.newContext(tableToIncludes, sourceConnectionProperties, targetConnectionProperties, new SynchroResult());
        context.getTarget().setKeepWhereClauseOnQueriesByFks(this.keepWhereClauseOnQueriesByFks);
        context.getSource().setKeepWhereClauseOnQueriesByFks(this.keepWhereClauseOnQueriesByFks);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(SynchroContext context) {
        SynchroDatabaseMetadata sourceMeta;
        SynchroDatabaseMetadata targetMeta;
        SynchroDatabaseMetadata dbMeta;
        ProgressionModel progressionModel;
        DaoFactoryImpl targetDaoFactory;
        DaoFactoryImpl sourceDaoFactory;
        Connection sourceConnection;
        Connection targetConnection;
        SynchroResult result;
        boolean useTargetMetadata;
        SynchroDatabaseConfiguration target;
        SynchroDatabaseConfiguration source;
        block11: {
            Preconditions.checkNotNull((Object)context);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preparing for synchronization - " + context.toString()));
            }
            source = context.getSource();
            Preconditions.checkNotNull((Object)source);
            source.setReadOnly(true);
            target = context.getTarget();
            Preconditions.checkNotNull((Object)target);
            target.setReadOnly(true);
            useTargetMetadata = target.isFullMetadataEnable();
            source.setFullMetadataEnable(!useTargetMetadata);
            Set<String> tableToIncludes = context.getTableNames();
            if (CollectionUtils.isEmpty(tableToIncludes)) {
                log.info((Object)I18n.t((String)"adagio.synchro.prepare.noTableFilter", (Object[])new Object[0]));
            }
            result = context.getResult();
            Preconditions.checkNotNull((Object)result);
            result.setLocalUrl(target.getUrl());
            result.setRemoteUrl(source.getUrl());
            targetConnection = null;
            sourceConnection = null;
            sourceDaoFactory = null;
            targetDaoFactory = null;
            progressionModel = result.getProgressionModel();
            progressionModel.setMessage(I18n.t((String)"adagio.synchro.prepare.step1", (Object[])new Object[0]));
            targetConnection = this.createConnection(target);
            progressionModel.setMessage(I18n.t((String)"adagio.synchro.prepare.step2", (Object[])new Object[0]));
            sourceConnection = this.createConnection(source);
            dbMeta = null;
            targetMeta = this.loadDatabaseMetadata(targetConnection, target, tableToIncludes);
            sourceMeta = this.loadDatabaseMetadata(sourceConnection, source, tableToIncludes);
            progressionModel.setMessage(I18n.t((String)"adagio.synchro.prepare.step3", (Object[])new Object[0]));
            this.checkSchemasAndExcludeMissingColumns(source, target, sourceMeta, targetMeta, this.allowMissingOptionalColumn, this.allowAdditionalMandatoryColumnInSourceSchema, result);
            if (result.isSuccess()) break block11;
            IOUtils.closeQuietly(sourceDaoFactory);
            IOUtils.closeQuietly(targetDaoFactory);
            this.closeSilently(sourceConnection);
            this.closeSilently(targetConnection);
            this.releaseContext(context);
            return;
        }
        try {
            dbMeta = useTargetMetadata ? targetMeta : sourceMeta;
            sourceDaoFactory = this.newDaoFactory(sourceConnection, source, dbMeta);
            targetDaoFactory = this.newDaoFactory(targetConnection, target, dbMeta);
            sourceDaoFactory.getDao().cleanTempQueryParameter();
            targetDaoFactory.getDao().cleanTempQueryParameter();
            Set<String> rootTableNames = dbMeta.getLoadedRootTableNames();
            if (CollectionUtils.isEmpty(rootTableNames)) {
                log.warn((Object)I18n.t((String)"adagio.synchro.prepare.noRootTable", (Object[])new Object[0]));
            }
            for (String tableName : rootTableNames) {
                long t0 = TimeLog.getTime();
                progressionModel.setMessage(I18n.t((String)"adagio.synchro.prepare.step4", (Object[])new Object[]{tableName}));
                SynchroTableMetadata table = dbMeta.getLoadedTable(tableName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Prepare table: " + tableName));
                }
                this.prepareRootTable(sourceDaoFactory, targetDaoFactory, table, context, result);
                TIME.log(t0, "prepare table " + tableName);
            }
            long totalRows = result.getTotalRows();
            if (log.isInfoEnabled()) {
                log.info((Object)("Total root rows to update: " + totalRows));
            }
            this.rollbackSilently(targetConnection);
        }
        catch (SQLException e) {
            try {
                this.rollbackSilently(targetConnection);
                result.setError(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sourceDaoFactory);
                IOUtils.closeQuietly(targetDaoFactory);
                this.closeSilently(sourceConnection);
                this.closeSilently(targetConnection);
                this.releaseContext(context);
                throw throwable;
            }
            IOUtils.closeQuietly(sourceDaoFactory);
            IOUtils.closeQuietly(targetDaoFactory);
            this.closeSilently(sourceConnection);
            this.closeSilently(targetConnection);
            this.releaseContext(context);
        }
        IOUtils.closeQuietly((Closeable)sourceDaoFactory);
        IOUtils.closeQuietly((Closeable)targetDaoFactory);
        this.closeSilently(sourceConnection);
        this.closeSilently(targetConnection);
        this.releaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void synchronize(SynchroContext context) {
        DaoFactoryImpl targetDaoFactory;
        DaoFactoryImpl sourceDaoFactory;
        Connection sourceConnection;
        Connection targetConnection;
        block18: {
            block17: {
                Preconditions.checkNotNull((Object)context);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starting synchronization - " + context.toString()));
                }
                SynchroDatabaseConfiguration source = context.getSource();
                Preconditions.checkNotNull((Object)source);
                source.setReadOnly(true);
                SynchroDatabaseConfiguration target = context.getTarget();
                Preconditions.checkNotNull((Object)target);
                target.setReadOnly(false);
                boolean useTargetMetadata = target.isFullMetadataEnable();
                source.setFullMetadataEnable(!useTargetMetadata);
                Set<String> tableNames = context.getTableNames();
                SynchroResult result = context.getResult();
                Preconditions.checkNotNull((Object)result);
                targetConnection = null;
                sourceConnection = null;
                sourceDaoFactory = null;
                targetDaoFactory = null;
                try {
                    sourceConnection = this.createConnection(source);
                    targetConnection = this.createConnection(target);
                    SynchroDatabaseMetadata dbMeta = null;
                    if (useTargetMetadata) {
                        log.debug((Object)"Loading target database metadata...");
                        dbMeta = this.loadDatabaseMetadata(targetConnection, target, tableNames);
                    } else {
                        log.debug((Object)"Loading source database metadata...");
                        dbMeta = this.loadDatabaseMetadata(sourceConnection, source, tableNames);
                    }
                    sourceDaoFactory = this.newDaoFactory(sourceConnection, source, dbMeta);
                    targetDaoFactory = this.newDaoFactory(targetConnection, target, dbMeta);
                    ProgressionModel progressionModel = result.getProgressionModel();
                    progressionModel.setTotal(result.getTotalRows() + 1);
                    progressionModel.setCurrent(0);
                    progressionModel.setMessage(I18n.t((String)"adagio.synchro.synchronize.step0", (Object[])new Object[0]));
                    this.prepareSynch(targetConnection, context);
                    try {
                        sourceDaoFactory.getDao().cleanTempQueryParameter();
                        targetDaoFactory.getDao().cleanTempQueryParameter();
                        ArrayDeque pendingOperations = Queues.newArrayDeque(this.getRootOperations(sourceDaoFactory, targetDaoFactory, dbMeta, context));
                        progressionModel.increments(1);
                        while (!pendingOperations.isEmpty()) {
                            SynchroTableOperation operation = (SynchroTableOperation)pendingOperations.pop();
                            this.synchronizeOperation(operation, dbMeta, sourceDaoFactory, targetDaoFactory, context, result, pendingOperations);
                        }
                    }
                    finally {
                        this.releaseSynch(targetConnection, context);
                    }
                    if (log.isInfoEnabled()) {
                        long totalInserts = result.getTotalInserts();
                        long totalUpdates = result.getTotalUpdates();
                        long totalDeletes = result.getTotalDeletes();
                        long totalRejects = result.getTotalRejects();
                        log.info((Object)("Total root rows to treat: " + result.getTotalRows()));
                        log.info((Object)("Total rows inserted: " + totalInserts));
                        log.info((Object)("Total rows  updated: " + totalUpdates));
                        log.info((Object)("Total rows  deleted: " + totalDeletes));
                        log.info((Object)("Total rows rejected: " + totalRejects));
                        log.info((Object)("Total rows  treated: " + (totalInserts + totalUpdates + totalDeletes + totalRejects)));
                        if (totalRejects > 0L) {
                            log.warn((Object)String.format("Some rows has been rejected (%s rows)", totalRejects));
                        }
                    }
                    progressionModel.setMessage(I18n.t((String)"adagio.synchro.synchronize.step2", (Object[])new Object[0]));
                    progressionModel.setCurrent(progressionModel.getTotal());
                    if (target.isReadOnly()) {
                        log.error((Object)"Could not commit because database is set as readOnly in the configuration.");
                        targetConnection.rollback();
                        IOUtils.closeQuietly((Closeable)sourceDaoFactory);
                        break block17;
                    }
                    this.commit(targetConnection);
                    IOUtils.closeQuietly((Closeable)sourceDaoFactory);
                    break block18;
                }
                catch (Exception e) {
                    this.rollbackSilently(targetConnection);
                    this.updateResultOnSynchronizeError(e, result);
                    return;
                }
            }
            IOUtils.closeQuietly((Closeable)targetDaoFactory);
            this.closeSilently(sourceConnection);
            this.closeSilently(targetConnection);
            return;
        }
        IOUtils.closeQuietly((Closeable)targetDaoFactory);
        this.closeSilently(sourceConnection);
        this.closeSilently(targetConnection);
        return;
        finally {
            IOUtils.closeQuietly(sourceDaoFactory);
            IOUtils.closeQuietly(targetDaoFactory);
            this.closeSilently(sourceConnection);
            this.closeSilently(targetConnection);
        }
    }

    @Override
    public Timestamp getSourceLastUpdateDate(SynchroContext context) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Read max(update_date) on referential tables...");
        }
        SynchroDatabaseConfiguration source = context.getSource();
        source.setFullMetadataEnable(true);
        source.setReadOnly(true);
        Set<String> tableNames = context.getTableNames();
        if (CollectionUtils.isEmpty(tableNames)) {
            log.info((Object)I18n.t((String)"adagio.synchro.prepare.noTableFilter", (Object[])new Object[0]));
        }
        Preconditions.checkNotNull((Object)context.getResult());
        ProgressionModel progressionModel = context.getResult().getProgressionModel();
        progressionModel.setTotal(tableNames.size());
        Connection connection = null;
        try {
            progressionModel.setMessage(I18n.t((String)"adagio.synchro.referential.lastUpdateDate.step1", (Object[])new Object[0]));
            if (log.isDebugEnabled()) {
                log.debug((Object)I18n.t((String)"adagio.synchro.referential.lastUpdateDate.step1", (Object[])new Object[0]));
            }
            long t0 = TimeLog.getTime();
            connection = this.createConnection(source);
            SynchroDatabaseMetadata dbMeta = this.loadDatabaseMetadata(connection, source, tableNames);
            Set<String> rootTableNames = dbMeta.getLoadedRootTableNames();
            progressionModel.setTotal(rootTableNames.size());
            Timestamp result = null;
            for (String tableName : rootTableNames) {
                SynchroTableMetadata table;
                Timestamp updateDate;
                progressionModel.setMessage(I18n.t((String)"adagio.synchro.referential.lastUpdateDate.step2", (Object[])new Object[]{tableName}));
                if (log.isDebugEnabled()) {
                    log.debug((Object)I18n.t((String)"adagio.synchro.referential.lastUpdateDate.step2", (Object[])new Object[]{tableName}));
                }
                if (Daos.compareUpdateDates(result, updateDate = SynchroTableDaoUtils.getLastUpdateDate(table = dbMeta.getTable(tableName), connection)) < 0) {
                    result = updateDate;
                }
                progressionModel.increments(1);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Read last update_date on referential tables [%s] ", result));
                TIME.log(t0, "Read last update_date on referential tables");
            }
            Timestamp timestamp = result;
            this.closeSilently(connection);
            return timestamp;
        }
        catch (Exception e) {
            try {
                log.error((Object)"Error while reading last update_date on referential tables", (Throwable)e);
                throw new DataRetrievalFailureException("Error while reading last update_date on referential tables", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeSilently(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(SynchroContext synchroContext, SynchroResult serverExportResult, Map<RejectedRowStatus, RejectedRowStrategy> rejectStrategies) {
        Preconditions.checkNotNull((Object)synchroContext);
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(rejectStrategies));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finish (update source DB and resolve rejects with strateies %s): %s", rejectStrategies, synchroContext.toString()));
        }
        SynchroResult result = synchroContext.getResult();
        ProgressionModel progressionModel = result.getProgressionModel();
        SynchroDatabaseConfiguration target = synchroContext.getSource();
        target.setReadOnly(false);
        target.setFullMetadataEnable(true);
        target.setIsTarget(true);
        Set<String> tableNames = synchroContext.getTableNames();
        if (CollectionUtils.isEmpty(tableNames)) {
            log.info((Object)I18n.t((String)"adagio.synchro.prepare.noTableFilter", (Object[])new Object[0]));
        }
        Connection targetConnection = null;
        DaoFactoryImpl targetDaoFactory = null;
        try {
            targetConnection = this.createConnection(target);
            SynchroDatabaseMetadata dbMeta = this.loadDatabaseMetadata(targetConnection, target, tableNames);
            targetDaoFactory = this.newDaoFactory(targetConnection, target, dbMeta);
            ArrayDeque pendingOperations = Queues.newArrayDeque(this.getSourceMissingOperations(serverExportResult, synchroContext));
            if (serverExportResult.getRejectedRows() != null && !serverExportResult.getRejectedRows().isEmpty()) {
                this.resolveRejects(targetConnection, dbMeta, targetDaoFactory, synchroContext, serverExportResult.getRejectedRows(), rejectStrategies, pendingOperations);
            }
            progressionModel.setCurrent(0);
            progressionModel.setTotal(pendingOperations.size());
            while (!pendingOperations.isEmpty()) {
                SynchroTableOperation operation = (SynchroTableOperation)pendingOperations.pop();
                this.synchronizeOperation(operation, dbMeta, null, targetDaoFactory, synchroContext, result, pendingOperations);
            }
            this.commit(targetConnection);
            IOUtils.closeQuietly((Closeable)targetDaoFactory);
            this.closeSilently(targetConnection);
        }
        catch (Exception e) {
            this.rollbackSilently(targetConnection);
            result.setError(e);
        }
        finally {
            IOUtils.closeQuietly(targetDaoFactory);
            this.closeSilently(targetConnection);
        }
    }

    protected void setDaoCacheSize(int daoFactoryCacheSize) {
        this.daoCacheSize = daoFactoryCacheSize;
    }

    protected void setStatementCacheSize(int daoFactoryStatementCacheSize) {
        this.statementCacheSize = daoFactoryStatementCacheSize;
    }

    protected void checkSchemasAndExcludeMissingColumns(SynchroDatabaseConfiguration source, SynchroDatabaseConfiguration target, SynchroDatabaseMetadata sourceMeta, SynchroDatabaseMetadata targetMeta, boolean allowMissingOptionalColumn, boolean allowAdditionalMandatoryColumnInSourceSchema, SynchroResult result) {
        try {
            Set<String> columnExcludes = SynchroMetadataUtils.checkSchemas(sourceMeta, targetMeta, allowMissingOptionalColumn, allowAdditionalMandatoryColumnInSourceSchema);
            if (CollectionUtils.isNotEmpty(columnExcludes)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Some missing optional columns will be skipped: %s", columnExcludes));
                }
                source.addColumnExcludes(columnExcludes);
                target.addColumnExcludes(columnExcludes);
            }
        }
        catch (SynchroTechnicalException e) {
            result.setError(e);
        }
        catch (SynchroSchemaValidationException e) {
            log.error((Object)e.getMessage());
            result.setError(e);
        }
    }

    protected void reportProgress(SynchroResult result, SynchroTableDao dao, int countR, String tablePrefix) {
        if (dao.getCurrentOperation().isEnableProgress() && countR % this.batchSize == 0) {
            result.getProgressionModel().increments(this.batchSize);
        }
        if (countR % (this.batchSize * 10) == 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("%s Done: %s (inserts: %s, updates: %s deletes: %s)", tablePrefix, countR, dao.getInsertCount(), dao.getUpdateCount(), dao.getDeleteCount()));
        }
    }

    protected Connection createConnection(SynchroDatabaseConfiguration databaseConfiguration) throws SQLException {
        return this.createConnection(databaseConfiguration.getUrl(), databaseConfiguration.getUser(), databaseConfiguration.getPassword());
    }

    protected Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jdbcUrl));
        Connection connection = null;
        connection = this.isManagedByDataSource(jdbcUrl) && this.dataSource != null ? DataSourceUtils.getConnection((DataSource)this.dataSource) : DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    protected void closeSilently(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (this.isManagedByDataSource(connection) && this.dataSource != null) {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            } else {
                Daos.closeSilently(connection);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isManagedByDataSource(Connection connection) throws SQLException {
        String jdbcUrl = connection.getMetaData().getURL();
        return this.dataSource != null && this.isManagedByDataSource(jdbcUrl);
    }

    protected void commit(Connection connection) throws SQLException {
        if (connection == null) {
            return;
        }
        if (this.dataSource == null || !this.isManagedByDataSource(connection) || !DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
            connection.commit();
        }
    }

    protected void rollbackSilently(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (this.dataSource == null || !this.isManagedByDataSource(connection) || !DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
                connection.rollback();
            } else {
                TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected final Map<String, Object> getSelectBindings(SynchroContext context) {
        try {
            return (Map)this.defaultBindingCache.get((Object)context);
        }
        catch (ExecutionException e) {
            return ImmutableMap.copyOf(this.createDefaultSelectBindings(context));
        }
    }

    protected Map<String, Object> createDefaultSelectBindings(SynchroContext context) {
        HashMap defaultBinding = Maps.newHashMap();
        if (context.getLastSynchronizationDate() != null) {
            defaultBinding.put("updateDate", context.getLastSynchronizationDate());
        }
        return defaultBinding;
    }

    protected Map<String, Object> createSelectBindingsForTable(SynchroContext context, String tableName) {
        HashMap bindings = Maps.newHashMap(this.getSelectBindings(context));
        Timestamp tableUpdateDate = context.getResult().getUpdateDate(tableName);
        if (tableUpdateDate != null || context.getTarget().isMirrorDatabase()) {
            Timestamp lastSynchronizationDate = context.getLastSynchronizationDate();
            if (lastSynchronizationDate != null) {
                bindings.put("updateDate", lastSynchronizationDate);
            } else if (tableUpdateDate != null) {
                bindings.put("updateDate", tableUpdateDate);
            }
        }
        return bindings;
    }

    protected void disableIntegrityConstraints(Properties connectionProperties, SynchroResult result) {
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.disableIntegrityConstraints", (Object[])new Object[0]));
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"adagio.synchro.synchronize.disableIntegrityConstraints", (Object[])new Object[0]));
        }
        try {
            Daos.setIntegrityConstraints(connectionProperties, false);
        }
        catch (SynchroTechnicalException e) {
            result.setError(e);
        }
        catch (SQLException e) {
            result.setError(e);
        }
    }

    protected boolean isManagedByDataSource(String jdbcUrl) {
        return Objects.equals(this.config.getJdbcURL(), jdbcUrl);
    }

    protected SynchroDatabaseMetadata loadDatabaseMetadata(Connection connection, SynchroDatabaseConfiguration dbConfiguration, Set<String> tableNames) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loading database metadata... [%s]", dbConfiguration.getUrl()));
        }
        SynchroDatabaseMetadata result = SynchroDatabaseMetadata.loadDatabaseMetadata(connection, dbConfiguration, tableNames);
        return result;
    }

    protected DaoFactoryImpl newDaoFactory(Connection connection, SynchroDatabaseConfiguration dbConfig, SynchroDatabaseMetadata dbMeta) {
        return new DaoFactoryImpl(connection, dbConfig, dbMeta, this.daoCacheSize, this.statementCacheSize);
    }

    protected LoadingCache<SynchroContext, Map<String, Object>> initBindingCache(int maximumSize) {
        return CacheBuilder.newBuilder().maximumSize((long)maximumSize).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<SynchroContext, Map<String, Object>>(){

            public Map<String, Object> load(SynchroContext context) throws SQLException {
                return ImmutableMap.copyOf(SynchroServiceImpl.this.createDefaultSelectBindings(context));
            }
        });
    }

    protected final void synchronizeOperation(SynchroTableOperation operation, SynchroDatabaseMetadata targetMeta, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        block15: {
            boolean hasChildrenToDetach;
            block20: {
                boolean hasChildrenToDelete;
                block19: {
                    boolean hasChildrenToUpdate;
                    block18: {
                        boolean hasMissingDetachs;
                        block17: {
                            boolean hasMissingUpdates;
                            block16: {
                                boolean hasMissingDeletes;
                                block14: {
                                    long countToUpdate;
                                    boolean rootTableOperation;
                                    hasMissingUpdates = MapUtils.isNotEmpty(operation.getMissingUpdates());
                                    hasMissingDeletes = CollectionUtils.isNotEmpty(operation.getMissingDeletes());
                                    hasMissingDetachs = CollectionUtils.isNotEmpty(operation.getMissingDetachs());
                                    hasChildrenToUpdate = operation.hasChildrenToUpdate();
                                    hasChildrenToDelete = operation.hasChildrenToDelete();
                                    hasChildrenToDetach = operation.hasChildrenToDetach();
                                    boolean bl = rootTableOperation = !hasChildrenToUpdate && !hasChildrenToDelete && !hasMissingUpdates && !hasMissingDeletes && !hasMissingDetachs && !hasChildrenToDetach;
                                    if (!rootTableOperation) break block14;
                                    String tableName = operation.getTableName();
                                    SynchroTableMetadata table = targetMeta.getTable(tableName);
                                    long t0 = TimeLog.getTime();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Synchronize root table: " + tableName));
                                    }
                                    if ((countToUpdate = (long)result.getNbRows(tableName)) > 0L) {
                                        this.synchronizeRootTable(table, sourceDaoFactory, targetDaoFactory, context, result, operation, pendingOperations);
                                        TIME.log(t0, "synchronize root table " + tableName);
                                    }
                                    this.addToPendingOperationsIfNotEmpty(operation, pendingOperations, context);
                                    break block15;
                                }
                                if (!hasMissingDeletes) break block16;
                                String tableName = operation.getTableName();
                                SynchroTableMetadata table = targetMeta.getTable(tableName);
                                List<List<Object>> pksToDeletes = operation.getMissingDeletes();
                                operation.clearMissingDeletes();
                                long t0 = TimeLog.getTime();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Execute missing deletes on table: " + tableName));
                                }
                                this.synchronizeDeletes(operation, table, pksToDeletes, sourceDaoFactory, targetDaoFactory, context, result, pendingOperations);
                                TIME_DELETION.log(t0, "Execute update deletes reference on table " + tableName);
                                this.addToPendingOperationsIfNotEmpty(operation, pendingOperations, context);
                                break block15;
                            }
                            if (!hasMissingUpdates) break block17;
                            String tableName = operation.getTableName();
                            SynchroTableMetadata table = targetMeta.getTable(tableName);
                            Map<String, Map<String, Object>> missingUpdates = operation.getMissingUpdates();
                            operation.clearMissingUpdates();
                            long t0 = TimeLog.getTime();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Update missing references on table: " + tableName));
                            }
                            this.synchronizeColumnUpdates(operation, table, missingUpdates, sourceDaoFactory, targetDaoFactory, context, result, pendingOperations);
                            TIME.log(t0, "Update missing reference on table " + tableName);
                            this.addToPendingOperationsIfNotEmpty(operation, pendingOperations, context);
                            break block15;
                        }
                        if (!hasMissingDetachs) break block18;
                        String tableName = operation.getTableName();
                        SynchroTableMetadata table = targetMeta.getTable(tableName);
                        List<List<Object>> missingDetachs = operation.getMissingDetachs();
                        operation.clearMissingDetachs();
                        long t0 = TimeLog.getTime();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Detachs rows on table: " + tableName));
                        }
                        this.synchronizeDetachs(operation, table, missingDetachs, sourceDaoFactory, targetDaoFactory, context, result, pendingOperations);
                        TIME.log(t0, "Detachs rows on table " + tableName);
                        this.addToPendingOperationsIfNotEmpty(operation, pendingOperations, context);
                        break block15;
                    }
                    if (!hasChildrenToUpdate) break block19;
                    Map<String, Map<Set<String>, List<List<Object>>>> childrenToUpdate = operation.getChildrenToUpdate();
                    operation.clearChildrenToUpdate();
                    for (Map.Entry<String, Map<Set<String>, List<List<Object>>>> entry : childrenToUpdate.entrySet()) {
                        String tableName = entry.getKey();
                        Map<Set<String>, List<List<Object>>> childToUpdate = entry.getValue();
                        SynchroTableOperation childOperation = new SynchroTableOperation(tableName, context);
                        SynchroTableMetadata table = targetMeta.getLoadedTable(tableName);
                        long t0 = TimeLog.getTime();
                        if (table == null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Synchronize child table: %s (child of %s)", tableName, operation.getTableName()));
                        }
                        for (Set<String> columnNames : childToUpdate.keySet()) {
                            List<List<Object>> columnsValues = childToUpdate.get(columnNames);
                            this.synchronizeChildrenByFks(childOperation, table, columnNames, columnsValues, sourceDaoFactory, targetDaoFactory, context, result, pendingOperations);
                        }
                        TIME.log(t0, "synchronize child table " + tableName);
                        this.addToPendingOperationsIfNotEmpty(childOperation, pendingOperations, context);
                    }
                    break block15;
                }
                if (!hasChildrenToDelete) break block20;
                Map<String, Map<Set<String>, List<List<Object>>>> childrenTablesToDelete = operation.getChildrenToDelete();
                operation.clearChildrenToDelete();
                for (Map.Entry<String, Map<Set<String>, List<List<Object>>>> entry : childrenTablesToDelete.entrySet()) {
                    String tableName = entry.getKey();
                    Map<Set<String>, List<List<Object>>> childrenToDelete = entry.getValue();
                    SynchroTableOperation childOperation = new SynchroTableOperation(tableName, context);
                    SynchroTableMetadata table = targetMeta.getLoadedTable(tableName);
                    long t0 = TimeLog.getTime();
                    if (table == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Delete from child table: %s (child of %s)", tableName, operation.getTableName()));
                    }
                    for (Set<String> columnNames : childrenToDelete.keySet()) {
                        List<List<Object>> columnsValues = childrenToDelete.get(columnNames);
                        this.synchronizeChildrenToDeletes(childOperation, table, columnNames, columnsValues, sourceDaoFactory, targetDaoFactory, context, result, pendingOperations);
                    }
                    TIME_DELETION.log(t0, "delete child table " + tableName);
                }
                break block15;
            }
            if (!hasChildrenToDetach) break block15;
            Map<String, Map<Set<String>, List<List<Object>>>> childrenTablesToDetach = operation.getChildrenToDetach();
            operation.clearChildrenToDetach();
            for (Map.Entry<String, Map<Set<String>, List<List<Object>>>> entry : childrenTablesToDetach.entrySet()) {
                String tableName = entry.getKey();
                Map<Set<String>, List<List<Object>>> childrenToDetach = entry.getValue();
                SynchroTableOperation childOperation = new SynchroTableOperation(tableName, context);
                SynchroTableMetadata table = targetMeta.getLoadedTable(tableName);
                long t0 = TimeLog.getTime();
                if (table == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Detach from child table: %s (child of %s)", tableName, operation.getTableName()));
                }
                for (Set<String> columnNames : childrenToDetach.keySet()) {
                    List<List<Object>> columnsValues = childrenToDetach.get(columnNames);
                    this.synchronizeChildrenToDetach(childOperation, table, columnNames, columnsValues, sourceDaoFactory, targetDaoFactory, context, result, pendingOperations);
                }
                TIME.log(t0, "detach child table " + tableName);
                this.addToPendingOperationsIfNotEmpty(childOperation, pendingOperations, context);
            }
        }
    }

    protected final void addToPendingOperationsIfNotEmpty(SynchroTableOperation operation, Deque<SynchroTableOperation> pendingOperations, SynchroContext context) {
        boolean isEmpty;
        boolean hasChildToUpdate = MapUtils.isNotEmpty(operation.getChildrenToUpdate());
        boolean hasChildToDelete = MapUtils.isNotEmpty(operation.getChildrenToDelete());
        boolean hasChildToDetach = MapUtils.isNotEmpty(operation.getChildrenToDetach());
        boolean hasMissingUpdates = MapUtils.isNotEmpty(operation.getMissingUpdates());
        boolean hasMissingDeletes = CollectionUtils.isNotEmpty(operation.getMissingDeletes());
        boolean hasMissingDetach = CollectionUtils.isNotEmpty(operation.getMissingDetachs());
        boolean bl = !hasChildToUpdate && !hasChildToDelete && !hasMissingUpdates && !hasMissingDeletes && !hasMissingDetach & !hasChildToDetach ? true : (isEmpty = false);
        if (isEmpty) {
            return;
        }
        operation.setEnableProgress(false);
        if (hasChildToUpdate || hasChildToDelete) {
            if (!hasMissingUpdates && !hasMissingDeletes) {
                pendingOperations.addFirst(operation);
            } else {
                SynchroTableOperation newOperation;
                if (hasMissingUpdates) {
                    newOperation = new SynchroTableOperation(operation.getTableName(), context);
                    newOperation.addAllMissingColumnUpdates(operation.getMissingUpdates());
                    pendingOperations.add(newOperation);
                    operation.clearMissingUpdates();
                }
                if (hasMissingDeletes) {
                    newOperation = new SynchroTableOperation(operation.getTableName(), context);
                    newOperation.addAllMissingDelete(operation.getMissingDeletes());
                    pendingOperations.add(newOperation);
                    operation.clearMissingDeletes();
                }
                pendingOperations.addFirst(operation);
            }
        } else {
            pendingOperations.add(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void synchronizeRootTable(SynchroTableMetadata table, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, SynchroTableOperation operation, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        ResultSet dataToUpdate;
        block8: {
            String tableName = table.getName();
            boolean enableUpdateDate = table.isWithUpdateDateColumn();
            result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.step1", (Object[])new Object[]{tableName}));
            SynchroTableDao sourceDao = sourceDaoFactory.getSourceDao(table);
            SynchroTableDao targetDao = targetDaoFactory.getTargetDao(table, sourceDao, operation);
            dataToUpdate = null;
            try {
                long existingRowCount = targetDao.countAll(true);
                boolean doGetExistingPks = existingRowCount > 0L && existingRowCount <= 50000L;
                Set<Object> existingPks = null;
                Map<String, Timestamp> existingUpdateDates = null;
                if (doGetExistingPks) {
                    if (enableUpdateDate) {
                        existingUpdateDates = targetDao.getPksStrWithUpdateDate();
                        existingPks = existingUpdateDates.keySet();
                    } else {
                        existingPks = targetDao.getPksStr();
                    }
                } else if (existingRowCount == 0L) {
                    existingPks = Sets.newHashSet();
                }
                Map<String, Object> bindings = this.createSelectBindingsForTable(context, table.getName());
                dataToUpdate = sourceDao.getData(bindings);
                if (table.hasUniqueConstraints()) {
                    this.updateTableWithUniqueConstraints(sourceDao, targetDao, dataToUpdate, existingPks, false, existingUpdateDates, context, result, pendingOperations);
                    break block8;
                }
                this.updateTable(targetDao, dataToUpdate, existingPks, false, existingUpdateDates, context, result, pendingOperations);
            }
            catch (Throwable throwable) {
                Daos.closeSilently(dataToUpdate);
                throw throwable;
            }
        }
        Daos.closeSilently(dataToUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeChildrenByFks(SynchroTableOperation operation, SynchroTableMetadata table, Set<String> fkColumnNames, List<List<Object>> fkSourceColumnValues, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        ResultSet dataToUpdate;
        block7: {
            String tableName = table.getName();
            boolean enableUpdateDate = table.isWithUpdateDateColumn() && table.isRoot();
            result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.step1", (Object[])new Object[]{tableName}));
            SynchroTableDao sourceDao = sourceDaoFactory.getSourceDao(table);
            SynchroTableDao targetDao = targetDaoFactory.getTargetDao(table, sourceDao, operation);
            Map<String, Object> bindings = this.createSelectBindingsForTable(context, tableName);
            dataToUpdate = null;
            try {
                long existingRowCount = targetDao.countAll(true);
                Set<Object> existingPks = null;
                Map<String, Timestamp> existingUpdateDates = null;
                if (existingRowCount > 0L) {
                    Set<String> fkTargetColumnNames = targetDao.transformColumnNames(fkColumnNames);
                    List<List<Object>> fkTargetColumnValues = targetDao.transformOnRead(fkColumnNames, fkSourceColumnValues);
                    if (enableUpdateDate) {
                        existingUpdateDates = targetDao.getPksStrWithUpdateDateByFks(fkTargetColumnNames, fkTargetColumnValues, bindings);
                        existingPks = existingUpdateDates.keySet();
                    } else {
                        existingPks = targetDao.getPksStrByFks(fkTargetColumnNames, fkTargetColumnValues, bindings);
                    }
                }
                if (existingPks == null) {
                    existingPks = Sets.newHashSet();
                }
                dataToUpdate = sourceDao.getDataByFks(fkColumnNames, fkSourceColumnValues, bindings);
                if (table.hasUniqueConstraints()) {
                    this.updateTableWithUniqueConstraints(sourceDao, targetDao, dataToUpdate, existingPks, true, existingUpdateDates, context, result, pendingOperations);
                    break block7;
                }
                this.updateTable(targetDao, dataToUpdate, existingPks, true, existingUpdateDates, context, result, pendingOperations);
            }
            catch (Throwable throwable) {
                Daos.closeSilently(dataToUpdate);
                throw throwable;
            }
        }
        Daos.closeSilently(dataToUpdate);
    }

    protected final void synchronizeChildrenToDeletes(SynchroTableOperation operation, SynchroTableMetadata table, Set<String> fkColumnNames, List<List<Object>> fkColumnValues, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        String tableName = table.getName();
        boolean hasChildTables = table.hasChildJoins();
        boolean checkPkNotUsed = this.isCheckPkNotUsedBeforeDelete(context);
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.step5", (Object[])new Object[]{tableName}));
        SynchroTableDao sourceDao = sourceDaoFactory.getSourceDao(table);
        SynchroTableDao targetDao = targetDaoFactory.getTargetDao(table, sourceDao, operation);
        Map<String, Object> bindings = this.createSelectBindingsForTable(context, tableName);
        List<List<Object>> pksToDelete = targetDao.getPksByFks(fkColumnNames, fkColumnValues, bindings);
        if (CollectionUtils.isNotEmpty(pksToDelete)) {
            if (hasChildTables) {
                operation.addAllMissingDelete(pksToDelete);
                pendingOperations.addFirst(operation);
                this.addDeleteChildrenToDeque(table, pksToDelete, pendingOperations, context);
            } else {
                this.deleteRows(targetDao, pksToDelete, checkPkNotUsed, context, result, pendingOperations);
                this.addToPendingOperationsIfNotEmpty(operation, pendingOperations, context);
            }
        }
    }

    protected final void synchronizeChildrenToDetach(SynchroTableOperation operation, SynchroTableMetadata table, Set<String> fkColumnNames, List<List<Object>> fkColumnValues, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        Map<String, Object> bindings;
        SynchroTableDao targetDao;
        List<List<Object>> pksToDetach;
        String tableName = table.getName();
        boolean hasChildTables = table.hasChildJoins();
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.step6", (Object[])new Object[]{tableName}));
        SynchroTableDao sourceDao = null;
        if (sourceDaoFactory != null) {
            sourceDao = sourceDaoFactory.getSourceDao(table);
        }
        if (CollectionUtils.isNotEmpty(pksToDetach = (targetDao = targetDaoFactory.getTargetDao(table, sourceDao, operation)).getPksByFks(fkColumnNames, fkColumnValues, bindings = this.createSelectBindingsForTable(context, tableName)))) {
            this.detachRows(targetDao, pksToDetach, context, result, pendingOperations);
            if (hasChildTables) {
                this.addDetachChildrenToDeque(table, pksToDetach, pendingOperations, context);
            }
        }
    }

    protected void synchronizeColumnUpdates(SynchroTableOperation operation, SynchroTableMetadata table, Map<String, Map<String, Object>> columnUpdatesByPkStr, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        String tableName = table.getName();
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.step4", (Object[])new Object[]{tableName}));
        SynchroTableDao sourceDao = null;
        if (sourceDaoFactory != null) {
            sourceDao = sourceDaoFactory.getSourceDao(table);
        }
        SynchroTableDao targetDao = targetDaoFactory.getTargetDao(table, sourceDao, operation);
        for (String columnName : columnUpdatesByPkStr.keySet()) {
            Map<String, Object> valuesByPkStr = columnUpdatesByPkStr.get(columnName);
            this.updateColumn(targetDao, columnName, valuesByPkStr, result, pendingOperations);
        }
    }

    protected void synchronizeDetachs(SynchroTableOperation operation, SynchroTableMetadata table, List<List<Object>> pksToDetach, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        String tableName = table.getName();
        boolean hasChildJoin = table.hasChildJoins();
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.step6", (Object[])new Object[]{tableName}));
        SynchroTableDao sourceDao = null;
        if (sourceDaoFactory != null) {
            sourceDao = sourceDaoFactory.getSourceDao(table);
        }
        SynchroTableDao targetDao = targetDaoFactory.getTargetDao(table, sourceDao, operation);
        this.detachRows(targetDao, pksToDetach, context, result, pendingOperations);
        if (hasChildJoin) {
            this.addDetachChildrenToDeque(table, pksToDetach, pendingOperations, context);
        }
    }

    protected final void synchronizeDeletes(SynchroTableOperation operation, SynchroTableMetadata table, List<List<Object>> pksToDelete, DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        String tableName = table.getName();
        boolean checkPkNotUsed = this.isCheckPkNotUsedBeforeDelete(context);
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronize.step3", (Object[])new Object[]{tableName}));
        SynchroTableDao sourceDao = null;
        if (sourceDaoFactory != null) {
            sourceDao = sourceDaoFactory.getSourceDao(table);
        }
        SynchroTableDao targetDao = targetDaoFactory.getTargetDao(table, sourceDao, operation);
        this.deleteRows(targetDao, pksToDelete, checkPkNotUsed, context, result, pendingOperations);
    }

    protected final void updateTableWithUniqueConstraints(SynchroTableDao sourceDao, SynchroTableDao targetDao, ResultSet incomingData, Set<String> existingPks, boolean deleteExtraRows, Map<String, Timestamp> existingUpdateDates, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        SynchroTableMetadata table = targetDao.getTable();
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(table.getUniqueConstraints()));
        boolean hasChildTables = table.hasChildJoins();
        boolean checkUpdateDate = table.isWithUpdateDateColumn() && table.isRoot();
        boolean allowSkipRow = targetDao.getCurrentOperation().isEnableProgress();
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        Map<String, SynchroTableMetadata.DuplicateKeyStrategy> duplicateKeyStrategies = table.getDuplicatKeyStrategies();
        boolean isTableEmpty = targetDao.countAll(true) == 0L;
        ArrayList processedSourcePks = null;
        if (hasChildTables) {
            processedSourcePks = Lists.newArrayList();
        }
        HashSet targetPksStrToRemove = Sets.newHashSet();
        if (deleteExtraRows && existingPks != null) {
            targetPksStrToRemove.addAll(existingPks);
        }
        result.addTableName(tableName);
        int countR = 0;
        while (incomingData.next()) {
            List<Object> sourcePk;
            boolean hasDuplicateKey;
            List<Object> pk = null;
            boolean skipRow = false;
            Map<String, List<Object>> duplicatedKeys = null;
            if (!isTableEmpty) {
                duplicatedKeys = targetDao.getPkFromUniqueConstraints(incomingData);
            }
            if (hasDuplicateKey = MapUtils.isNotEmpty(duplicatedKeys)) {
                HashMap duplicatedKeysRejected = Maps.newHashMap();
                for (Map.Entry<String, List<Object>> entry : duplicatedKeys.entrySet()) {
                    SynchroTableMetadata.DuplicateKeyStrategy strategy = duplicateKeyStrategies.get(entry.getKey());
                    List<Object> rowPk = entry.getValue();
                    switch (strategy) {
                        case WARN: {
                            log.warn((Object)String.format("%s Duplicate key (%s): [%s]", tablePrefix, entry.getKey(), rowPk));
                            break;
                        }
                        case REPLACE: {
                            if (this.debug) {
                                log.trace((Object)String.format("%s Duplicate key (%s): [%s] - will try to update this row", tablePrefix, entry.getKey(), rowPk));
                            }
                            pk = rowPk;
                            break;
                        }
                        case REJECT: {
                            duplicatedKeysRejected.put(entry.getKey(), rowPk);
                        }
                    }
                }
                for (Map.Entry<String, List<Object>> entry : duplicatedKeysRejected.entrySet()) {
                    List<Object> rowPk = entry.getValue();
                    if (pk != null && pk.equals(rowPk)) continue;
                    if (this.debug) {
                        log.trace((Object)String.format("%s Duplicate key (%s): [%s] - will reject this row", tablePrefix, entry.getKey(), rowPk));
                    }
                    String rowPkStr = SynchroTableMetadata.toPkStr(rowPk);
                    targetPksStrToRemove.remove(rowPkStr);
                    skipRow = true;
                    break;
                }
            }
            if (skipRow) {
                this.rejectDuplicatedRow(tableName, sourceDao, incomingData, result);
                if (!allowSkipRow) {
                    sourcePk = targetDao.getPk(incomingData);
                    throw new SynchroDuplicateRowException(tableName, sourcePk, pk);
                }
            } else {
                boolean doUpdate;
                boolean bl = doUpdate = pk != null;
                if (doUpdate) {
                    String pkStr = SynchroTableMetadata.toPkStr(pk);
                    targetPksStrToRemove.remove(pkStr);
                    if (!targetDao.lock(pk)) {
                        this.rejectLockedRow(tableName, sourceDao, incomingData, result);
                        skipRow = true;
                    } else if (checkUpdateDate) {
                        Timestamp timestamp = targetDao.getUpdateDate(incomingData, true);
                        Timestamp existingUpdateDate = null;
                        existingUpdateDate = existingUpdateDates != null ? existingUpdateDates.get(pkStr) : targetDao.getUpdateDateByPk(pk);
                        int updateDateCompare = Daos.compareUpdateDates(existingUpdateDate, timestamp);
                        if (updateDateCompare == 0) {
                            if (this.debug) {
                                log.trace((Object)String.format("%s row is up to date: [%s] - will skip this row", tablePrefix, pkStr));
                            }
                            skipRow = true;
                        } else {
                            Timestamp incomingUpdateDate = targetDao.getUpdateDate(incomingData, false);
                            updateDateCompare = Daos.compareUpdateDates(existingUpdateDate, incomingUpdateDate);
                            if (updateDateCompare > 0) {
                                this.rejectBadUpdateDateRow(tableName, sourceDao, incomingData, existingUpdateDate, pkStr, result);
                                if (this.debug) {
                                    log.trace((Object)String.format("%s row has incorrect update_date: [%s] - will reject this row (expected update_date: '%s' but found: '%s')", tablePrefix, pkStr, existingUpdateDate, incomingUpdateDate));
                                }
                                skipRow = true;
                            } else if (this.debug) {
                                log.trace((Object)String.format("%s row is older in target DB: [%s] - row will be updated (new update_date: '%s')", tablePrefix, pkStr, incomingUpdateDate));
                            }
                        }
                    }
                    if (!skipRow) {
                        targetDao.executeUpdate(pk, incomingData);
                    }
                } else {
                    try {
                        targetDao.executeInsert(incomingData);
                    }
                    catch (SynchroRejectRowException re) {
                        if (!allowSkipRow) {
                            throw re;
                        }
                        this.rejectRow(re, result);
                        skipRow = true;
                    }
                }
            }
            if (!skipRow && hasChildTables) {
                sourcePk = targetDao.getPk(incomingData);
                processedSourcePks.add(sourcePk);
            }
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        targetDao.flush();
        if (CollectionUtils.isNotEmpty((Collection)targetPksStrToRemove)) {
            List<List<Object>> targetPksToRemove = SynchroTableMetadata.fromPksStr(targetPksStrToRemove);
            if (hasChildTables) {
                targetDao.getCurrentOperation().addAllMissingDelete(targetPksToRemove);
                this.addDeleteChildrenToDeque(table, targetPksToRemove, pendingOperations, context);
            } else {
                this.deleteRows(targetDao, targetPksToRemove, this.isCheckPkNotUsedBeforeDelete(context), context, result, pendingOperations);
            }
        }
        if (hasChildTables && CollectionUtils.isNotEmpty((Collection)processedSourcePks)) {
            this.addChildrenToDeque(table, processedSourcePks, pendingOperations, context);
        }
        int insertCount = targetDao.getInsertCount();
        int updateCount = targetDao.getUpdateCount();
        int deleteCount = targetDao.getDeleteCount();
        result.addInserts(tableName, insertCount);
        result.addUpdates(tableName, updateCount);
        result.addDeletes(tableName, deleteCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s, updates: %s, delete: %s)", tablePrefix, insertCount + updateCount + deleteCount, insertCount, updateCount, deleteCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, insertCount));
            log.debug((Object)String.format("%s UPDATE count: %s", tablePrefix, updateCount));
            log.debug((Object)String.format("%s DELETE count: %s", tablePrefix, deleteCount));
        }
        if (targetDao.getCurrentOperation().isEnableProgress()) {
            result.getProgressionModel().increments(countR % this.batchSize);
        }
    }

    protected final void updateTable(SynchroTableDao targetDao, ResultSet incomingData, Set<String> existingPks, boolean deleteExtraRows, Map<String, Timestamp> existingUpdateDates, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        boolean isTableEmpty;
        SynchroTableMetadata table = targetDao.getTable();
        Preconditions.checkArgument((boolean)MapUtils.isEmpty(table.getUniqueConstraints()));
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        boolean enableUpdateDateCheck = table.isWithUpdateDateColumn() && table.isRoot();
        boolean hasChildTables = table.hasChildJoins();
        ArrayList processedTargetPks = Lists.newArrayList();
        long existingRowCount = existingPks != null ? (long)existingPks.size() : targetDao.countAll(true);
        boolean bl = isTableEmpty = existingRowCount == 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " existing rows: " + existingRowCount));
        }
        ArrayList updatedPks = null;
        if (hasChildTables) {
            updatedPks = Lists.newArrayList();
        }
        HashSet targetPksStrToRemove = Sets.newHashSet();
        if (deleteExtraRows && existingPks != null) {
            targetPksStrToRemove.addAll(existingPks);
        }
        result.addTableName(tableName);
        int countR = 0;
        while (incomingData.next()) {
            List<Object> pk = targetDao.getPk(incomingData, true);
            String pkStr = SynchroTableMetadata.toPkStr(pk);
            boolean doUpdate = false;
            if (!isTableEmpty) {
                doUpdate = existingPks != null ? existingPks.contains(pkStr) : targetDao.exists(pk);
            }
            boolean skipRow = false;
            if (doUpdate) {
                targetPksStrToRemove.remove(pkStr);
                if (enableUpdateDateCheck) {
                    Timestamp transformedIncomingUpdateDate = targetDao.getUpdateDate(incomingData, true);
                    Timestamp existingUpdateDate = null;
                    existingUpdateDate = existingUpdateDates != null ? existingUpdateDates.get(pkStr) : targetDao.getUpdateDateByPk(pk);
                    int updateDateCompare = Daos.compareUpdateDates(existingUpdateDate, transformedIncomingUpdateDate);
                    if (updateDateCompare == 0) {
                        skipRow = true;
                    } else {
                        Timestamp incomingUpdateDate = targetDao.getUpdateDate(incomingData, false);
                        updateDateCompare = Daos.compareUpdateDates(existingUpdateDate, incomingUpdateDate);
                        if (updateDateCompare > 0) {
                            this.rejectBadUpdateDateRow(tableName, targetDao, incomingData, existingUpdateDate, pkStr, result);
                            skipRow = true;
                        } else if (this.debug) {
                            log.trace((Object)String.format("%s row is older in target DB: [%s] - row will be updated (new update_date: '%s')", tablePrefix, pkStr, incomingUpdateDate));
                        }
                    }
                }
                if (!skipRow) {
                    targetDao.executeUpdate(pk, incomingData);
                }
            } else {
                targetDao.executeInsert(incomingData);
            }
            if (!skipRow) {
                if (hasChildTables) {
                    List<Object> incomingPk = targetDao.getPk(incomingData);
                    updatedPks.add(incomingPk);
                }
                if (!isTableEmpty && pk != null) {
                    processedTargetPks.add(pk);
                }
            }
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        if (CollectionUtils.isNotEmpty((Collection)targetPksStrToRemove)) {
            List<List<Object>> targetPksToRemove = SynchroTableMetadata.fromPksStr(targetPksStrToRemove);
            if (hasChildTables) {
                targetDao.getCurrentOperation().addAllMissingDelete(targetPksToRemove);
                this.addDeleteChildrenToDeque(table, targetPksToRemove, pendingOperations, context);
            } else {
                for (List<Object> pk : targetPksToRemove) {
                    targetDao.executeDelete(pk, this.isCheckPkNotUsedBeforeDelete(context));
                    this.reportProgress(result, targetDao, ++countR, tablePrefix);
                }
            }
        }
        targetDao.flush();
        if (hasChildTables && CollectionUtils.isNotEmpty((Collection)updatedPks)) {
            this.addChildrenToDeque(table, updatedPks, pendingOperations, context);
        }
        int insertCount = targetDao.getInsertCount();
        int updateCount = targetDao.getUpdateCount();
        int deleteCount = targetDao.getDeleteCount();
        result.addInserts(tableName, insertCount);
        result.addUpdates(tableName, updateCount);
        result.addDeletes(tableName, deleteCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s, updates: %s, delete: %s)", tablePrefix, insertCount + updateCount + deleteCount, insertCount, updateCount, deleteCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, insertCount));
            log.debug((Object)String.format("%s UPDATE count: %s", tablePrefix, updateCount));
            log.debug((Object)String.format("%s DELETE count: %s", tablePrefix, deleteCount));
        }
        if (targetDao.getCurrentOperation().isEnableProgress()) {
            result.getProgressionModel().increments(countR % this.batchSize);
        }
    }

    protected void deleteRows(SynchroTableDao targetDao, List<List<Object>> pks, boolean checkPkNotUsedBeforeDelete, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(pks));
        SynchroTableMetadata table = targetDao.getTable();
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        SynchroTableOperation operation = targetDao.getCurrentOperation();
        result.addTableName(tableName);
        int countR = 0;
        for (List<Object> pk : pks) {
            try {
                targetDao.executeDelete(pk, checkPkNotUsedBeforeDelete);
                this.reportProgress(result, targetDao, ++countR, tablePrefix);
            }
            catch (DataIntegrityViolationOnDeleteException e) {
                boolean retryLater;
                boolean bl = retryLater = operation.isAllowMissingDeletes() && this.hasProcessedTable(e.getExistingFkTableNames(), context);
                if (!retryLater) {
                    throw e;
                }
                operation.setAllowMissingDeletes(false);
                operation.addMissingDelete(pk);
            }
        }
        targetDao.flush();
        int deleteCount = targetDao.getDeleteCount();
        result.addDeletes(tableName, deleteCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (deletes: %s)", tablePrefix, deleteCount, deleteCount));
        }
        if (targetDao.getCurrentOperation().isEnableProgress()) {
            result.getProgressionModel().increments(countR % this.batchSize);
        }
    }

    protected void updateColumn(SynchroTableDao targetDao, String columnName, Map<String, Object> valuesByPkStr, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(valuesByPkStr));
        SynchroTableMetadata table = targetDao.getTable();
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        result.addTableName(tableName);
        int countR = 0;
        for (Map.Entry<String, Object> entry : valuesByPkStr.entrySet()) {
            if (entry.getKey() == null) continue;
            List<Object> pk = SynchroTableMetadata.fromPkStr(entry.getKey());
            Object columnValue = entry.getValue();
            targetDao.executeUpdateColumn(columnName, pk, columnValue);
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        targetDao.flush();
        int updateCount = targetDao.getUpdateColumnCount(columnName);
        result.addUpdates(tableName, updateCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (updates: %s)", tablePrefix, updateCount, updateCount));
        }
        if (targetDao.getCurrentOperation().isEnableProgress()) {
            result.getProgressionModel().increments(countR % this.batchSize);
        }
    }

    protected void detachRows(SynchroTableDao targetDao, List<List<Object>> pks, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        SynchroTableMetadata table = targetDao.getTable();
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        result.addTableName(tableName);
        int countR = 0;
        for (List<Object> pk : pks) {
            targetDao.executeDetach(pk);
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        targetDao.flush();
        result.addUpdates(tableName, countR);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (detach: %s)", tablePrefix, countR, countR));
        }
        if (targetDao.getCurrentOperation().isEnableProgress()) {
            result.getProgressionModel().increments(countR % this.batchSize);
        }
    }

    protected final void rejectDuplicatedRow(String tableName, SynchroTableDao sourceDao, ResultSet incomingData, SynchroResult result) throws SQLException {
        List<Object> sourcePk = sourceDao.getPk(incomingData);
        String sourcePkStr = SynchroTableMetadata.toPkStr(sourcePk);
        result.addReject(tableName, sourcePkStr, RejectedRowStatus.DUPLICATE_KEY.name());
    }

    protected final void rejectLockedRow(String tableName, SynchroTableDao sourceDao, ResultSet incomingData, SynchroResult result) throws SQLException {
        List<Object> sourcePk = sourceDao.getPk(incomingData);
        String sourcePkStr = SynchroTableMetadata.toPkStr(sourcePk);
        result.addReject(tableName, sourcePkStr, RejectedRowStatus.LOCKED.name());
    }

    protected final void rejectBadUpdateDateRow(String tableName, SynchroTableDao sourceDao, ResultSet incomingData, Timestamp validUpdateDate, String targetPkStr, SynchroResult result) throws SQLException {
        List<Object> sourcePk = sourceDao.getPk(incomingData);
        String sourcePkStr = SynchroTableMetadata.toPkStr(sourcePk);
        this.rejectBadUpdateDateRow(tableName, sourcePkStr, validUpdateDate, targetPkStr, result);
    }

    protected final void rejectBadUpdateDateRow(String tableName, String sourcePkStr, Timestamp validUpdateDate, String targetPkStr, SynchroResult result) throws SQLException {
        result.addReject(tableName, sourcePkStr, RejectedRowStatus.BAD_UPDATE_DATE.name(), validUpdateDate.toString(), targetPkStr);
    }

    protected final void rejectRow(SynchroRejectRowException error, SynchroResult result) throws SQLException {
        Preconditions.checkNotNull((Object)error);
        if (error instanceof SynchroDeletedRowException) {
            SynchroDeletedRowException e = (SynchroDeletedRowException)error;
            result.addReject(e.getTableName(), e.getSourcePkStr(), RejectedRowStatus.DELETED.name(), e.getTargetPkStr());
            return;
        }
        throw new SynchroTechnicalException(String.format("Unknown reject exception class: %s", error.getClass().getName()));
    }

    protected List<SynchroTableOperation> getRootOperations(DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroDatabaseMetadata dbMeta, SynchroContext context) throws SQLException {
        Set<String> rootTableNames = dbMeta.getLoadedRootTableNames();
        ArrayList result = Lists.newArrayListWithCapacity((int)rootTableNames.size());
        for (String rootTableName : rootTableNames) {
            SynchroTableOperation operation = new SynchroTableOperation(rootTableName, context);
            operation.setEnableProgress(true);
            result.add(operation);
        }
        return result;
    }

    protected void prepareRootTable(DaoFactoryImpl sourceDaoFactory, DaoFactoryImpl targetDaoFactory, SynchroTableMetadata table, SynchroContext context, SynchroResult result) throws SQLException {
        String tablePrefix = table.getTableLogPrefix();
        String tableName = table.getName();
        SynchroTableDao sourceDao = sourceDaoFactory.getSourceDao(table);
        SynchroTableDao targetDao = targetDaoFactory.getTargetDao(table, sourceDao, null);
        boolean skipGetLastUpdateDate = context.getTarget().isMirrorDatabase() || targetDao.countAll(true) > 50000L;
        Timestamp updateDate = null;
        if (!skipGetLastUpdateDate && (updateDate = targetDao.getLastUpdateDate()) != null) {
            updateDate = new Timestamp(DateUtils.setMilliseconds((Date)updateDate, (int)0).getTime());
            updateDate = new Timestamp(DateUtils.addSeconds((Date)updateDate, (int)1).getTime());
        }
        result.setUpdateDate(tableName, updateDate);
        Map<String, Object> bindings = this.createSelectBindingsForTable(context, tableName);
        long countToUpdate = sourceDao.countData(bindings);
        result.addRows(tableName, (int)countToUpdate);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s nb rows to update: %s", tablePrefix, countToUpdate));
        }
    }

    protected void releaseContext(SynchroContext context) {
        context.setSourceMeta(null);
        context.setTargetMeta(null);
    }

    protected void prepareSynch(Connection targetConnection, SynchroContext context) throws SQLException {
        if (this.disableIntegrityConstraints || context.getTarget().isMirrorDatabase()) {
            Daos.setIntegrityConstraints(targetConnection, false);
        }
    }

    protected void releaseSynch(Connection targetConnection, SynchroContext context) throws SQLException {
        if (this.disableIntegrityConstraints) {
            if (context.getLastSynchronizationDate() != null && context.getTarget().isMirrorDatabase()) {
                return;
            }
            Daos.setIntegrityConstraints(targetConnection, true);
        }
    }

    protected final void addChildrenToDeque(SynchroTableMetadata parentTable, List<List<Object>> parentPks, Deque<SynchroTableOperation> pendingOperations, SynchroContext context) {
        Set<String> pkNames = parentTable.getPkNames();
        if (pkNames.size() > 1) {
            throw new UnsupportedOperationException("Not sure of this implementation: please check before comment out this exception !");
        }
        for (SynchroJoinMetadata join : parentTable.getChildJoins()) {
            SynchroTableMetadata childTable = join.getTargetTable();
            SynchroColumnMetadata childTableColumn = join.getTargetColumn();
            SynchroTableOperation operation = new SynchroTableOperation(parentTable.getName(), childTable.getName(), childTableColumn.getName(), parentPks, context);
            pendingOperations.addFirst(operation);
        }
    }

    protected final void addDeleteChildrenToDeque(SynchroTableMetadata parentTable, List<List<Object>> parentPks, Deque<SynchroTableOperation> pendingOperations, SynchroContext context) {
        Set<String> pkNames = parentTable.getPkNames();
        if (pkNames.size() > 1) {
            throw new UnsupportedOperationException("Not sure of this implementation: please check before comment out this exception !");
        }
        for (SynchroJoinMetadata join : parentTable.getChildJoins()) {
            SynchroTableMetadata childTable = join.getTargetTable();
            SynchroColumnMetadata childTableColumn = join.getTargetColumn();
            SynchroTableOperation operation = new SynchroTableOperation(parentTable.getName(), context);
            operation.addChildrenToDeleteFromManyColumns(childTable.getName(), (Set<String>)ImmutableSet.of((Object)childTableColumn.getName()), parentPks);
            pendingOperations.addFirst(operation);
        }
    }

    protected final void addDetachChildrenToDeque(SynchroTableMetadata parentTable, List<List<Object>> parentPks, Deque<SynchroTableOperation> pendingOperations, SynchroContext context) {
        Set<String> pkNames = parentTable.getPkNames();
        if (pkNames.size() > 1) {
            throw new UnsupportedOperationException("Not sure of this implementation: please check before comment out this exception !");
        }
        for (SynchroJoinMetadata join : parentTable.getChildJoins()) {
            SynchroTableMetadata childTable = join.getTargetTable();
            SynchroColumnMetadata childTableColumn = join.getTargetColumn();
            SynchroTableOperation operation = new SynchroTableOperation(parentTable.getName(), context);
            operation.addChildrenToDetachFromManyColumns(childTable.getName(), (Set<String>)ImmutableSet.of((Object)childTableColumn.getName()), parentPks);
            pendingOperations.addFirst(operation);
        }
    }

    protected List<SynchroTableOperation> getSourceMissingOperations(SynchroResult synchroResult, SynchroContext context) {
        SynchroTableOperation operation;
        ArrayList result = Lists.newArrayList();
        if (MapUtils.isNotEmpty(synchroResult.getSourceMissingUpdates())) {
            for (Map.Entry<String, Map<String, Map<String, Object>>> entry : synchroResult.getSourceMissingUpdates().entrySet()) {
                String tableName = entry.getKey();
                Map<String, Map<String, Object>> tableMissingUpdates = entry.getValue();
                operation = new SynchroTableOperation(tableName, context);
                operation.addAllMissingColumnUpdates(tableMissingUpdates);
                result.add(operation);
            }
        }
        if (synchroResult.getSourceMissingDeletes() != null && !synchroResult.getSourceMissingDeletes().isEmpty()) {
            for (String tableName : synchroResult.getSourceMissingDeletes().keySet()) {
                Collection pkStrs = synchroResult.getSourceMissingDeletes().get((Object)tableName);
                ArrayList pks = Lists.newArrayList();
                for (String pkStr : pkStrs) {
                    List<Object> pk = SynchroTableMetadata.fromPkStr(pkStr);
                    pks.add(pk);
                }
                operation = new SynchroTableOperation(tableName, context);
                operation.addAllMissingDelete(pks);
                result.add(operation);
            }
        }
        return result;
    }

    protected void resolveRejects(Connection targetConnection, SynchroDatabaseMetadata dbMeta, DaoFactoryImpl targetDaoFactory, SynchroContext context, Map<String, String> rejects, Map<RejectedRowStatus, RejectedRowStrategy> rejectStrategies, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        Preconditions.checkNotNull(rejects);
        Preconditions.checkNotNull(rejectStrategies);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resolving rejects with strategies %s - %s", rejectStrategies, context.toString()));
        }
        SynchroResult result = context.getResult();
        for (Map.Entry<String, String> entry : rejects.entrySet()) {
            String tableName = entry.getKey();
            String tableRejects = entry.getValue();
            SynchroTableMetadata table = dbMeta.getTable(tableName);
            this.resolveTableRejects(table, tableRejects, rejectStrategies, targetDaoFactory, context, result, pendingOperations);
        }
    }

    protected void resolveTableRejects(SynchroTableMetadata table, String rejectsRows, Map<RejectedRowStatus, RejectedRowStrategy> strategies, DaoFactoryImpl daoFactory, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        String tableName = table.getName();
        ProgressionModel progressionModel = result.getProgressionModel();
        progressionModel.setMessage(I18n.t((String)"adagio.synchro.data.finish.step1", (Object[])new Object[]{tableName}));
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"adagio.synchro.data.finish.step1", (Object[])new Object[]{tableName}));
        }
        SynchroTableOperation operation = new SynchroTableOperation(tableName, context);
        for (String rejectRow : Splitter.on((String)"\n").omitEmptyStrings().split((CharSequence)rejectsRows)) {
            String[] rejectInfos = rejectRow.split(";");
            String pkStr = rejectInfos[0];
            RejectedRowStatus rejectStatus = RejectedRowStatus.valueOf(rejectInfos[1]);
            RejectedRowStrategy rejectStrategy = strategies.get((Object)rejectStatus);
            if (rejectStrategy == null) {
                rejectStrategy = RejectedRowStrategy.DO_NOTHING;
            }
            this.resolveTableRow(table, pkStr, rejectInfos, rejectStatus, rejectStrategy, operation, context, result);
        }
        this.addToPendingOperationsIfNotEmpty(operation, pendingOperations, context);
    }

    protected void resolveTableRow(SynchroTableMetadata table, String pkStr, String[] rejectInfos, RejectedRowStatus rejectStatus, RejectedRowStrategy rejectStrategy, SynchroTableOperation operation, SynchroContext context, SynchroResult result) {
        String tableName = table.getName();
        switch (rejectStatus) {
            case BAD_UPDATE_DATE: {
                Timestamp updateDate = Timestamp.valueOf(rejectInfos[2]);
                switch (rejectStrategy) {
                    case KEEP_LOCAL: {
                        if (this.debug) {
                            log.debug((Object)String.format("[%s] Bad update date [pk=%s]: need update_date=%s", tableName, pkStr, updateDate));
                        }
                        operation.addMissingColumnUpdate(context.getTarget().getColumnUpdateDate(), pkStr, (Object)updateDate);
                        break;
                    }
                    case UPDATE: {
                        String targetPkStr;
                        String string = targetPkStr = rejectInfos.length < 4 ? pkStr : rejectInfos[3];
                        if (this.debug) {
                            log.debug((Object)String.format("[%s] Bad update date [pk=%s]: will re-import remote pk [%s]", tableName, pkStr, targetPkStr));
                        }
                        result.addSourceMissingRevert(tableName, targetPkStr);
                        break;
                    }
                    case DO_NOTHING: {
                        result.addReject(tableName, pkStr, rejectStatus.name());
                    }
                }
                break;
            }
            case DELETED: {
                switch (rejectStrategy) {
                    case KEEP_LOCAL: {
                        if (this.debug) {
                            log.debug((Object)String.format("[%s] Deleted row on server [pk=%s] will be keep locally", tableName, pkStr));
                        }
                        operation.addMissingDetach(pkStr);
                        break;
                    }
                    case UPDATE: {
                        if (this.debug) {
                            log.debug((Object)String.format("[%s] Deleted row on server [pk=%s] will deleted on local", tableName, pkStr));
                        }
                        operation.addMissingDelete(pkStr);
                        break;
                    }
                    case DO_NOTHING: {
                        result.addReject(tableName, pkStr, rejectStatus.name());
                    }
                }
                break;
            }
            case DUPLICATE_KEY: {
                if (this.debug) {
                    log.debug((Object)String.format("[%s] Duplicate key [pk=%s]: row not exported", tableName, pkStr));
                }
                result.addReject(tableName, pkStr, rejectStatus.name());
                break;
            }
            case LOCKED: {
                if (this.debug) {
                    log.debug((Object)String.format("[%s] Unable to get server lock [pk=%s]: row not exported", tableName, pkStr));
                }
                result.addReject(tableName, pkStr, rejectStatus.name());
                break;
            }
        }
    }

    protected boolean isCheckPkNotUsedBeforeDelete(SynchroContext context) {
        return this.disableIntegrityConstraints && !context.getTarget().isMirrorDatabase();
    }

    protected boolean hasProcessedTable(Set<String> tableNames, SynchroContext context) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(tableNames));
        Preconditions.checkNotNull((Object)context);
        Set<String> expectedTableNames = context.getTableNames();
        for (String tableName : tableNames) {
            if (!expectedTableNames.contains(tableName)) continue;
            return true;
        }
        return false;
    }

    protected void updateResultOnSynchronizeError(Exception e, SynchroResult result) {
        if (result.getRejectedRows().isEmpty()) {
            result.clear();
        } else {
            ImmutableMap copiedRejectedRows = ImmutableMap.copyOf(result.getRejectedRows());
            result.clear();
            result.getRejectedRows().putAll((Map<String, String>)copiedRejectedRows);
        }
        result.setError(e);
    }
}

