/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.csv.CaracteristicValueParseException;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportValidationHelper;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicModel;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicRow;
import java.io.Serializable;
import java.nio.file.Path;
import org.nuiton.csv.ImportRow;

public class CsvConsumerForGearCaracteristic
extends CsvComsumer<GearCaracteristicRow, GearCaracteristicModel> {
    public CsvConsumerForGearCaracteristic(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, GearCaracteristicModel.forImport(separator, parserFactory), reportError);
    }

    public GenericFormatImportCruiseContext validateRow(ImportRow<GearCaracteristicRow> row, GenericFormatContextSupport importContext) {
        GenericFormatImportValidationHelper validationHelper;
        GenericFormatImportCruiseContext cruiseContext = null;
        if (row.isValid() && (cruiseContext = (validationHelper = importContext.getValidationHelper()).getCruise(this, row, importContext)) != null) {
            Caracteristic caracteristic;
            short rankOrder;
            GearCaracteristicRow bean = (GearCaracteristicRow)row.getBean();
            Gear gear = bean.getGear();
            Gear cruiseGear = validationHelper.getGear(this, importContext, row, gear, rankOrder = bean.getRankOrder());
            if (cruiseGear != null) {
                bean.setGear(cruiseGear);
            }
            if ((caracteristic = bean.getCaracteristic()) == null) {
                // empty if block
            }
            if (bean.getValue() == null) {
                // empty if block
            }
            String value = (String)((Object)bean.getValue());
            try {
                Serializable serializable = importContext.parseCaracteristicValue(caracteristic, value);
                bean.setValue(serializable);
            }
            catch (CaracteristicValueParseException e) {
                this.addCheckError(row, e);
            }
        }
        this.reportError(row);
        return cruiseContext;
    }

    public void prepareRowForPersist(GenericFormatImportCruiseContext cruiseContext, ImportRow<GearCaracteristicRow> row) {
        GearCaracteristicRow bean = (GearCaracteristicRow)row.getBean();
        cruiseContext.addGearCaracteristic(bean.getGear(), bean.getCaracteristic(), bean.getValue());
    }
}

