/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.EntityParserFormatterSupport;
import java.util.List;
import java.util.Map;

public class SpeciesParserFormatter
extends EntityParserFormatterSupport<Species> {
    private final PersistenceService persistenceService;
    private final Map<String, String> idTranslationMap;

    public static SpeciesParserFormatter newFormatter() {
        return new SpeciesParserFormatter(false, null, null);
    }

    public static SpeciesParserFormatter newTechnicalFormatter() {
        return new SpeciesParserFormatter(true, null, null);
    }

    public static SpeciesParserFormatter newParser(PersistenceService persistenceService, Map<String, String> idTranslationMap) {
        return new SpeciesParserFormatter(true, persistenceService, idTranslationMap);
    }

    protected SpeciesParserFormatter(boolean technical, PersistenceService persistenceService, Map<String, String> idTranslationMap) {
        super("", technical, Species.class);
        this.persistenceService = persistenceService;
        this.idTranslationMap = idTranslationMap;
    }

    @Override
    protected List<Species> getEntities() {
        return this.persistenceService.getAllReferentSpecies();
    }

    @Override
    protected Map<String, Species> getEntitiesById() {
        if (this.entitiesById == null) {
            List<Species> entities = this.getEntities();
            this.entitiesById = Speciess.splitReferenceSpeciesByReferenceTaxonId(entities);
        }
        return this.entitiesById;
    }

    @Override
    protected String formatBusiness(Species value) {
        return value.getName();
    }

    @Override
    protected String formatTechnical(Species value) {
        return (String)Speciess.GET_REFERECE_TAXON_ID.apply((Object)value);
    }

    @Override
    protected Species parseNotBlankValue(String value) {
        if (this.idTranslationMap.containsKey(value)) {
            value = this.idTranslationMap.get(value);
        }
        return (Species)super.parseNotBlankValue(value);
    }
}

