/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.nuiton.csv.AbstractImportErrorInfo;
import org.nuiton.csv.Import2;
import org.nuiton.csv.ImportConf;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportableColumn;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public abstract class CsvComsumer<O, M extends AbstractTuttiImportExportModel<O>>
implements Closeable,
Iterable<ImportRow<O>> {
    private final BufferedReader reader;
    private final Import2<O> importer;
    private final boolean failFast;
    private final Map<Long, Set<String>> rowsInError;

    public CsvComsumer(Path file, M model, boolean failFast) {
        this.failFast = failFast;
        this.rowsInError = new LinkedHashMap<Long, Set<String>>();
        try {
            this.reader = Files.newReader((File)file.toFile(), (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationTechnicalException("file not found " + file, (Throwable)e);
        }
        ImportConf importConf = new ImportConf();
        importConf.setStrictMode(failFast);
        this.importer = Import2.newImport((ImportConf)importConf, model, (Reader)this.reader);
    }

    @Override
    public Iterator<ImportRow<O>> iterator() {
        Iterator iterator = this.importer.iterator();
        return iterator;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.reader);
        IOUtils.closeQuietly(this.importer);
    }

    public void addCheckError(ImportRow<O> row, Exception e) {
        row.addError(new CheckImportErrorInfo<O>(row, null, e));
    }

    public String rowErrorsToExceptionMessage(ImportRow<O> bean) {
        HashSet<String> errors = new HashSet<String>();
        for (AbstractImportErrorInfo errorInfo : bean.getErrors()) {
            Throwable cause = errorInfo.getCause();
            if (errorInfo.getField() == null) {
                errors.add(cause.getMessage());
                continue;
            }
            errors.add(I18n.t((String)"tutti.csv.import.error.on.field", (Object[])new Object[]{errorInfo.getField().getHeaderName(), cause.getMessage()}));
        }
        String message = I18n.t((String)"tutti.csv.import.error.on.row", (Object[])new Object[]{bean.getLineNumber(), Joiner.on((String)"\n").join(errors)});
        return message;
    }

    public Set<String> rowErrorsToMessage(ImportRow<O> bean) {
        HashSet<String> errors = new HashSet<String>();
        for (AbstractImportErrorInfo errorInfo : bean.getErrors()) {
            Throwable cause = errorInfo.getCause();
            if (errorInfo.getField() == null) {
                errors.add(cause.getMessage());
                continue;
            }
            errors.add(I18n.t((String)"tutti.csv.import.error.on.field", (Object[])new Object[]{errorInfo.getField().getHeaderName(), cause.getMessage()}));
        }
        return errors;
    }

    public boolean foundSomeErrors() {
        return !this.rowsInError.isEmpty();
    }

    public Map<Long, Set<String>> getRowsInError() {
        return ImmutableMap.copyOf(this.rowsInError);
    }

    protected void reportError(ImportRow<O> row) {
        if (!row.isValid()) {
            if (this.failFast) {
                String message = this.rowErrorsToExceptionMessage(row);
                throw new ApplicationBusinessException(message);
            }
            this.rowsInError.put(row.getLineNumber(), this.rowErrorsToMessage(row));
        }
    }

    public static class CheckImportErrorInfo<E>
    extends AbstractImportErrorInfo<E> {
        public CheckImportErrorInfo(ImportRow<E> row, ImportableColumn<E, Object> field, Throwable cause) {
            super(row, field, cause);
        }
    }
}

