/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.BatchTreeHelper;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="speciesBatchPersistenceService")
public class SpeciesBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements SpeciesBatchPersistenceService {
    private static final Log log = LogFactory.getLog(SpeciesBatchPersistenceServiceImpl.class);
    @Resource(name="speciesPersistenceService")
    private SpeciesPersistenceService speciesService;
    @Resource(name="fishingOperationPersistenceService")
    protected FishingOperationPersistenceService fishingOperationPersistenceService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    @Resource(name="batchTreeHelper")
    protected BatchTreeHelper batchTreeHelper;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        SortingBatch horsVracSpeciesBatch;
        Preconditions.checkNotNull((Object)fishingOperationId);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyy");
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        SortingBatch vracSpeciesBatch = this.batchTreeHelper.getSpeciesVracAliveItemizedRootBatch(catchBatch);
        BatchContainer<SpeciesBatch> result = new BatchContainer<SpeciesBatch>();
        SampleCategoryModel sampleCategoryModel = this.getSampleCategoryModel();
        if (vracSpeciesBatch != null) {
            result.setId(vracSpeciesBatch.getId());
            for (Batch batch : vracSpeciesBatch.getChildBatchs()) {
                Species species;
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootSpeciesBatch with a null taxon, but was for " + batch.getId()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading CatchBatch Vrac > Species > Alive Itemized > " + referenceTaxon.getId() + " - " + " (batch:" + source.getId() + ")"));
                }
                if ((species = this.speciesService.getSpeciesByReferenceTaxonId(referenceTaxon.getId())) == null) {
                    FishingOperation fishingOperation = this.fishingOperationPersistenceService.getFishingOperation(fishingOperationId);
                    String fishingOperationName = fishingOperation.getStationNumber() + " - " + fishingOperation.getFishingOperationNumber() + " - " + df.format(fishingOperation.getGearShootingStartDate());
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.speciesBatch.validation.unkonwn.taxon", (Object[])new Object[]{fishingOperationName, source.getId(), referenceTaxon.getId()}));
                }
                SpeciesBatch target = SpeciesBatchs.newSpeciesBatch();
                target.setSpecies(species);
                this.batchHelper.entityToBean(sampleCategoryModel, source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Vrac > Species > Alive Itemized > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if ((horsVracSpeciesBatch = this.batchTreeHelper.getSpeciesHorsVracRootBatch(catchBatch)) != null) {
            for (Batch batch : horsVracSpeciesBatch.getChildBatchs()) {
                Species species;
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootSpeciesBatch with a null taxon, but was for " + source.getId()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading CatchBatch Hors Vrac > Species > " + referenceTaxon.getId() + " - " + " (batch:" + source.getId() + ")"));
                }
                if ((species = this.speciesService.getSpeciesByReferenceTaxonId(referenceTaxon.getId())) == null) {
                    FishingOperation fishingOperation = this.fishingOperationPersistenceService.getFishingOperation(fishingOperationId);
                    String fishingOperationName = fishingOperation.getStationNumber() + " - " + fishingOperation.getFishingOperationNumber() + " - " + df.format(fishingOperation.getGearShootingStartDate());
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.speciesBatch.validation.unkonwn.taxon", (Object[])new Object[]{fishingOperationName, source.getId(), referenceTaxon.getId()}));
                }
                SpeciesBatch target = SpeciesBatchs.newSpeciesBatch();
                target.setSpecies(species);
                this.batchHelper.entityToBean(sampleCategoryModel, source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Hors Vrac > Species > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if (validateTree) {
            this.batchHelper.validateSpecies(sampleCategoryModel, result);
        }
        return result;
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((boolean)TuttiEntities.isNew(bean));
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(bean.getFishingOperation().getId(), false);
        SpeciesBatch created = this.createSpeciesBatch(bean, parentBatchId, catchBatch);
        return created;
    }

    @Override
    public Collection<SpeciesBatch> createSpeciesBatches(String fishingOperationId, Collection<SpeciesBatch> beans) {
        Preconditions.checkNotNull(beans);
        Preconditions.checkNotNull((Object)fishingOperationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        ArrayList<SpeciesBatch> result = new ArrayList<SpeciesBatch>();
        for (SpeciesBatch bean : beans) {
            SpeciesBatch created = this.createSpeciesBatch(bean, null, catchBatch);
            result.add(created);
        }
        return result;
    }

    protected SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((boolean)TuttiEntities.isNew(bean));
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.beanToEntity(bean, batch, parentBatchId, catchBatch);
        bean = this.batchHelper.createSortingBatch(bean, catchBatch, batch);
        return bean;
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((!TuttiEntities.isNew(bean) ? 1 : 0) != 0);
        Integer batchId = bean.getIdAsInt();
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        SortingBatch batch = this.batchHelper.getSortingBatchById(catchBatch, batchId);
        String parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getId();
        }
        this.beanToEntity(bean, batch, parentBatchId, catchBatch);
        this.batchHelper.updateSortingBatch(batch, catchBatch);
        return bean;
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.batchHelper.deleteBatch(id);
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.batchHelper.deleteSpeciesSubBatch(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(String id, Species species) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        this.batchHelper.changeBatchSpecies(id, species);
    }

    @Override
    public List<SpeciesBatch> getAllSpeciesBatchToConfirm(String fishingOperationId) throws InvalidBatchModelException {
        ArrayList<SpeciesBatch> batchesToConfirm = new ArrayList<SpeciesBatch>();
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.getRootSpeciesBatch(fishingOperationId, false);
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            this.findSpeciesBatchesToConfirm(speciesBatch, batchesToConfirm);
        }
        return batchesToConfirm;
    }

    protected void findSpeciesBatchesToConfirm(SpeciesBatch speciesBatch, List<SpeciesBatch> batchesToConfirm) {
        if (speciesBatch.isSpeciesToConfirm()) {
            batchesToConfirm.add(speciesBatch);
        } else if (!speciesBatch.isChildBatchsEmpty()) {
            for (SpeciesBatch batch : speciesBatch.getChildBatchs()) {
                this.findSpeciesBatchesToConfirm(batch, batchesToConfirm);
            }
        }
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencies(speciesBatchId);
        ArrayList results = Lists.newArrayList();
        for (SortingBatch child : frequencyChilds) {
            SpeciesBatchFrequency target = SpeciesBatchFrequencys.newSpeciesBatchFrequency();
            this.batchHelper.entityToBatchFrequency(child, target);
            results.add(target);
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (SpeciesBatch speciesBatch : batchContainer.getChildren()) {
            this.getAllSpeciesBatchFrequencyForBatch(speciesBatch, (Multimap<Species, SpeciesBatchFrequency>)result);
        }
        return result;
    }

    protected void getAllSpeciesBatchFrequencyForBatch(SpeciesBatch batch, Multimap<Species, SpeciesBatchFrequency> result) {
        List<SpeciesBatchFrequency> speciesBatchFrequency = this.getAllSpeciesBatchFrequency(batch.getId());
        result.putAll((Object)batch.getSpecies(), speciesBatchFrequency);
        if (!batch.isChildBatchsEmpty()) {
            for (SpeciesBatch child : batch.getChildBatchs()) {
                this.getAllSpeciesBatchFrequencyForBatch(child, result);
            }
        }
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        Preconditions.checkNotNull(frequencies);
        ArrayList notNullFrequencies = Lists.newArrayList();
        String pmfmId = null;
        for (SpeciesBatchFrequency source : frequencies) {
            if (source.getLengthStepCaracteristic() == null) continue;
            if (pmfmId == null) {
                pmfmId = source.getLengthStepCaracteristic().getId();
            } else if (!pmfmId.equals(source.getLengthStepCaracteristic().getId())) {
                throw new DataIntegrityViolationException("Batch frequencies under one SpeciesBatch must have all the same lengthStepCaracteristic");
            }
            notNullFrequencies.add(source);
        }
        Integer sortingBatchId = Integer.valueOf(speciesBatchId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(sortingBatchId);
        if (catchBatch == null) {
            return notNullFrequencies;
        }
        this.synchronizationStatusHelper.setDirty(catchBatch);
        SortingBatch parentBatch = this.batchHelper.getSortingBatchById(catchBatch, sortingBatchId);
        ArrayList notUpdatedChildIds = Lists.newArrayList();
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencyChilds(parentBatch);
        for (SortingBatch child : frequencyChilds) {
            notUpdatedChildIds.add(child.getId());
        }
        short rankOrder = 0;
        ArrayList batchsToUpdate = Lists.newArrayList();
        for (SpeciesBatchFrequency source : notNullFrequencies) {
            SortingBatch target;
            rankOrder = (short)(rankOrder + 1);
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.batchHelper.beanToEntity(source, target, parentBatch, rankOrder);
                this.batchHelper.createSortingBatch(source, catchBatch, target);
                source.setId(target.getId());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Create frequency sortingBatch(" + rankOrder + "): " + target.getId()));
                continue;
            }
            target = this.batchHelper.loadSortingBatch(source.getIdAsInt(), catchBatch);
            this.batchHelper.beanToEntity(source, target, parentBatch, rankOrder);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Update frequency sortingBatch(" + rankOrder + "): " + target.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)batchsToUpdate)) {
            this.batchHelper.updateSortingBatch(batchsToUpdate, catchBatch);
        }
        if (CollectionUtils.isNotEmpty((Collection)notUpdatedChildIds)) {
            for (Integer batchId : notUpdatedChildIds) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove obsolete frequency sortingBatch: " + batchId));
                }
                this.batchHelper.removeWithChildren(batchId, catchBatch);
            }
        }
        return Collections.unmodifiableList(notNullFrequencies);
    }

    protected void beanToEntity(SpeciesBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().toString().equals(parentBatchId)) {
            this.batchHelper.setSpeciesBatchParents(source.getSampleCategoryId(), source.getSampleCategoryValue(), target, parentBatchId, catchBatch);
        }
        this.batchHelper.beanToEntity(parentBatchId, source, target);
    }
}

