/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets;

import java.awt.Dimension;
import java.beans.Introspector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.i18n.I18n;

public abstract class DecoratorPopupHandler
implements Runnable {
    public static final Log log = LogFactory.getLog(DecoratorPopupHandler.class);
    public static final String DEFAULT_POPUP_LABEL = I18n.n((String)"bean.popup.label", (Object[])new Object[0]);
    public static final String DEFAULT_SELECTED_TOOLTIP = I18n.n((String)"bean.sort.on", (Object[])new Object[0]);
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = I18n.n((String)"bean.sort.off", (Object[])new Object[0]);

    public abstract JPopupMenu getPopup();

    public abstract JComponent getInvoker();

    @Override
    public void run() {
        this.updatePopup();
        Dimension dim = this.getPopup().getPreferredSize();
        JComponent invoker = this.getInvoker();
        this.getPopup().show(invoker, (int)(invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
    }

    public void togglePopup() {
        boolean newValue;
        boolean bl = newValue = !this.getPopup().isVisible();
        if (log.isTraceEnabled()) {
            log.trace((Object)newValue);
        }
        if (!newValue) {
            if (this.getPopup() != null) {
                this.getPopup().setVisible(false);
            }
            return;
        }
        SwingUtilities.invokeLater(this);
    }

    protected void updatePopup() {
        this.getPopup().pack();
    }

    public void preparePopup(String selectedTip, String notSelectedTip, String i18nPrefix, String title, ButtonGroup indexes, JSeparator popupSeparator, JLabel popupLabel, AbstractButton sortUp, AbstractButton sortDown, MultiJXPathDecorator<?> decorator) {
        if (selectedTip == null) {
            selectedTip = DEFAULT_SELECTED_TOOLTIP;
        }
        if (notSelectedTip == null) {
            notSelectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
        }
        JPopupMenu popup = this.getPopup();
        int nbContext = decorator.getNbContext();
        if (nbContext > 1) {
            for (int i = 0; i < nbContext; ++i) {
                String property = i18nPrefix + decorator.getProperty(i);
                String propertyI18n = I18n.t((String)property, (Object[])new Object[0]);
                JRadioButtonMenuItem button = new JRadioButtonMenuItem(propertyI18n);
                button.putClientProperty("$buttonGroup", indexes);
                button.putClientProperty("$value", i);
                popup.add(button);
                if (selectedTip != null) {
                    button.putClientProperty("$selected.toolTipText", I18n.t((String)selectedTip, (Object[])new Object[]{propertyI18n}));
                }
                if (notSelectedTip != null) {
                    button.putClientProperty("$not.selected.toolTipText", I18n.t((String)notSelectedTip, (Object[])new Object[]{propertyI18n}));
                }
                button.setSelected(false);
                indexes.add(button);
            }
        }
        if (title == null) {
            title = DEFAULT_POPUP_LABEL;
            Class type = decorator.getType();
            String beanI18nKey = type == null ? I18n.n((String)"bean.unknown.type", (Object[])new Object[0]) : i18nPrefix + Introspector.decapitalize(type.getSimpleName());
            String beanI18n = I18n.t((String)beanI18nKey, (Object[])new Object[0]);
            title = I18n.t((String)title, (Object[])new Object[]{beanI18n});
        } else {
            title = I18n.t((String)title, (Object[])new Object[0]);
        }
        sortDown.putClientProperty("$selected.toolTipText", I18n.t((String)"bean.sort.down.tip", (Object[])new Object[0]));
        sortDown.putClientProperty("$not.selected.toolTipText", I18n.t((String)"bean.sort.down.toSelect.tip", (Object[])new Object[0]));
        sortUp.putClientProperty("$selected.toolTipText", I18n.t((String)"bean.sort.up.tip", (Object[])new Object[0]));
        sortUp.putClientProperty("$not.selected.toolTipText", I18n.t((String)"bean.sort.up.toSelect.tip", (Object[])new Object[0]));
        if (nbContext < 2) {
            this.getPopup().remove(popupSeparator);
            this.getPopup().remove(popupLabel);
        }
        popupLabel.setText(title);
        this.getPopup().setLabel(title);
        this.getPopup().invalidate();
    }
}

