/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.content.cruise.VesselTypeEnum;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.util.DateUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditCruiseUIModel
extends AbstractTuttiBeanUIModel<Cruise, EditCruiseUIModel>
implements AttachmentModelAware,
Cruise {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CAN_GENERATE_NAME = "canGenerateName";
    public static final String PROPERTY_CAN_SHOW_GEAR_CARACTERISTIC = "canShowGearCatacteristic";
    public static final String PROPERTY_CAN_EDIT_GEAR_CARACTERISTIC = "canEditGearCatacteristic";
    public static final String PROPERTY_VESSEL_TYPE = "vesselType";
    public static final String PROPERTY_VESSEL_TYPE_ALL = "vesselTypeAll";
    public static final String PROPERTY_VESSEL_TYPE_SCIENTIFIC = "vesselTypeScientific";
    public static final String PROPERTY_VESSEL_TYPE_FISHING = "vesselTypeFishing";
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    protected final Cruise editObject = Cruises.newCruise();
    protected VesselTypeEnum vesselType;
    protected boolean canEditGearCatacteristic;
    protected boolean canShowGearCatacteristic;
    protected String validationContext;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected static Binder<EditCruiseUIModel, Cruise> toBeanBinder = BinderFactory.newBinder(EditCruiseUIModel.class, Cruise.class);
    protected static Binder<Cruise, EditCruiseUIModel> fromBeanBinder = BinderFactory.newBinder(Cruise.class, EditCruiseUIModel.class);
    public static final String CRUISE_NAME_FORMAT = "%1$s_%2$s";

    public EditCruiseUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    @Override
    protected Cruise newEntity() {
        return Cruises.newCruise();
    }

    public boolean isCanEditGearCatacteristic() {
        return this.canEditGearCatacteristic;
    }

    public void setCanEditGearCatacteristic(boolean canEditGearCatacteristic) {
        this.canEditGearCatacteristic = canEditGearCatacteristic;
        this.firePropertyChange(PROPERTY_CAN_EDIT_GEAR_CARACTERISTIC, null, canEditGearCatacteristic);
    }

    public boolean isCanShowGearCatacteristic() {
        return this.canShowGearCatacteristic;
    }

    public void setCanShowGearCatacteristic(boolean canShowGearCatacteristic) {
        this.canShowGearCatacteristic = canShowGearCatacteristic;
        this.firePropertyChange(PROPERTY_CAN_SHOW_GEAR_CARACTERISTIC, null, canShowGearCatacteristic);
    }

    public VesselTypeEnum getVesselType() {
        return this.vesselType;
    }

    public void setVesselType(VesselTypeEnum vesselType) {
        boolean oldAll = this.isVesselTypeAll();
        boolean oldScientific = this.isVesselTypeScientific();
        boolean oldFishing = this.isVesselTypeFishing();
        VesselTypeEnum oldValue = this.getVesselType();
        this.vesselType = vesselType;
        this.firePropertyChange(PROPERTY_VESSEL_TYPE, (Object)oldValue, (Object)vesselType);
        this.firePropertyChange(PROPERTY_VESSEL_TYPE_ALL, oldAll, this.isVesselTypeAll());
        this.firePropertyChange(PROPERTY_VESSEL_TYPE_SCIENTIFIC, oldScientific, this.isVesselTypeScientific());
        this.firePropertyChange(PROPERTY_VESSEL_TYPE_FISHING, oldFishing, this.isVesselTypeFishing());
    }

    public boolean isVesselTypeAll() {
        return VesselTypeEnum.ALL.equals((Object)this.vesselType);
    }

    public boolean isVesselTypeScientific() {
        return VesselTypeEnum.SCIENTIFIC.equals((Object)this.vesselType);
    }

    public boolean isVesselTypeFishing() {
        return VesselTypeEnum.FISHING.equals((Object)this.vesselType);
    }

    public boolean isCanGenerateName() {
        return this.getProgram() != null && this.getBeginDate() != null;
    }

    public String getGeneratedCampaignName() {
        int year;
        if (this.getBeginDate() == null) {
            year = 0;
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.getBeginDate());
            year = c.get(1);
        }
        String result = String.format(CRUISE_NAME_FORMAT, this.getProgram().getName(), year);
        if (StringUtils.isNotEmpty((CharSequence)this.getSurveyPart())) {
            result = result + "_" + this.getSurveyPart();
        }
        return result;
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    @Override
    public ObjectTypeCode getObjectType() {
        return ObjectTypeCode.SCIENTIFIC_CRUISE;
    }

    @Override
    public Integer getObjectId() {
        return this.getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public Program getProgram() {
        return this.editObject.getProgram();
    }

    @Override
    public void setProgram(Program program) {
        Program oldValue = this.getProgram();
        this.editObject.setProgram(program);
        this.firePropertyChange("program", oldValue, program);
        this.firePropertyChange(PROPERTY_CAN_GENERATE_NAME, null, this.isCanGenerateName());
    }

    @Override
    public String getName() {
        return this.editObject.getName();
    }

    @Override
    public void setName(String name) {
        String oldValue = this.getName();
        this.editObject.setName(name);
        this.firePropertyChange("name", oldValue, name);
    }

    @Override
    public String getComment() {
        return this.editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public TuttiLocation getDepartureLocation() {
        return this.editObject.getDepartureLocation();
    }

    @Override
    public void setDepartureLocation(TuttiLocation departureLocation) {
        TuttiLocation oldValue = this.getDepartureLocation();
        this.editObject.setDepartureLocation(departureLocation);
        this.firePropertyChange("departureLocation", oldValue, departureLocation);
    }

    @Override
    public TuttiLocation getReturnLocation() {
        return this.editObject.getReturnLocation();
    }

    @Override
    public void setReturnLocation(TuttiLocation returnLocation) {
        TuttiLocation oldValue = this.getReturnLocation();
        this.editObject.setReturnLocation(returnLocation);
        this.firePropertyChange("returnLocation", oldValue, returnLocation);
    }

    @Override
    public String getSurveyPart() {
        return this.editObject.getSurveyPart();
    }

    @Override
    public void setSurveyPart(String surveyPart) {
        String oldValue = this.getSurveyPart();
        this.editObject.setSurveyPart(surveyPart);
        this.firePropertyChange("surveyPart", oldValue, surveyPart);
        this.firePropertyChange(PROPERTY_CAN_GENERATE_NAME, null, this.isCanGenerateName());
    }

    @Override
    public Integer getMultirigNumber() {
        return this.editObject.getMultirigNumber();
    }

    @Override
    public void setMultirigNumber(Integer multirigNumber) {
        Integer oldValue = this.getMultirigNumber();
        this.editObject.setMultirigNumber(multirigNumber);
        this.firePropertyChange("multirigNumber", oldValue, multirigNumber);
    }

    @Override
    public Date getBeginDate() {
        return this.editObject.getBeginDate();
    }

    @Override
    public void setBeginDate(Date beginDate) {
        Date oldValue = this.getBeginDate();
        Date newDate = beginDate;
        if (oldValue != null && beginDate != null) {
            newDate = this.applyTime(beginDate, oldValue);
        }
        this.setBeginDate0(newDate);
    }

    @Override
    public Date getEndDate() {
        return this.editObject.getEndDate();
    }

    @Override
    public void setEndDate(Date endDate) {
        Date oldValue = this.getEndDate();
        Date newDate = endDate;
        if (oldValue != null && endDate != null) {
            newDate = this.applyTime(endDate, oldValue);
        }
        this.setEndDate0(newDate);
    }

    @Override
    public Vessel getVessel() {
        return this.editObject.getVessel();
    }

    @Override
    public void setVessel(Vessel vessel) {
        Vessel oldValue = this.getVessel();
        this.editObject.setVessel(vessel);
        this.firePropertyChange("vessel", oldValue, vessel);
    }

    @Override
    public String getSynchronizationStatus() {
        return this.editObject.getSynchronizationStatus();
    }

    @Override
    public void setSynchronizationStatus(String synchronizationStatus) {
        String oldValue = this.getSynchronizationStatus();
        this.editObject.setSynchronizationStatus(synchronizationStatus);
        this.firePropertyChange("synchronizationStatus", oldValue, synchronizationStatus);
    }

    @Override
    public List<GearWithOriginalRankOrder> getGear() {
        return this.editObject.getGear();
    }

    @Override
    public void setGear(List<GearWithOriginalRankOrder> gear) {
        this.editObject.setGear(gear);
        this.firePropertyChange("gear", null, gear);
    }

    @Override
    public List<Person> getHeadOfMission() {
        return this.editObject.getHeadOfMission();
    }

    @Override
    public void setHeadOfMission(List<Person> headOfMission) {
        this.editObject.setHeadOfMission(headOfMission);
        this.firePropertyChange("headOfMission", null, headOfMission);
    }

    @Override
    public List<Person> getHeadOfSortRoom() {
        return this.editObject.getHeadOfSortRoom();
    }

    @Override
    public void setHeadOfSortRoom(List<Person> headOfSortRoom) {
        this.editObject.setHeadOfSortRoom(headOfSortRoom);
        this.firePropertyChange("headOfSortRoom", null, headOfSortRoom);
    }

    @Override
    public GearWithOriginalRankOrder getGear(int index) {
        return this.editObject.getGear(index);
    }

    @Override
    public boolean isGearEmpty() {
        return this.editObject.isGearEmpty();
    }

    @Override
    public int sizeGear() {
        return this.editObject.sizeGear();
    }

    @Override
    public void addGear(GearWithOriginalRankOrder gear) {
        this.editObject.addGear(gear);
    }

    @Override
    public void addAllGear(Collection<GearWithOriginalRankOrder> gear) {
        this.editObject.addAllGear(gear);
    }

    @Override
    public boolean removeGear(GearWithOriginalRankOrder gear) {
        return this.editObject.removeGear(gear);
    }

    @Override
    public boolean removeAllGear(Collection<GearWithOriginalRankOrder> gear) {
        return this.editObject.removeAllGear(gear);
    }

    @Override
    public boolean containsGear(GearWithOriginalRankOrder gear) {
        return this.editObject.containsGear(gear);
    }

    @Override
    public boolean containsAllGear(Collection<GearWithOriginalRankOrder> gear) {
        return this.editObject.containsAllGear(gear);
    }

    @Override
    public Person getHeadOfMission(int index) {
        return null;
    }

    @Override
    public boolean isHeadOfMissionEmpty() {
        return false;
    }

    @Override
    public int sizeHeadOfMission() {
        return 0;
    }

    @Override
    public void addHeadOfMission(Person headOfMission) {
    }

    @Override
    public void addAllHeadOfMission(Collection<Person> headOfMission) {
    }

    @Override
    public boolean removeHeadOfMission(Person headOfMission) {
        return false;
    }

    @Override
    public boolean removeAllHeadOfMission(Collection<Person> headOfMission) {
        return false;
    }

    @Override
    public boolean containsHeadOfMission(Person headOfMission) {
        return false;
    }

    @Override
    public boolean containsAllHeadOfMission(Collection<Person> headOfMission) {
        return false;
    }

    @Override
    public Person getHeadOfSortRoom(int index) {
        return null;
    }

    @Override
    public boolean isHeadOfSortRoomEmpty() {
        return false;
    }

    @Override
    public int sizeHeadOfSortRoom() {
        return 0;
    }

    @Override
    public void addHeadOfSortRoom(Person headOfSortRoom) {
    }

    @Override
    public void addAllHeadOfSortRoom(Collection<Person> headOfSortRoom) {
    }

    @Override
    public boolean removeHeadOfSortRoom(Person headOfSortRoom) {
        return false;
    }

    @Override
    public boolean removeAllHeadOfSortRoom(Collection<Person> headOfSortRoom) {
        return false;
    }

    @Override
    public boolean containsHeadOfSortRoom(Person headOfSortRoom) {
        return false;
    }

    @Override
    public boolean containsAllHeadOfSortRoom(Collection<Person> headOfSortRoom) {
        return false;
    }

    public void setBeginTime(Date beginTime) {
        Date oldValue = this.getBeginDate();
        if (oldValue != null && beginTime != null) {
            Date newDate = this.applyTime(oldValue, beginTime);
            this.setBeginDate0(newDate);
        }
    }

    public void setEndTime(Date endTime) {
        Date oldValue = this.getEndDate();
        if (oldValue != null && endTime != null) {
            Date newDate = this.applyTime(oldValue, endTime);
            this.setEndDate0(newDate);
        }
    }

    protected Date applyTime(Date date, Date timeDate) {
        Calendar cal = DateUtils.toCalendar((Date)timeDate);
        Date newDate = DateUtils.setHours((Date)date, (int)cal.get(11));
        newDate = DateUtils.setMinutes((Date)newDate, (int)cal.get(12));
        return newDate;
    }

    protected void setBeginDate0(Date beginDate) {
        Date oldValue = this.getBeginDate();
        if (beginDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)beginDate);
            calendar.set(13, 0);
            this.editObject.setBeginDate(calendar.getTime());
        } else {
            this.editObject.setBeginDate(null);
        }
        this.firePropertyChange("beginDate", oldValue, this.getBeginDate());
        this.firePropertyChange(PROPERTY_CAN_GENERATE_NAME, null, this.isCanGenerateName());
    }

    protected void setEndDate0(Date endDate) {
        Date oldValue = this.getEndDate();
        if (endDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)endDate);
            calendar.set(13, 0);
            this.editObject.setEndDate(calendar.getTime());
        } else {
            this.editObject.setEndDate(null);
        }
        this.firePropertyChange("endDate", oldValue, this.getEndDate());
    }
}

