/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImportRequestResult<E extends TuttiReferentialEntity, K> {
    private final List<E> toAdd = Lists.newArrayList();
    private final List<E> toUpdate = Lists.newArrayList();
    private final List<K> toDelete = Lists.newArrayList();
    private final Map<K, E> existingEntitiesById;
    private final Set<String> existingNaturalIds;

    public ImportRequestResult(List<E> existingEntities, Function<E, K> entityToIdFunction, Function<E, String> naturalIdFunction) {
        this.existingEntitiesById = Maps.uniqueIndex(existingEntities, entityToIdFunction);
        this.existingNaturalIds = Sets.newHashSet((Iterable)Iterables.transform(existingEntities, naturalIdFunction));
    }

    public void addEntityToAdd(E entityToAdd) {
        this.toAdd.add(entityToAdd);
    }

    public void addEntityToUpdate(E entityToUpdate) {
        this.toUpdate.add(entityToUpdate);
    }

    public void addIdToDelete(K entityToDelete) {
        this.toDelete.add(entityToDelete);
    }

    public boolean withEntitiesToAdd() {
        return !this.toAdd.isEmpty();
    }

    public boolean withEntitiesToUpdate() {
        return !this.toUpdate.isEmpty();
    }

    public boolean withEntitiesToDelete() {
        return !this.toDelete.isEmpty();
    }

    public Collection<K> getIdsToDelete() {
        return Lists.newArrayList(this.toDelete);
    }

    public Collection<E> getEntitiesToAdd() {
        return Lists.newArrayList(this.toAdd);
    }

    public Collection<E> getEntitiesToUpdate() {
        return Lists.newArrayList(this.toUpdate);
    }

    public E getExistingEntityById(K id) {
        return (E)((TuttiReferentialEntity)this.existingEntitiesById.get(id));
    }

    public boolean addExistingNaturalId(String naturalId) {
        return this.existingNaturalIds.add(naturalId);
    }

    public void removeExistingNaturalId(String naturalId) {
        this.existingNaturalIds.remove(naturalId);
    }
}

