/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sql.visitor;

import java.util.HashMap;
import java.util.Map;
import liquibase.sql.visitor.AppendSqlVisitor;
import liquibase.sql.visitor.PrependSqlVisitor;
import liquibase.sql.visitor.RegExpReplaceSqlVisitor;
import liquibase.sql.visitor.ReplaceSqlVisitor;
import liquibase.sql.visitor.SqlVisitor;

public class SqlVisitorFactory {
    private final Map<String, Class> tagToClassMap = new HashMap<String, Class>();
    private static final SqlVisitorFactory instance = new SqlVisitorFactory();

    private SqlVisitorFactory() {
        Class[] visitors = new Class[]{PrependSqlVisitor.class, AppendSqlVisitor.class, RegExpReplaceSqlVisitor.class, ReplaceSqlVisitor.class};
        try {
            Class[] classArray = visitors;
            int n = visitors.length;
            int n2 = 0;
            while (n2 < n) {
                Class visitorClass = classArray[n2];
                SqlVisitor visitor = (SqlVisitor)visitorClass.newInstance();
                this.tagToClassMap.put(visitor.getName(), visitorClass);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SqlVisitorFactory getInstance() {
        return instance;
    }

    public SqlVisitor create(String tagName) {
        Class aClass = this.tagToClassMap.get(tagName);
        if (aClass == null) {
            throw new RuntimeException("Unknown tag: " + tagName);
        }
        try {
            return (SqlVisitor)aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

