/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.type.ProgressionModel;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SynchroResult {
    protected Exception error;
    protected final Map<String, Integer> rowHits = Maps.newTreeMap();
    protected final Map<String, Integer> insertHits = Maps.newTreeMap();
    protected final Map<String, Integer> updateHits = Maps.newTreeMap();
    protected final Map<String, Timestamp> updateDateHits = Maps.newTreeMap();
    protected final Set<String> tableNames = Sets.newHashSet();
    protected final Map<String, Set<String>> missingOptionalColumnNames = Maps.newTreeMap();
    protected String targetUrl;
    protected String sourceUrl;
    protected final ProgressionModel progressionModel = new ProgressionModel(this);

    public SynchroResult() {
    }

    public SynchroResult(String targetUrl, String sourceUrl) {
        this.targetUrl = targetUrl;
        this.sourceUrl = sourceUrl;
    }

    public void setLocalUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void setRemoteUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public ProgressionModel getProgressionModel() {
        return this.progressionModel;
    }

    public Set<String> getTableNames() {
        return ImmutableSet.copyOf(this.tableNames);
    }

    public int getTotalRows() {
        int result = 0;
        for (Integer nb : this.rowHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalInserts() {
        int result = 0;
        for (Integer nb : this.insertHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getTotalUpdates() {
        int result = 0;
        for (Integer nb : this.updateHits.values()) {
            result += nb.intValue();
        }
        return result;
    }

    public int getNbRows(String tableName) {
        Integer result = this.rowHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public int getNbInserts(String tableName) {
        Integer result = this.insertHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public int getNbUpdates(String tableName) {
        Integer result = this.updateHits.get(tableName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public void addRows(String tableName, int nb) {
        if (nb > 0) {
            this.rowHits.put(tableName, this.getNbRows(tableName) + nb);
        }
    }

    public void addUpdates(String tableName, int nb) {
        if (nb > 0) {
            this.updateHits.put(tableName, this.getNbUpdates(tableName) + nb);
        }
    }

    public void addInserts(String tableName, int nb) {
        if (nb > 0) {
            this.insertHits.put(tableName, this.getNbInserts(tableName) + nb);
        }
    }

    public Timestamp getUpdateDate(String tableName) {
        return this.updateDateHits.get(tableName);
    }

    public void setUpdateDate(String tableName, Timestamp t) {
        this.updateDateHits.put(tableName, t);
    }

    public void addTableName(String tableName) {
        this.tableNames.add(tableName);
    }

    public String getLocalUrl() {
        return this.targetUrl;
    }

    public String getRemoteUrl() {
        return this.sourceUrl;
    }

    public void addMissingOptionalColumnName(String tableName, String columnName) {
        HashSet columnNames = this.missingOptionalColumnNames.get(tableName);
        if (columnNames == null) {
            columnNames = Sets.newHashSet();
            this.missingOptionalColumnNames.put(tableName, columnNames);
        }
        columnNames.add(columnName);
    }

    public Set<String> getMissingOptionalColumnNames(String tableName) {
        return this.missingOptionalColumnNames.get(tableName);
    }

    public Map<String, Set<String>> getMissingOptionalColumnNameMaps() {
        return ImmutableMap.copyOf(this.missingOptionalColumnNames);
    }
}

