package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class BenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<BenthosBatchUIModel, BenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED = "addSampleCategoryMenu.enabled";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN = "benthosTotalInertWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_NUMBER_VALUE = "benthosTotalInertWeightField.numberValue";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN = "benthosTotalLivingNotItemizedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_VALUE = "benthosTotalLivingNotItemizedWeightField.numberValue";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "benthosTotalSampleSortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "benthosTotalSortedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_VALUE = "benthosTotalSortedWeightField.numberValue";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT = "benthosTotalWeightField.text";
    public static final String BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED = "changeSampleCategoryMenu.enabled";
    public static final String BINDING_CREATE_BENTHOS_MELAG_MENU_ENABLED = "createBenthosMelagMenu.enabled";
    public static final String BINDING_EDIT_FREQUENCIES_MENU_ENABLED = "editFrequenciesMenu.enabled";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED = "filterBenthosBatchAllButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED = "filterBenthosBatchLeafButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED = "filterBenthosBatchRootButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT = "filterBenthosBatchRootButton.text";
    public static final String BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED = "removeBenthosBatchMenu.enabled";
    public static final String BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED = "removeBenthosSubBatchMenu.enabled";
    public static final String BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED = "renameBenthosBatchMenu.enabled";
    public static final String BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED = "speciesSortModeAscButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED = "speciesSortModeDescButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED = "speciesSortModeNoneButton.selected";
    public static final String BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED = "splitBenthosBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(BenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem addSampleCategoryMenu;
    protected ButtonAttachment benthosBatchAttachmentsButton;
    protected JToolBar benthosBatchTabToolBar;
    protected ComputableDataEditor<Float> benthosTotalInertWeightField;
    protected JLabel benthosTotalInertWeightLabel;
    protected ComputableDataEditor<Float> benthosTotalLivingNotItemizedWeightField;
    protected JLabel benthosTotalLivingNotItemizedWeightLabel;
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected ComputableDataEditor<Float> benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JMenuItem changeSampleCategoryMenu;
    protected JButton createBenthosBatchButton;
    protected JMenuItem createBenthosMelagMenu;
    protected BenthosBatchUI editBenthosBatchTopPanel = this;
    protected JMenuItem editFrequenciesMenu;
    protected JButton exportMultiPostButton;
    protected JRadioButton filterBenthosBatchAllButton;
    protected JLabel filterBenthosBatchLabel;
    protected JRadioButton filterBenthosBatchLeafButton;
    protected JAXXButtonGroup filterBenthosBatchMode;
    protected JRadioButton filterBenthosBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected final BenthosBatchUIHandler handler = createHandler();
    protected JButton importMultiPostButton;
    protected BenthosBatchUIModel model;
    protected JMenuItem removeBenthosBatchMenu;
    protected JMenuItem removeBenthosSubBatchMenu;
    protected JMenuItem renameBenthosBatchMenu;
    protected JAXXButtonGroup speciesSort;
    protected JLabel speciesSortBatchLabel;
    protected JRadioButton speciesSortModeAscButton;
    protected JRadioButton speciesSortModeDescButton;
    protected JRadioButton speciesSortModeNoneButton;
    protected JPanel speciesSortTablePane;
    protected JMenuItem splitBenthosBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosBatchUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public BenthosBatchUI() {
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addSampleCategoryMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addBatchCategory();
    }

    public void doActionPerformed__on__changeSampleCategoryMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeBatchCategory();
    }

    public void doActionPerformed__on__createBenthosBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doActionPerformed__on__editFrequenciesMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.editFrequencies();
    }

    public void doActionPerformed__on__filterBenthosBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterBenthosBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterBenthosBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__speciesSortModeAscButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.ASC);
    }

    public void doActionPerformed__on__speciesSortModeDescButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.DESC);
    }

    public void doActionPerformed__on__speciesSortModeNoneButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.NONE);
    }

    public void doActionPerformed__on__splitBenthosBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getAddSampleCategoryMenu() {
        return addSampleCategoryMenu;
    }

    public ButtonAttachment getBenthosBatchAttachmentsButton() {
        return benthosBatchAttachmentsButton;
    }

    public JToolBar getBenthosBatchTabToolBar() {
        return benthosBatchTabToolBar;
    }

    public ComputableDataEditor<Float> getBenthosTotalInertWeightField() {
        return benthosTotalInertWeightField;
    }

    public JLabel getBenthosTotalInertWeightLabel() {
        return benthosTotalInertWeightLabel;
    }

    public ComputableDataEditor<Float> getBenthosTotalLivingNotItemizedWeightField() {
        return benthosTotalLivingNotItemizedWeightField;
    }

    public JLabel getBenthosTotalLivingNotItemizedWeightLabel() {
        return benthosTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public ComputableDataEditor<Float> getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JMenuItem getChangeSampleCategoryMenu() {
        return changeSampleCategoryMenu;
    }

    public JButton getCreateBenthosBatchButton() {
        return createBenthosBatchButton;
    }

    public JMenuItem getCreateBenthosMelagMenu() {
        return createBenthosMelagMenu;
    }

    public JMenuItem getEditFrequenciesMenu() {
        return editFrequenciesMenu;
    }

    public JButton getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public JRadioButton getFilterBenthosBatchAllButton() {
        return filterBenthosBatchAllButton;
    }

    public JLabel getFilterBenthosBatchLabel() {
        return filterBenthosBatchLabel;
    }

    public JRadioButton getFilterBenthosBatchLeafButton() {
        return filterBenthosBatchLeafButton;
    }

    public JAXXButtonGroup getFilterBenthosBatchMode() {
        return filterBenthosBatchMode;
    }

    public JRadioButton getFilterBenthosBatchRootButton() {
        return filterBenthosBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public BenthosBatchUIHandler getHandler() {
        return handler;
    }

    public JButton getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public BenthosBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveBenthosBatchMenu() {
        return removeBenthosBatchMenu;
    }

    public JMenuItem getRemoveBenthosSubBatchMenu() {
        return removeBenthosSubBatchMenu;
    }

    public JMenuItem getRenameBenthosBatchMenu() {
        return renameBenthosBatchMenu;
    }

    public JAXXButtonGroup getSpeciesSort() {
        return speciesSort;
    }

    public JLabel getSpeciesSortBatchLabel() {
        return speciesSortBatchLabel;
    }

    public JRadioButton getSpeciesSortModeAscButton() {
        return speciesSortModeAscButton;
    }

    public JRadioButton getSpeciesSortModeDescButton() {
        return speciesSortModeDescButton;
    }

    public JRadioButton getSpeciesSortModeNoneButton() {
        return speciesSortModeNoneButton;
    }

    public JPanel getSpeciesSortTablePane() {
        return speciesSortTablePane;
    }

    public JMenuItem getSplitBenthosBatchMenu() {
        return splitBenthosBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        benthosBatchTabToolBar.add(importMultiPostButton);
        benthosBatchTabToolBar.add(exportMultiPostButton);
        benthosBatchTabToolBar.add(benthosBatchAttachmentsButton);
    }

    protected void addChildrenToEditBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(benthosBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterBenthosBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchAllButton); }
    }

    protected void addChildrenToFilterBenthosBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchLeafButton); }
    }

    protected void addChildrenToFilterBenthosBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterBenthosBatchLabel);
        filterTablePane.add(filterBenthosBatchAllButton);
        filterTablePane.add(filterBenthosBatchLeafButton);
        filterTablePane.add(filterBenthosBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSpeciesSortModeAscButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeAscButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeAscButton); }
    }

    protected void addChildrenToSpeciesSortModeDescButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeDescButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeDescButton); }
    }

    protected void addChildrenToSpeciesSortModeNoneButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeNoneButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeNoneButton); }
    }

    protected void addChildrenToSpeciesSortTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        speciesSortTablePane.add(speciesSortBatchLabel);
        speciesSortTablePane.add(speciesSortModeNoneButton);
        speciesSortTablePane.add(speciesSortModeAscButton);
        speciesSortTablePane.add(speciesSortModeDescButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitBenthosBatchMenu);
        tablePopup.add(changeSampleCategoryMenu);
        tablePopup.add(addSampleCategoryMenu);
        tablePopup.add(removeBenthosBatchMenu);
        tablePopup.add(removeBenthosSubBatchMenu);
        tablePopup.add(renameBenthosBatchMenu);
        tablePopup.add(createBenthosMelagMenu);
        tablePopup.add(editFrequenciesMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add($JPanel1, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSampleCategoryMenu() {
        $objectMap.put("addSampleCategoryMenu", addSampleCategoryMenu = new JMenuItem());
        
        addSampleCategoryMenu.setName("addSampleCategoryMenu");
        addSampleCategoryMenu.setText(t("tutti.editBenthosBatch.action.addSampleCategory"));
        addSampleCategoryMenu.setToolTipText(t("tutti.editBenthosBatch.action.addSampleCategory.tip"));
        addSampleCategoryMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addSampleCategoryMenu"));
        addSampleCategoryMenu.putClientProperty("help", "tutti.editBenthosBatch.action.addSampleCategory.help");
    }

    protected void createBenthosBatchAttachmentsButton() {
        $objectMap.put("benthosBatchAttachmentsButton", benthosBatchAttachmentsButton = new ButtonAttachment(handler.getContext(), getContextValue(EditCatchesUIModel.class)));
        
        benthosBatchAttachmentsButton.setName("benthosBatchAttachmentsButton");
        benthosBatchAttachmentsButton.setToolTipText(t("tutti.editBenthosBatch.action.attachments.tip"));
    }

    protected void createBenthosBatchTabToolBar() {
        $objectMap.put("benthosBatchTabToolBar", benthosBatchTabToolBar = new JToolBar());
        
        benthosBatchTabToolBar.setName("benthosBatchTabToolBar");
        benthosBatchTabToolBar.setFloatable(false);
        benthosBatchTabToolBar.setOpaque(false);
        benthosBatchTabToolBar.setBorderPainted(false);
    }

    protected void createBenthosTotalInertWeightField() {
        $objectMap.put("benthosTotalInertWeightField", benthosTotalInertWeightField = new ComputableDataEditor<Float>(this));
        
        benthosTotalInertWeightField.setName("benthosTotalInertWeightField");
        benthosTotalInertWeightField.setShowReset(true);
        benthosTotalInertWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        benthosTotalInertWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalInertWeightLabel() {
        $objectMap.put("benthosTotalInertWeightLabel", benthosTotalInertWeightLabel = new JLabel());
        
        benthosTotalInertWeightLabel.setName("benthosTotalInertWeightLabel");
        benthosTotalInertWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalInertWeight"));
        benthosTotalInertWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalInertWeight.tip"));
        benthosTotalInertWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        benthosTotalInertWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalLivingNotItemizedWeightField() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightField", benthosTotalLivingNotItemizedWeightField = new ComputableDataEditor<Float>(this));
        
        benthosTotalLivingNotItemizedWeightField.setName("benthosTotalLivingNotItemizedWeightField");
        benthosTotalLivingNotItemizedWeightField.setShowReset(true);
        benthosTotalLivingNotItemizedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        benthosTotalLivingNotItemizedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightLabel", benthosTotalLivingNotItemizedWeightLabel = new JLabel());
        
        benthosTotalLivingNotItemizedWeightLabel.setName("benthosTotalLivingNotItemizedWeightLabel");
        benthosTotalLivingNotItemizedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight"));
        benthosTotalLivingNotItemizedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.tip"));
        benthosTotalLivingNotItemizedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        benthosTotalLivingNotItemizedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.tip"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new ComputableDataEditor<Float>(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setShowReset(true);
        benthosTotalSortedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        benthosTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalSortedWeight"));
        benthosTotalSortedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalSortedWeight.tip"));
        benthosTotalSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        benthosTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight"));
        benthosTotalUnsortedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.tip"));
        benthosTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        benthosTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalWeight"));
        benthosTotalWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalWeight.tip"));
        benthosTotalWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        benthosTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editBenthosBatch.help"));
    }

    protected void createChangeSampleCategoryMenu() {
        $objectMap.put("changeSampleCategoryMenu", changeSampleCategoryMenu = new JMenuItem());
        
        changeSampleCategoryMenu.setName("changeSampleCategoryMenu");
        changeSampleCategoryMenu.setText(t("tutti.editBenthosBatch.action.changeSampleCategory"));
        changeSampleCategoryMenu.setToolTipText(t("tutti.editBenthosBatch.action.changeSampleCategory.tip"));
        changeSampleCategoryMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeSampleCategoryMenu"));
        changeSampleCategoryMenu.putClientProperty("help", "tutti.editBenthosBatch.action.changeSampleCategory.help");
    }

    protected void createCreateBenthosBatchButton() {
        $objectMap.put("createBenthosBatchButton", createBenthosBatchButton = new JButton());
        
        createBenthosBatchButton.setName("createBenthosBatchButton");
        createBenthosBatchButton.setText(t("tutti.editBenthosBatch.action.createBatch"));
        createBenthosBatchButton.setToolTipText(t("tutti.editBenthosBatch.action.createBatch.tip"));
        createBenthosBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createBenthosBatchButton"));
        createBenthosBatchButton.putClientProperty("help", "tutti.editBenthosBatch.action.createBatch.help");
    }

    protected void createCreateBenthosMelagMenu() {
        $objectMap.put("createBenthosMelagMenu", createBenthosMelagMenu = new JMenuItem());
        
        createBenthosMelagMenu.setName("createBenthosMelagMenu");
        createBenthosMelagMenu.setText(t("tutti.editBenthosBatch.action.createMelag"));
        createBenthosMelagMenu.setToolTipText(t("tutti.editBenthosBatch.action.createMelag.tip"));
        createBenthosMelagMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CreateBenthosMelagAction.class);
        createBenthosMelagMenu.putClientProperty("help", "tutti.editBenthosBatch.action.createMelag.help");
    }

    protected void createEditFrequenciesMenu() {
        $objectMap.put("editFrequenciesMenu", editFrequenciesMenu = new JMenuItem());
        
        editFrequenciesMenu.setName("editFrequenciesMenu");
        editFrequenciesMenu.setText(t("tutti.editBenthosBatch.action.editFrequencies"));
        editFrequenciesMenu.setToolTipText(t("tutti.editBenthosBatch.action.editFrequencies.tip"));
        editFrequenciesMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editFrequenciesMenu"));
        editFrequenciesMenu.putClientProperty("help", "tutti.editBenthosBatch.action.editFrequencies.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JButton());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editBenthosBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editBenthosBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportMultiPostBenthosAction.class);
        exportMultiPostButton.putClientProperty("help", "tutti.editBenthosBatch.action.exportMultiPost.help");
    }

    protected void createFilterBenthosBatchAllButton() {
        $objectMap.put("filterBenthosBatchAllButton", filterBenthosBatchAllButton = new JRadioButton());
        
        filterBenthosBatchAllButton.setName("filterBenthosBatchAllButton");
        filterBenthosBatchAllButton.setText(t("tutti.editBenthosBatch.filterBatch.mode.all"));
        { filterBenthosBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterBenthosBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchAllButton.setToolTipText(t("tutti.editBenthosBatch.filterBatch.mode.all.tip"));
        filterBenthosBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchAllButton"));
    }

    protected void createFilterBenthosBatchLabel() {
        $objectMap.put("filterBenthosBatchLabel", filterBenthosBatchLabel = new JLabel());
        
        filterBenthosBatchLabel.setName("filterBenthosBatchLabel");
        filterBenthosBatchLabel.setText(t("tutti.editBenthosBatch.filterBatch"));
        filterBenthosBatchLabel.setToolTipText(t("tutti.editBenthosBatch.filterBatch.tip"));
        filterBenthosBatchLabel.putClientProperty("help", "tutti.editBenthosBatch.filterBatch.help");
        filterBenthosBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterBenthosBatchLeafButton() {
        $objectMap.put("filterBenthosBatchLeafButton", filterBenthosBatchLeafButton = new JRadioButton());
        
        filterBenthosBatchLeafButton.setName("filterBenthosBatchLeafButton");
        filterBenthosBatchLeafButton.setText(t("tutti.editBenthosBatch.filterBatch.mode.leaf"));
        { filterBenthosBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterBenthosBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchLeafButton.setToolTipText(t("tutti.editBenthosBatch.filterBatch.mode.leaf.tip"));
        filterBenthosBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchLeafButton"));
    }

    protected void createFilterBenthosBatchMode() {
        $objectMap.put("filterBenthosBatchMode", filterBenthosBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterBenthosBatchRootButton() {
        $objectMap.put("filterBenthosBatchRootButton", filterBenthosBatchRootButton = new JRadioButton());
        
        filterBenthosBatchRootButton.setName("filterBenthosBatchRootButton");
        { filterBenthosBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterBenthosBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchRootButton.setToolTipText(t("tutti.editBenthosBatch.filterBatch.mode.root.tip"));
        filterBenthosBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected BenthosBatchUIHandler createHandler() {
        return new BenthosBatchUIHandler();
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JButton());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editBenthosBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editBenthosBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportMultiPostBenthosAction.class);
        importMultiPostButton.putClientProperty("help", "tutti.editBenthosBatch.action.importMultiPost.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosBatchUIModel.class));
    }

    protected void createRemoveBenthosBatchMenu() {
        $objectMap.put("removeBenthosBatchMenu", removeBenthosBatchMenu = new JMenuItem());
        
        removeBenthosBatchMenu.setName("removeBenthosBatchMenu");
        removeBenthosBatchMenu.setText(t("tutti.editBenthosBatch.action.removeBatch"));
        removeBenthosBatchMenu.setToolTipText(t("tutti.editBenthosBatch.action.removeBatch.tip"));
        removeBenthosBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.RemoveBenthosBatchAction.class);
        removeBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeBatch.help");
    }

    protected void createRemoveBenthosSubBatchMenu() {
        $objectMap.put("removeBenthosSubBatchMenu", removeBenthosSubBatchMenu = new JMenuItem());
        
        removeBenthosSubBatchMenu.setName("removeBenthosSubBatchMenu");
        removeBenthosSubBatchMenu.setText(t("tutti.editBenthosBatch.action.removeSubBatch"));
        removeBenthosSubBatchMenu.setToolTipText(t("tutti.editBenthosBatch.action.removeSubBatch.tip"));
        removeBenthosSubBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.RemoveBenthosSubBatchAction.class);
        removeBenthosSubBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeSubBatch.help");
    }

    protected void createRenameBenthosBatchMenu() {
        $objectMap.put("renameBenthosBatchMenu", renameBenthosBatchMenu = new JMenuItem());
        
        renameBenthosBatchMenu.setName("renameBenthosBatchMenu");
        renameBenthosBatchMenu.setText(t("tutti.editBenthosBatch.action.renameBatch"));
        renameBenthosBatchMenu.setToolTipText(t("tutti.editBenthosBatch.action.renameBatch.tip"));
        renameBenthosBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.RenameBenthosBatchAction.class);
        renameBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.renameBatch.help");
    }

    protected void createSpeciesSort() {
        $objectMap.put("speciesSort", speciesSort = new JAXXButtonGroup());
    }

    protected void createSpeciesSortBatchLabel() {
        $objectMap.put("speciesSortBatchLabel", speciesSortBatchLabel = new JLabel());
        
        speciesSortBatchLabel.setName("speciesSortBatchLabel");
        speciesSortBatchLabel.setText(t("tutti.editBenthosBatch.sortSpeciesBatch"));
        speciesSortBatchLabel.setToolTipText(t("tutti.editBenthosBatch.sortSpeciesBatch.tip"));
        speciesSortBatchLabel.putClientProperty("help", "tutti.editBenthosBatch.sortSpeciesBatch.help");
        speciesSortBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createSpeciesSortModeAscButton() {
        $objectMap.put("speciesSortModeAscButton", speciesSortModeAscButton = new JRadioButton());
        
        speciesSortModeAscButton.setName("speciesSortModeAscButton");
        speciesSortModeAscButton.setText(t("tutti.editBenthosBatch.speciesSortMode.asc"));
        { speciesSortModeAscButton.putClientProperty("$value", "ASC");  Object $buttonGroup = speciesSortModeAscButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeAscButton.setToolTipText(t("tutti.editBenthosBatch.speciesSortMode.asc.tip"));
        speciesSortModeAscButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeAscButton"));
        speciesSortModeAscButton.putClientProperty("help", "tutti.editBenthosBatch.field.speciesSortMode.asc.help");
    }

    protected void createSpeciesSortModeDescButton() {
        $objectMap.put("speciesSortModeDescButton", speciesSortModeDescButton = new JRadioButton());
        
        speciesSortModeDescButton.setName("speciesSortModeDescButton");
        speciesSortModeDescButton.setText(t("tutti.editBenthosBatch.speciesSortMode.desc"));
        { speciesSortModeDescButton.putClientProperty("$value", "DESC");  Object $buttonGroup = speciesSortModeDescButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeDescButton.setToolTipText(t("tutti.editBenthosBatch.speciesSortMode.desc.tip"));
        speciesSortModeDescButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeDescButton"));
        speciesSortModeDescButton.putClientProperty("help", "tutti.editBenthosBatch.field.speciesSortMode.desc.help");
    }

    protected void createSpeciesSortModeNoneButton() {
        $objectMap.put("speciesSortModeNoneButton", speciesSortModeNoneButton = new JRadioButton());
        
        speciesSortModeNoneButton.setName("speciesSortModeNoneButton");
        speciesSortModeNoneButton.setText(t("tutti.editBenthosBatch.speciesSortMode.none"));
        { speciesSortModeNoneButton.putClientProperty("$value", "NONE");  Object $buttonGroup = speciesSortModeNoneButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeNoneButton.setToolTipText(t("tutti.editBenthosBatch.speciesSortMode.none.tip"));
        speciesSortModeNoneButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeNoneButton"));
        speciesSortModeNoneButton.putClientProperty("help", "tutti.editBenthosBatch.field.speciesSortMode.none.help");
    }

    protected void createSpeciesSortTablePane() {
        $objectMap.put("speciesSortTablePane", speciesSortTablePane = new JPanel());
        
        speciesSortTablePane.setName("speciesSortTablePane");
    }

    protected void createSplitBenthosBatchMenu() {
        $objectMap.put("splitBenthosBatchMenu", splitBenthosBatchMenu = new JMenuItem());
        
        splitBenthosBatchMenu.setName("splitBenthosBatchMenu");
        splitBenthosBatchMenu.setText(t("tutti.editBenthosBatch.action.splitBatch"));
        splitBenthosBatchMenu.setToolTipText(t("tutti.editBenthosBatch.action.splitBatch.tip"));
        splitBenthosBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitBenthosBatchMenu"));
        splitBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.splitBatch.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editBenthosBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToBenthosBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createBenthosBatchButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(filterTablePane);
        $JPanel1.add(speciesSortTablePane);
        addChildrenToFilterTablePane();
        addChildrenToFilterBenthosBatchAllButton();
        addChildrenToFilterBenthosBatchLeafButton();
        addChildrenToFilterBenthosBatchRootButton();
        addChildrenToSpeciesSortTablePane();
        addChildrenToSpeciesSortModeNoneButton();
        addChildrenToSpeciesSortModeAscButton();
        addChildrenToSpeciesSortModeDescButton();
        addChildrenToTableScrollPane();
        
        // apply 24 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 50 property setters
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.exportMultiPost.mnemonic"),'Z'));
        splitBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        splitBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.splitBatch.mnemonic"),'Z'));
        changeSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        changeSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.changeSampleCategory.mnemonic"),'Z'));
        addSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        addSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.addSampleCategory.mnemonic"),'Z'));
        removeBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.removeBatch.mnemonic"),'Z'));
        removeBenthosSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosSubBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.removeSubBatch.mnemonic"),'Z'));
        renameBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        renameBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.renameBatch.mnemonic"),'Z'));
        createBenthosMelagMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        createBenthosMelagMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.createMelag.mnemonic"),'Z'));
        editFrequenciesMenu.setIcon(SwingUtil.createActionIcon("show-frequency"));
        editFrequenciesMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.editFrequencies.mnemonic"),'Z'));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSortedWeightField.setNumberType(Float.class);
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        benthosTotalInertWeightLabel.setLabelFor(benthosTotalInertWeightField);
        benthosTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalInertWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalInertWeightField.setNumberType(Float.class);
        benthosTotalLivingNotItemizedWeightLabel.setLabelFor(benthosTotalLivingNotItemizedWeightField);
        benthosTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalLivingNotItemizedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalLivingNotItemizedWeightField.setNumberType(Float.class);
        createBenthosBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createBenthosBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.createBatch.mnemonic"),'Z'));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterBenthosBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        speciesSortTablePane.setBorder(new TitledBorder(null, ""));
        speciesSortBatchLabel.setIcon(SwingUtil.createActionIcon("sort"));
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editBenthosBatchTopPanel, "tutti.editBenthosBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editBenthosBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editBenthosBatch.action.exportMultiPost.help");
        registerHelpId(_broker, splitBenthosBatchMenu, "tutti.editBenthosBatch.action.splitBatch.help");
        registerHelpId(_broker, changeSampleCategoryMenu, "tutti.editBenthosBatch.action.changeSampleCategory.help");
        registerHelpId(_broker, addSampleCategoryMenu, "tutti.editBenthosBatch.action.addSampleCategory.help");
        registerHelpId(_broker, removeBenthosBatchMenu, "tutti.editBenthosBatch.action.removeBatch.help");
        registerHelpId(_broker, removeBenthosSubBatchMenu, "tutti.editBenthosBatch.action.removeSubBatch.help");
        registerHelpId(_broker, renameBenthosBatchMenu, "tutti.editBenthosBatch.action.renameBatch.help");
        registerHelpId(_broker, createBenthosMelagMenu, "tutti.editBenthosBatch.action.createMelag.help");
        registerHelpId(_broker, editFrequenciesMenu, "tutti.editBenthosBatch.action.editFrequencies.help");
        registerHelpId(_broker, benthosTotalWeightLabel, "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalWeightField, "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightField, "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightField, "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightField, "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalInertWeightLabel, "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        registerHelpId(_broker, benthosTotalInertWeightField, "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        registerHelpId(_broker, benthosTotalLivingNotItemizedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, benthosTotalLivingNotItemizedWeightField, "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, createBenthosBatchButton, "tutti.editBenthosBatch.action.createBatch.help");
        registerHelpId(_broker, filterBenthosBatchLabel, "tutti.editBenthosBatch.filterBatch.help");
        registerHelpId(_broker, speciesSortBatchLabel, "tutti.editBenthosBatch.sortSpeciesBatch.help");
        registerHelpId(_broker, speciesSortModeNoneButton, "tutti.editBenthosBatch.field.speciesSortMode.none.help");
        registerHelpId(_broker, speciesSortModeAscButton, "tutti.editBenthosBatch.field.speciesSortMode.asc.help");
        registerHelpId(_broker, speciesSortModeDescButton, "tutti.editBenthosBatch.field.speciesSortMode.desc.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editBenthosBatchTopPanel", editBenthosBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createBenthosBatchTabToolBar();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createBenthosBatchAttachmentsButton();
        createTablePopup();
        createSplitBenthosBatchMenu();
        createChangeSampleCategoryMenu();
        createAddSampleCategoryMenu();
        createRemoveBenthosBatchMenu();
        createRemoveBenthosSubBatchMenu();
        createRenameBenthosBatchMenu();
        createCreateBenthosMelagMenu();
        createEditFrequenciesMenu();
        createForm();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createBenthosTotalInertWeightLabel();
        createBenthosTotalInertWeightField();
        createBenthosTotalLivingNotItemizedWeightLabel();
        createBenthosTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateBenthosBatchButton();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout());
        createFilterTablePane();
        createFilterBenthosBatchLabel();
        createFilterBenthosBatchAllButton();
        createFilterBenthosBatchLeafButton();
        createFilterBenthosBatchRootButton();
        createSpeciesSortTablePane();
        createSpeciesSortBatchLabel();
        createSpeciesSortModeNoneButton();
        createSpeciesSortModeAscButton();
        createSpeciesSortModeDescButton();
        createTableScrollPane();
        createTable();
        createFilterBenthosBatchMode();
        createSpeciesSort();
        // inline creation of editBenthosBatchTopPanel
        setName("editBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        editBenthosBatchTopPanel.putClientProperty("help", "tutti.editBenthosBatch.help");
        
        // registers 24 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 24 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    changeSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isChangeSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isAddSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_BENTHOS_MELAG_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createMelagEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createBenthosMelagMenu.setEnabled(!model.isTableViewModeLeaf() && model.isCreateMelagEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createMelagEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_FREQUENCIES_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editFrequenciesMenu.setEnabled(model.isTableViewModeAll() && model.isEditFrequenciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalWeightField, handler.getWeightStringValue(benthosTotalWeightLabel, model.getBenthosTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setBean(model.getBenthosTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setNumberValue(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalSampleSortedWeightField, handler.getWeightStringValue(benthosTotalSampleSortedWeightLabel, model.getBenthosTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, handler.getWeightStringValue(benthosTotalUnsortedWeightLabel, model.getBenthosTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setBean(model.getBenthosTotalInertComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setNumberValue(model.getBenthosTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setBean(model.getBenthosTotalLivingNotItemizedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setNumberValue(model.getBenthosTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setText(t(handler.getFilterBenthosBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeNone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeNoneButton.setSelected(model.isSpeciesSortModeNone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeNone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeAscButton.setSelected(model.isSpeciesSortModeAsc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeDescButton.setSelected(model.isSpeciesSortModeDesc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        });
    }

}