/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.test;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatchs;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatchs;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocations;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.junit.Assert;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class DatabaseFixtures {
    protected CruisePersistenceService cruiseService;
    protected ProgramPersistenceService programService;
    protected FishingOperationPersistenceService fishingOperationService;
    protected CatchBatchPersistenceService catchBatchService;
    protected ReferentialPersistenceService referentialService;
    protected AccidentalBatchPersistenceService accidentalBatchService;
    protected IndividualObservationBatchPersistenceService individualObservationBatchService;

    public Version lastAdagioSchemaVersion() {
        return VersionUtil.valueOf((String)"3.2.3");
    }

    public Version currentAdagioSchemaVersion() {
        return VersionUtil.valueOf((String)"3.2.1.01");
    }

    public String programCode() {
        return "CAM-CGFS";
    }

    public String cruiseId() {
        return "100000";
    }

    public String fishingVesselCode() {
        return "851751";
    }

    public String zoneId() {
        return "61979";
    }

    public String strataId() {
        return "57377";
    }

    public String subStrataId() {
        return "61995";
    }

    public String localite() {
        return "57774";
    }

    public int refNbCaracteristic() {
        return 485;
    }

    public int refNbSpecies() {
        return 16961;
    }

    public int refNbReferentSpecies() {
        return 8649;
    }

    public int refNbScientificGear() {
        return 9;
    }

    public int refNbFishingGear() {
        return 75;
    }

    public int refNbCountry() {
        return 239;
    }

    public int refNbHarbour() {
        return 1898;
    }

    public int refNbProgramZone() {
        return 14;
    }

    public int refNbStrata() {
        return 76;
    }

    public int refNbSubStrata() {
        return 16;
    }

    public int refNbLocalite() {
        return 129;
    }

    public int refNbFishingVessel() {
        return 24837;
    }

    public int refNbScientificVessel() {
        return 3;
    }

    public int refNbPerson() {
        return 128;
    }

    public int refNbObjectType() {
        return 57;
    }

    public String refSpeciesId() {
        return "15923";
    }

    public Integer refSpeciesTaxonId() {
        return 467;
    }

    public Integer refNumericalPmfmId() {
        return 113;
    }

    public Integer refAlphanumericPmfmId() {
        return 1424;
    }

    public String refSpeciesRefTaxCode() {
        return "SEPIOFF";
    }

    public String refSpeciesVernacularCode() {
        return "Seiche";
    }

    public Integer refBadSpeciesTaxonId() {
        return 7632;
    }

    public Integer refBad2SpeciesTaxonId() {
        return 2320;
    }

    public String objectTypeCode() {
        return "BATCH";
    }

    public Integer caracteristicWithNullQualitativeValue() {
        return 114;
    }

    public void setUp() {
        if (this.referentialService == null) {
            this.referentialService = TuttiPersistenceServiceLocator.getReferentialPersistenceService();
            this.programService = TuttiPersistenceServiceLocator.getProgramPersistenceService();
            this.cruiseService = TuttiPersistenceServiceLocator.getCruisePersistenceService();
            this.fishingOperationService = TuttiPersistenceServiceLocator.getFishingOperationPersistenceService();
            this.catchBatchService = TuttiPersistenceServiceLocator.getCatchBatchPersistenceService();
            this.accidentalBatchService = TuttiPersistenceServiceLocator.getAccidentalBatchPersistenceService();
            this.individualObservationBatchService = TuttiPersistenceServiceLocator.getIndividualObservationBatchPersistenceService();
        }
    }

    public Cruise createCruise() {
        this.setUp();
        String programCode = this.programCode();
        Cruise cruise = Cruises.newCruise();
        cruise.setId((String)null);
        cruise.setName("Unit-test-" + System.currentTimeMillis());
        cruise.setProgram(this.programService.getProgram(programCode));
        GregorianCalendar calendar = new GregorianCalendar();
        cruise.setBeginDate(calendar.getTime());
        ((Calendar)calendar).add(2, 1);
        cruise.setEndDate(calendar.getTime());
        List<TuttiLocation> allHarbour = this.referentialService.getAllHarbour();
        Assert.assertNotNull(allHarbour);
        Assert.assertTrue((allHarbour.size() > 1 ? 1 : 0) != 0);
        cruise.setDepartureLocation(allHarbour.get(0));
        cruise.setReturnLocation(allHarbour.get(1));
        List<Gear> gears = this.referentialService.getAllFishingGear();
        ArrayList gearsWithOrder = Lists.newArrayListWithCapacity((int)gears.size());
        short rankOrder = 0;
        for (Gear gear : gears) {
            Object gearWithOriginalRankOrder = GearWithOriginalRankOrders.newGearWithOriginalRankOrder(gear);
            gearWithOriginalRankOrder.setOriginalRankOrder(rankOrder);
            gearWithOriginalRankOrder.setRankOrder(rankOrder);
            rankOrder = (short)(rankOrder + 1);
            gearsWithOrder.add(gearWithOriginalRankOrder);
        }
        cruise.setGear(Lists.newArrayList((Iterable)gearsWithOrder));
        cruise.setComment("My comments on cruise");
        cruise.setSurveyPart("SurveyPart");
        Person managerPerson = this.referentialService.getAllPerson().get(0);
        cruise.setHeadOfMission(Lists.newArrayList((Object[])new Person[]{managerPerson}));
        Vessel fishingVessel = Vessels.newVessel();
        fishingVessel.setId(this.fishingVesselCode());
        cruise.setVessel(fishingVessel);
        cruise.setMultirigNumber(2);
        Cruise result = this.cruiseService.createCruise(cruise);
        return result;
    }

    public FishingOperation createFishingOperation(Cruise cruise) {
        this.setUp();
        FishingOperation fishingOperation = FishingOperations.newFishingOperation();
        fishingOperation.setCruise(cruise);
        fishingOperation.setComment("newFishingOperation");
        fishingOperation.setFishingOperationNumber(1);
        List<Caracteristic> allEnvironmentCaracteristics = this.referentialService.getAllCaracteristic();
        CaracteristicMap environmentCaracteristics = new CaracteristicMap();
        CaracteristicMap environmentValuesOneEntry = new CaracteristicMap();
        int count = 0;
        for (Caracteristic caracteristic : allEnvironmentCaracteristics) {
            if (count == 3) break;
            Object value = null;
            if (caracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
                value = Float.valueOf(1.0f);
                ++count;
            } else if (caracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
                value = "some text";
                ++count;
            } else if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE && caracteristic.getQualitativeValue(0) != null) {
                value = caracteristic.getQualitativeValue(0);
                ++count;
            }
            if (value == null) continue;
            environmentCaracteristics.put(caracteristic, value);
            if (environmentValuesOneEntry.size() != 0) continue;
            environmentValuesOneEntry.put(caracteristic, value);
        }
        List<Caracteristic> allGearShootingCaracteristics = this.referentialService.getAllCaracteristic();
        CaracteristicMap gearShootingCaracteristics = new CaracteristicMap();
        CaracteristicMap gearShootingCaracteristicsOneEntry = new CaracteristicMap();
        count = 0;
        for (Caracteristic caracteristic : allGearShootingCaracteristics) {
            if (count == 3) break;
            Object value = null;
            if (caracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
                value = Float.valueOf(1.0f);
                ++count;
            } else if (caracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
                value = "some text";
                ++count;
            } else if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE && caracteristic.getQualitativeValue(0) != null) {
                value = caracteristic.getQualitativeValue(0);
                ++count;
            }
            if (value == null) continue;
            gearShootingCaracteristics.put(caracteristic, value);
            if (gearShootingCaracteristicsOneEntry.size() != 0) continue;
            gearShootingCaracteristicsOneEntry.put(caracteristic, value);
        }
        Calendar calendar = Calendar.getInstance();
        fishingOperation.setId((String)null);
        fishingOperation.setStationNumber("STA2");
        fishingOperation.setFishingOperationNumber(2);
        fishingOperation.setMultirigAggregation("1");
        calendar.setTime(new Date());
        calendar.set(11, 1);
        calendar.set(14, 99);
        fishingOperation.setGearShootingStartDate(calendar.getTime());
        calendar.setTime(new Date());
        calendar.set(11, 10);
        calendar.set(14, 99);
        fishingOperation.setGearShootingEndDate(calendar.getTime());
        fishingOperation.setGearShootingStartLatitude(Float.valueOf(47.6f));
        fishingOperation.setGearShootingStartLongitude(Float.valueOf(-5.05f));
        fishingOperation.setGearShootingEndLatitude(Float.valueOf(47.9854f));
        fishingOperation.setGearShootingEndLongitude(Float.valueOf(-5.597f));
        fishingOperation.setTrawlDistance(Float.valueOf(100.12345f));
        fishingOperation.setFishingOperationRectiligne(true);
        fishingOperation.setFishingOperationValid(Boolean.TRUE);
        fishingOperation.setComment("Unit test createFishingOperation() - Part n\u00b02 : All properties set");
        fishingOperation.setGear(cruise.getGear(0));
        fishingOperation.setVessel(cruise.getVessel());
        fishingOperation.setVesselUseFeatures(environmentCaracteristics);
        fishingOperation.setGearUseFeatures(gearShootingCaracteristics);
        TuttiLocation strata = TuttiLocations.newTuttiLocation();
        strata.setId(this.strataId());
        fishingOperation.setStrata(strata);
        TuttiLocation subStrata = TuttiLocations.newTuttiLocation();
        subStrata.setId(this.subStrataId());
        fishingOperation.setSubStrata(subStrata);
        TuttiLocation localite = TuttiLocations.newTuttiLocation();
        localite.setId(this.localite());
        fishingOperation.setLocation(localite);
        FishingOperation result = this.fishingOperationService.createFishingOperation(fishingOperation);
        return result;
    }

    public CatchBatch createMinimalCatchBatch(FishingOperation fishingOperation) {
        this.setUp();
        CatchBatch catchBatch = CatchBatchs.newCatchBatch();
        catchBatch.setFishingOperation(fishingOperation);
        CatchBatch result = this.catchBatchService.createCatchBatch(catchBatch);
        return result;
    }

    public AccidentalBatch createMinimalAccidentalBatch(FishingOperation fishingOperation) {
        this.setUp();
        AccidentalBatch minimalAccidentalBatch = AccidentalBatchs.newAccidentalBatch();
        minimalAccidentalBatch.setFishingOperation(fishingOperation);
        minimalAccidentalBatch.setSpecies(this.referentialService.getSpeciesByReferenceTaxonId(this.refSpeciesTaxonId()));
        minimalAccidentalBatch.setCaracteristics(new CaracteristicMap());
        AccidentalBatch result = this.accidentalBatchService.createAccidentalBatch(minimalAccidentalBatch);
        return result;
    }

    public IndividualObservationBatch createMinimalIndividualObservationBatch(FishingOperation fishingOperation) {
        this.setUp();
        IndividualObservationBatch minimalAccidentalBatch = IndividualObservationBatchs.newIndividualObservationBatch();
        minimalAccidentalBatch.setFishingOperation(fishingOperation);
        minimalAccidentalBatch.setSpecies(this.referentialService.getSpeciesByReferenceTaxonId(this.refSpeciesTaxonId()));
        minimalAccidentalBatch.setCaracteristics(new CaracteristicMap());
        minimalAccidentalBatch.setLengthStepCaracteristic(this.referentialService.getCaracteristic(this.refNumericalPmfmId()));
        minimalAccidentalBatch.setSize(Float.valueOf(10.0f));
        minimalAccidentalBatch.setWeight(Float.valueOf(5.0f));
        IndividualObservationBatch result = this.individualObservationBatchService.createIndividualObservationBatch(minimalAccidentalBatch);
        return result;
    }
}

