/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.updater.DownloadMonitor;

public class ProgressionModel
extends AbstractSerializableBean
implements DownloadMonitor {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_TOTAL = "total";
    public static final String PROPERTY_CURRENT = "current";
    public static final String PROPERTY_RATE = "rate";
    public static final String PROPERTY_MESSAGE = "message";
    protected int total;
    protected int current;
    protected float rate;
    protected String message;

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        Integer oldValue = this.getTotal();
        this.total = total;
        this.firePropertyChange(PROPERTY_TOTAL, oldValue, total);
        this.setCurrent(0);
    }

    public void adaptTotal(int total) {
        long current = this.getCurrent();
        this.setTotal(total);
        this.increments((int)current);
        Integer oldValue = this.getTotal();
        this.total = total;
        this.firePropertyChange(PROPERTY_TOTAL, oldValue, total);
        this.setCurrent(current);
    }

    public long getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        Long oldValue = this.getCurrent();
        this.current = current;
        this.firePropertyChange(PROPERTY_CURRENT, oldValue, current);
    }

    public void increments(int nb) {
        this.setCurrent(this.current + nb);
        this.setRate(this.getCurrent() / (long)this.getTotal());
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        Float oldValue = Float.valueOf(this.getRate());
        this.rate = rate;
        this.firePropertyChange(PROPERTY_RATE, oldValue, Float.valueOf(rate));
    }

    public String getMessage() {
        return this.message;
    }

    public void increments(String message) {
        this.increments(1);
        this.setMessage(message);
    }

    public void setMessage(String message) {
        String oldValue = this.getMessage();
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }

    public void setSize(long size) {
        this.setTotal((int)size);
    }

    public void setCurrent(long current) {
        this.setCurrent((int)current);
    }
}

