/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.ExportDbAction;
import fr.ifremer.tutti.ui.swing.content.db.InstallDbAction;
import java.io.File;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ReinstallDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ReinstallDbAction.class);
    protected File backupFile;
    protected String jdbcUrl;

    public ReinstallDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            TuttiUIContext context = this.getContext();
            doAction = context.checkUpdateDbReachable();
        }
        if (doAction) {
            this.jdbcUrl = null;
            this.backupFile = null;
            this.jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
            if (((TuttiUIContext)this.getModel()).isDbExist()) {
                this.displayInfoMessage(I18n._((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.installDb.backup.db", (Object[])new Object[0]));
                this.backupFile = this.saveFile(this.getConfig().getServiceConfig().getPersistenceConfig().getDbBackupDirectory(), "tutti-db-" + ExportDbAction.df.format(new Date()), "zip", I18n._((String)"tutti.dbManager.title.choose.dbExportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbExportFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
                if (this.backupFile == null) {
                    this.displayWarningMessage(I18n._((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.installDb.no.backup.db.choosen", (Object[])new Object[0]));
                    doAction = false;
                }
            }
        }
        if (doAction) {
            ProgressionModel progressionModel = new ProgressionModel();
            progressionModel.setTotal(3);
            this.setProgressionModel(progressionModel);
        }
        return doAction;
    }

    @Override
    public void doAction() {
        Preconditions.checkNotNull((Object)this.backupFile);
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n._((String)"tutti.reinstallDb.step.closeDb", (Object[])new Object[]{this.jdbcUrl}));
        this.getContext().setDbLoaded(false);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        progressionModel.increments(I18n._((String)"tutti.reinstallDb.step.backupDb", (Object[])new Object[]{this.backupFile}));
        this.getContext().getPersistenceService().exportDb(this.backupFile);
        this.getContext().clearDbContext();
        String actionContent = InstallDbAction.class.getName();
        File startActionFile = this.getConfig().getStartActionFile();
        TuttiIOUtil.writeContent(startActionFile, actionContent, I18n._((String)"tutti.error.write.startActionFile", (Object[])new Object[]{startActionFile}));
        progressionModel.increments(I18n._((String)"tutti.reinstallDb.step.reloadApplication", (Object[])new Object[0]));
        RunTutti.closeTutti((MainUIHandler)this.getHandler(), 89);
    }
}

