/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.cruise.GearCaracteristicsEditorUI;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewGearCaracteristicsAction
extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ViewGearCaracteristicsAction.class);
    protected final PersistenceService persistenceService = this.getContext().getPersistenceService();

    public ViewGearCaracteristicsAction(EditCruiseUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        GearCaracteristicsEditorUI editor = ((EditCruiseUI)this.getUI()).getGearCaracteristicsEditor();
        editor.getModel().setEditable(false);
        Gear gear = ((EditCruiseUI)this.getUI()).getContextValue(Gear.class);
        gear = this.persistenceService.getGearWithCaracteristics(gear, this.getDataContext().getCruise());
        if (log.isInfoEnabled()) {
            log.info((Object)("Will view gear " + this.decorate(gear, "gearWithrankOrder")));
        }
        editor.getModel().setGear(gear);
        ((EditCruiseUI)this.getUI()).getMainPanelLayout().setSelected("gearCaracteristics");
    }
}

