/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.syntax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.translation.TranslationUtils;
import org.andromda.translation.ocl.node.AActualParameterList;
import org.andromda.translation.ocl.node.ACommaExpression;
import org.andromda.translation.ocl.node.AFeatureCall;
import org.andromda.translation.ocl.node.AFeatureCallParameters;
import org.andromda.translation.ocl.node.AOperation;
import org.andromda.translation.ocl.node.APropertyCallExpression;
import org.andromda.translation.ocl.node.ARelationalExpression;
import org.andromda.translation.ocl.node.ARelationalExpressionTail;
import org.andromda.translation.ocl.node.AStandardDeclarator;
import org.andromda.translation.ocl.node.ATypeDeclaration;
import org.andromda.translation.ocl.node.AVariableDeclaration;
import org.andromda.translation.ocl.node.AVariableDeclarationList;
import org.andromda.translation.ocl.node.AVariableDeclarationListTail;
import org.andromda.translation.ocl.node.PActualParameterList;
import org.andromda.translation.ocl.node.PEqualExpression;
import org.andromda.translation.ocl.node.PFeatureCallParameters;
import org.andromda.translation.ocl.node.POperation;
import org.andromda.translation.ocl.node.PRelationalExpression;
import org.andromda.translation.ocl.node.PVariableDeclaration;
import org.andromda.translation.ocl.node.PVariableDeclarationList;
import org.andromda.translation.ocl.node.TName;
import org.andromda.translation.ocl.syntax.OCLPatterns;
import org.andromda.translation.ocl.syntax.OperationDeclaration;
import org.andromda.translation.ocl.syntax.OperationDeclarationImpl;
import org.andromda.translation.ocl.syntax.VariableDeclaration;
import org.andromda.translation.ocl.syntax.VariableDeclarationImpl;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConcreteSyntaxUtils {
    private static final Logger logger = Logger.getLogger((Class)(class$org$andromda$translation$ocl$syntax$ConcreteSyntaxUtils == null ? (class$org$andromda$translation$ocl$syntax$ConcreteSyntaxUtils = ConcreteSyntaxUtils.class$("org.andromda.translation.ocl.syntax.ConcreteSyntaxUtils")) : class$org$andromda$translation$ocl$syntax$ConcreteSyntaxUtils));
    private static final String ARROW_FEATURE_CALL = "->";
    static /* synthetic */ Class class$org$andromda$translation$ocl$syntax$ConcreteSyntaxUtils;

    public static StringBuffer concatContents(List list) {
        StringBuffer name = new StringBuffer();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String value = ObjectUtils.toString(iterator.next());
                name.append(value);
            }
        }
        return name;
    }

    public static OperationDeclaration getOperationDeclaration(POperation operation) {
        ExceptionUtils.checkNull((String)"operation", (Object)operation);
        OperationDeclarationImpl operationDeclaration = null;
        AOperation op = (AOperation)operation;
        ATypeDeclaration typeDeclaration = (ATypeDeclaration)op.getReturnTypeDeclaration();
        String returnType = null;
        if (typeDeclaration != null) {
            returnType = ObjectUtils.toString((Object)typeDeclaration.getType());
        }
        operationDeclaration = new OperationDeclarationImpl(ObjectUtils.toString((Object)op.getName()), returnType, ConcreteSyntaxUtils.getVariableDeclarations(operation));
        return operationDeclaration;
    }

    public static VariableDeclaration[] getVariableDeclarations(POperation operation) {
        ExceptionUtils.checkNull((String)"operation", (Object)operation);
        return ConcreteSyntaxUtils.getVariableDeclarations(((AOperation)operation).getParameters());
    }

    public static VariableDeclaration[] getVariableDeclarations(AStandardDeclarator standardDeclarator) {
        ExceptionUtils.checkNull((String)"standardDeclarator", (Object)standardDeclarator);
        return ConcreteSyntaxUtils.getVariableDeclarations(standardDeclarator.getVariableDeclarationList());
    }

    protected static VariableDeclaration newVariableDeclaration(PVariableDeclaration variableDeclaration, PEqualExpression initialValue) {
        ExceptionUtils.checkNull((String)"variableDeclaration", (Object)variableDeclaration);
        AVariableDeclaration declaration = (AVariableDeclaration)variableDeclaration;
        ATypeDeclaration typeDeclaration = (ATypeDeclaration)declaration.getTypeDeclaration();
        String type = null;
        String name = ObjectUtils.toString((Object)declaration.getName()).trim();
        if (typeDeclaration != null) {
            type = ObjectUtils.toString((Object)typeDeclaration.getType());
        }
        return new VariableDeclarationImpl(name, type, ObjectUtils.toString((Object)initialValue).trim());
    }

    public static VariableDeclaration[] getVariableDeclarations(PVariableDeclarationList variableDeclarationList) {
        AVariableDeclarationList variables;
        ArrayList<VariableDeclaration> declarations = new ArrayList<VariableDeclaration>();
        if (variableDeclarationList != null && (variables = (AVariableDeclarationList)variableDeclarationList) != null) {
            declarations.add(ConcreteSyntaxUtils.newVariableDeclaration(variables.getVariableDeclaration(), variables.getVariableDeclarationValue()));
            LinkedList variableTails = variables.getVariableDeclarationListTail();
            if (variableTails != null) {
                Iterator variableTailIt = variableTails.iterator();
                while (variableTailIt.hasNext()) {
                    AVariableDeclarationListTail tail = (AVariableDeclarationListTail)variableTailIt.next();
                    declarations.add(ConcreteSyntaxUtils.newVariableDeclaration(tail.getVariableDeclaration(), tail.getVariableDeclarationValue()));
                }
            }
        }
        return declarations.toArray(new VariableDeclaration[0]);
    }

    public static List getParameters(AFeatureCall featureCall) {
        List parameters = new ArrayList();
        if (featureCall != null) {
            parameters = ConcreteSyntaxUtils.getParameters(featureCall.getFeatureCallParameters());
        }
        return parameters;
    }

    public static String getParametersAsString(AFeatureCall featureCall) {
        return ConcreteSyntaxUtils.getParametersAsString(featureCall.getFeatureCallParameters());
    }

    public static String getParametersAsString(PFeatureCallParameters featureCallParameters) {
        return StringUtils.join(ConcreteSyntaxUtils.getParameters(featureCallParameters).iterator(), (String)",");
    }

    private static List getParameters(PFeatureCallParameters callParameters) {
        PActualParameterList parameterList;
        ArrayList<String> parameters = new ArrayList<String>();
        if (callParameters != null && (parameterList = ((AFeatureCallParameters)callParameters).getActualParameterList()) != null) {
            LinkedList restOfParams;
            AActualParameterList params = (AActualParameterList)parameterList;
            String firstParam = TranslationUtils.trimToEmpty((Object)params.getExpression());
            if (StringUtils.isNotEmpty((String)firstParam)) {
                parameters.add(firstParam);
            }
            if ((restOfParams = params.getCommaExpression()) != null && !restOfParams.isEmpty()) {
                Iterator paramIt = restOfParams.iterator();
                while (paramIt.hasNext()) {
                    ACommaExpression parameterListTail = (ACommaExpression)paramIt.next();
                    parameters.add(TranslationUtils.trimToEmpty((Object)parameterListTail.getExpression()));
                }
            }
        }
        return parameters;
    }

    public static String[] getLeftAndRightExpressions(PRelationalExpression relationalExpression) {
        String[] expressions = new String[2];
        ARelationalExpression expression = (ARelationalExpression)relationalExpression;
        expressions[0] = TranslationUtils.trimToEmpty((Object)expression.getAdditiveExpression());
        ARelationalExpressionTail expressionTail = (ARelationalExpressionTail)expression.getRelationalExpressionTail();
        expressions[1] = TranslationUtils.trimToEmpty((Object)expressionTail.getAdditiveExpression());
        return expressions;
    }

    public static String getType(TName name, List pathNameTail) {
        StringBuffer type = ConcreteSyntaxUtils.concatContents(pathNameTail);
        type.insert(0, TranslationUtils.trimToEmpty((Object)name));
        return StringUtils.deleteWhitespace((String)type.toString());
    }

    public static String getPrimaryExpression(APropertyCallExpression expression) {
        StringBuffer primaryExpression = new StringBuffer();
        if (expression != null) {
            primaryExpression.append(TranslationUtils.trimToEmpty((Object)expression.getPrimaryExpression()));
            LinkedList expressionTail = expression.getPropertyCallExpressionTail();
            if (expressionTail.size() > 0) {
                String tail;
                Iterator expressionTailIt = expressionTail.iterator();
                while (expressionTailIt.hasNext() && (tail = TranslationUtils.trimToEmpty(expressionTailIt.next())).indexOf(ARROW_FEATURE_CALL) == -1) {
                    if (tail.indexOf(40) != -1) continue;
                    primaryExpression.append(tail);
                }
            }
        }
        return StringUtils.deleteWhitespace((String)primaryExpression.toString());
    }

    public static List getFeatureCalls(APropertyCallExpression expression) {
        LinkedList tails;
        String methodName = "ConcreteSyntaxUtils.getFeatureCalls";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("performing ConcreteSyntaxUtils.getFeatureCalls with expression --> '" + expression + "'"));
        }
        ArrayList<Object> featureCalls = new ArrayList<Object>();
        if (expression != null && (tails = expression.getPropertyCallExpressionTail()) != null && !tails.isEmpty()) {
            for (int ctr = 0; ctr < tails.size(); ++ctr) {
                featureCalls.add(TranslationUtils.getProperty(tails.get(ctr), (String)"featureCall"));
            }
        }
        return featureCalls;
    }

    public static String getArrowFeatureCallResultNavigationalPath(APropertyCallExpression expression) {
        List featureCalls;
        int size;
        StringBuffer path = new StringBuffer();
        if (OCLPatterns.isCollectionOperationResultNavigationalPath(expression) && (size = (featureCalls = ConcreteSyntaxUtils.getFeatureCalls(expression)).size()) > 1) {
            String featureCall;
            for (int ctr = 1; ctr < size && (featureCall = TranslationUtils.trimToEmpty(featureCalls.get(ctr))).indexOf(ARROW_FEATURE_CALL) == -1 && featureCall.indexOf(40) == -1; ++ctr) {
                path.append(featureCall);
                if (ctr == size - 1) continue;
                path.append('.');
            }
        }
        return path.toString();
    }

    public static List getArgumentNames(VariableDeclaration[] variableDeclarations) {
        ArrayList<String> names = new ArrayList<String>();
        for (int ctr = 0; ctr < variableDeclarations.length; ++ctr) {
            names.add(variableDeclarations[ctr].getName());
        }
        return names;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

