/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCatchesUIHandler
extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
implements TabHandler {
    public static final String MAIN_CARD = "main";
    public static final String CREATE_BATCH_CARD = "createBatch";
    public static final String SPLIT_BATCH_CARD = "splitBatch";
    public static final String EDIT_FREQUENCY_CARD = "editFrequency";
    public static final String EDIT_CARACTERISTICS_CARD = "caracteristicsCard";
    public static final String CAROUSSEL_TREMIE_VESSEL = "carousselTremieVessel";
    public static final String CLASSIC_VESSEL = "classicVessel";
    private static final Log log = LogFactory.getLog(EditCatchesUIHandler.class);
    private final TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;
    protected final FishingOperationsUI parentUi;

    public EditCatchesUIHandler(FishingOperationsUI parentUi, EditCatchesUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.parentUi = parentUi;
        this.catchBatchMonitor = new TuttiBeanMonitor("marineLitterTotalWeight", "speciesTotalSortedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "benthosTotalSortedWeight", "benthosTotalInertWeight", "benthosTotalLivingNotItemizedWeight");
    }

    @Override
    public void beforeInitUI() {
        EditCatchesUIModel model = ((EditCatchesUI)this.ui).getContextValue(EditCatchesUIModel.class);
        this.listModelIsModify(model);
        this.catchBatchMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), model);
        this.setCustomTab(0, model);
        this.setCustomTab(1, ((EditCatchesUI)this.ui).getSpeciesTabContent().getModel());
        this.setCustomTab(2, ((EditCatchesUI)this.ui).getBenthosTabContent().getModel());
        this.setCustomTab(3, ((EditCatchesUI)this.ui).getMarineLitterTabContent().getModel());
        this.setCustomTab(4, ((EditCatchesUI)this.ui).getIndividualObservationTabContent().getModel());
        this.setCustomTab(5, ((EditCatchesUI)this.ui).getAccidentalTabContent().getModel());
        this.getTabPanel().setSelectedIndex(1);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((EditCatchesUI)this.getUI()).getCatchTotalWeightField();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        this.closeUI(((EditCatchesUI)this.ui).getSpeciesTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getBenthosTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getMarineLitterTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getAccidentalTabContent());
    }

    @Override
    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ((EditCatchesUI)this.ui).getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet((Object[])new String[]{"catchTotalComputedWeight", "catchTotalSortedComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInertComputedWeight", "speciesTotalLivingNotItemizedComputedWeight", "benthosTotalComputedWeight", "benthosTotalSortedComputedWeight", "benthosTotalUnsortedComputedWeight", "benthosTotalSampleSortedComputedWeight", "benthosTotalInertComputedWeight", "benthosTotalLivingNotItemizedComputedWeight", "attachment", "batchUpdated"}));
        return result;
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return ((EditCatchesUI)this.ui).getTabPane();
    }

    @Override
    protected boolean onTabChanged(int currentIndex, int newIndex) {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getComputeSpeciesBatchButton().setVisible(newIndex < 4);
        return super.onTabChanged(currentIndex, newIndex);
    }

    @Override
    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        if (model.isModify()) {
            if (model.isValid()) {
                int answer = this.askSaveBeforeLeaving(I18n._((String)"tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        TuttiActionHelper.runAction(((EditCatchesUI)this.getUI()).getSaveButton());
                        result = true;
                        break;
                    }
                    case 1: {
                        TuttiActionHelper.runAction(((EditCatchesUI)this.getUI()).getCancelButton());
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                result = this.askCancelEditBeforeLeaving(I18n._((String)"tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]));
                if (result) {
                    TuttiActionHelper.runAction(((EditCatchesUI)this.ui).getCancelButton());
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators();
    }

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return this.catchBatchMonitor;
    }

    public FishingOperationsUI getParentUi() {
        return this.parentUi;
    }

    public FishingOperationsUIHandler getParentHandler() {
        return this.getParentUi().getHandler();
    }

    protected void registerValidators() {
        this.registerValidators(this.getValidator(), ((EditCatchesUI)this.ui).getSpeciesTabContent().getHandler().getValidator(), ((EditCatchesUI)this.ui).getBenthosTabContent().getHandler().getValidator(), ((EditCatchesUI)this.ui).getMarineLitterTabContent().getHandler().getValidator());
    }

    public void editSpeciesFrequencies(SpeciesFrequencyCellComponent.FrequencyCellEditor editor) {
        SpeciesFrequencyUI frequencyEditor = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
        frequencyEditor.getHandler().editBatch(editor);
        this.setSpeciesSelectedCard(EDIT_FREQUENCY_CARD);
        SpeciesBatchRowModel editRow = editor.getEditRow();
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle(), I18n._((String)"tutti.editSpeciesFrequencies.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditorReminderLabel().setTitle(title);
    }

    public void splitSpeciesBatch(SpeciesBatchRowModel editRow, SplitSpeciesBatchUI splitBatchEditor) {
        splitBatchEditor.getHandler().editBatch(editRow);
        this.setSpeciesSelectedCard(SPLIT_BATCH_CARD);
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle(), I18n._((String)"tutti.splitSpeciesBatch.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getSpeciesTabSplitBatchReminderLabel().setTitle(title);
    }

    public void setSpeciesSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getSpeciesTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatchReminderLabel();
                    title = I18n.n_((String)"tutti.createSpeciesBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabSplitBatch();
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
                }
                if (tuttiUi != null) {
                    this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void editBenthosFrequencies(BenthosFrequencyCellComponent.FrequencyCellEditor editor) {
        BenthosFrequencyUI frequencyEditor = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor();
        frequencyEditor.getHandler().editBatch(editor);
        this.setBenthosSelectedCard(EDIT_FREQUENCY_CARD);
        BenthosBatchRowModel editRow = editor.getEditRow();
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle(), I18n._((String)"tutti.editBenthosFrequencies.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditorReminderLabel().setTitle(title);
    }

    public void splitBenthosBatch(BenthosBatchRowModel editRow, SplitBenthosBatchUI splitBatchEditor) {
        splitBatchEditor.getHandler().editBatch(editRow);
        this.setBenthosSelectedCard(SPLIT_BATCH_CARD);
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle(), I18n._((String)"tutti.splitBenthosBatch.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getBenthosTabSplitBatchReminderLabel().setTitle(title);
    }

    public void setBenthosSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getBenthosTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getBenthosTabCreateBatchReminderLabel();
                    title = I18n.n_((String)"tutti.createBenthosBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabSplitBatch();
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor();
                }
                if (tuttiUi != null) {
                    this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void setMarineLitterSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getMarineLitterTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateMarineLitterBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getMarineLitterTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel();
                    title = I18n.n_((String)"tutti.createMarineLitterBatch.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void setIndividualObservationSelectedCard(String card) {
        this.setIndividualObservationSelectedCard(card, null);
    }

    public void setIndividualObservationSelectedCard(String card, Species species) {
        JPanel panel = ((EditCatchesUI)this.ui).getIndividualObservationTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateIndividualObservationBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getIndividualObservationTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getIndividualObservationTabCreateBatchReminderLabel();
                    title = I18n.n_((String)"tutti.createIndividualObservationBatch.title", (Object[])new Object[0]);
                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ((EditCatchesUI)this.ui).getIndividualObservationCaracteristicMapEditorReminderLabel();
                    title = I18n.n_((String)"tutti.editCaracteristics.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getIndividualObservationTabFishingOperationReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[]{this.decorate(species)}));
                }
            }
        }
    }

    public void setAccidentalSelectedCard(String card) {
        this.setAccidentalSelectedCard(card, null);
    }

    public void setAccidentalSelectedCard(String card, Species species) {
        JPanel panel = ((EditCatchesUI)this.ui).getAccidentalTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateAccidentalBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getAccidentalTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalTabCreateBatchReminderLabel();
                    title = I18n.n_((String)"tutti.createAccidentalBatch.title", (Object[])new Object[0]);
                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalCaracteristicMapEditorReminderLabel();
                    title = I18n.n_((String)"tutti.editCaracteristics.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getAccidentalTabFishingOperationReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[]{this.decorate(species)}));
                }
            }
        }
    }

    protected String buildReminderLabelTitle(Species species, Iterable<SampleCategory<?>> categories, String prefix, String suffix) {
        StringBuilder title = new StringBuilder(prefix);
        title.append(" - [").append(this.decorate(species)).append("]");
        for (SampleCategory<?> sampleCategory : categories) {
            if (sampleCategory.getCategoryValue() == null) continue;
            title.append(" - ");
            title.append(this.decorate(sampleCategory.getCategoryValue()));
        }
        title.append(" - ").append(suffix);
        return title.toString();
    }
}

