/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CloseDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(CloseDbAction.class);
    protected String jdbcUrl;

    public CloseDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {
            this.jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
        }
        return canContinue;
    }

    @Override
    public void doAction() {
        this.getContext().getPersistenceService().clearAllCaches();
        this.getContext().setDbLoaded(false);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        this.getContext().clearDbContext();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.flash.info.db.closed", (Object[])new Object[]{this.jdbcUrl}));
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }
}

