/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import java.io.Serializable;
import java.util.Date;

public class OperationExportRow
implements Serializable {
    public static final String PROPERTY_DURATION = "duration";
    public static final String PROPERTY_VERTICAL_OPENING_GEAR_USE_FEATURE = "verticalOpeningGearUseFeature";
    public static final String PROPERTY_HORIZONTAL_OPENING_WING_GEAR_USE_FEATURE = "horizontalOpeningWingGearUseFeature";
    public static final String PROPERTY_HORIZONTAL_OPENING_DOOR_GEAR_USE_FEATURE = "horizontalOpeningDoorGearUseFeature";
    private static final long serialVersionUID = 1L;
    protected Cruise cruise;
    protected FishingOperation fishingOperation;
    private Caracteristic verticalOpeningCaracteristic;
    private Caracteristic horizontalOpeningWingCaracteristic;
    private Caracteristic horizontalOpeningDoorCaracteristic;

    public OperationExportRow(Caracteristic verticalOpeningCaracteristic, Caracteristic horizontalOpeningWingCaracteristic, Caracteristic horizontalOpeningDoorCaracteristic) {
        this.verticalOpeningCaracteristic = verticalOpeningCaracteristic;
        this.horizontalOpeningWingCaracteristic = horizontalOpeningWingCaracteristic;
        this.horizontalOpeningDoorCaracteristic = horizontalOpeningDoorCaracteristic;
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public Date getBeginDate() {
        return this.cruise.getBeginDate();
    }

    public Program getProgram() {
        return this.cruise.getProgram();
    }

    public String getSurveyPart() {
        return this.cruise.getSurveyPart();
    }

    public String getStationNumber() {
        return this.fishingOperation.getStationNumber();
    }

    public Integer getFishingOperationNumber() {
        return this.fishingOperation.getFishingOperationNumber();
    }

    public Gear getGear() {
        return this.fishingOperation.getGear();
    }

    public Vessel getVessel() {
        return this.fishingOperation.getVessel();
    }

    public Date getGearShootingStartDate() {
        return this.fishingOperation.getGearShootingStartDate();
    }

    public Float getGearShootingStartLatitude() {
        return this.fishingOperation.getGearShootingStartLatitude();
    }

    public Float getGearShootingStartLongitude() {
        return this.fishingOperation.getGearShootingStartLongitude();
    }

    public Date getGearShootingEndDate() {
        return this.fishingOperation.getGearShootingEndDate();
    }

    public Float getGearShootingEndLatitude() {
        return this.fishingOperation.getGearShootingEndLatitude();
    }

    public Float getGearShootingEndLongitude() {
        return this.fishingOperation.getGearShootingEndLongitude();
    }

    public TuttiLocation getStrata() {
        return this.fishingOperation.getStrata();
    }

    public TuttiLocation getSubStrata() {
        return this.fishingOperation.getSubStrata();
    }

    public TuttiLocation getLocation() {
        return this.fishingOperation.getLocation();
    }

    public Boolean getFishingOperationValid() {
        return this.fishingOperation.getFishingOperationValid();
    }

    public boolean isFishingOperationRectiligne() {
        return this.fishingOperation.isFishingOperationRectiligne();
    }

    public Float getTrawlDistance() {
        return this.fishingOperation.getTrawlDistance();
    }

    public String getComment() {
        return this.fishingOperation.getComment();
    }

    public String getDuration() {
        return TuttiEntities.getDuration((Date)this.getGearShootingStartDate(), (Date)this.getGearShootingEndDate(), (String)"mm");
    }

    public Serializable getVerticalOpeningGearUseFeature() {
        Serializable result = this.getGearUseFeature(this.verticalOpeningCaracteristic);
        return result;
    }

    public Serializable getHorizontalOpeningWingGearUseFeature() {
        Serializable result = this.getGearUseFeature(this.horizontalOpeningWingCaracteristic);
        return result;
    }

    public Serializable getHorizontalOpeningDoorGearUseFeature() {
        Serializable result = this.getGearUseFeature(this.horizontalOpeningDoorCaracteristic);
        return result;
    }

    protected Serializable getGearUseFeature(Caracteristic caracteristic) {
        CaracteristicMap gearUseFeatures = this.fishingOperation.getGearUseFeatures();
        Serializable serializable = gearUseFeatures == null ? null : (Serializable)gearUseFeatures.get((Object)caracteristic);
        return serializable;
    }
}

