/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.JHelpPrintHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Locale;
import javax.help.AbstractHelpAction;
import javax.help.HelpUtilities;
import javax.help.JHelp;
import javax.help.TreeItem;
import javax.swing.UIManager;

public class PrintAction
extends AbstractHelpAction
implements PropertyChangeListener,
ActionListener {
    private static final String NAME = "PrintAction";
    private JHelpPrintHandler handler = null;

    public PrintAction(Object object) {
        super(object, NAME);
        if (object instanceof JHelp) {
            JHelp jHelp = (JHelp)object;
            this.handler = JHelpPrintHandler.getJHelpPrintHandler(jHelp);
            this.handler.addPropertyChangeListener(this);
            Locale locale = null;
            try {
                locale = jHelp.getModel().getHelpSet().getLocale();
            }
            catch (NullPointerException nullPointerException) {
                locale = Locale.getDefault();
            }
            this.putValue("tooltip", HelpUtilities.getString(locale, "tooltip.PrintAction"));
            this.putValue("access", HelpUtilities.getString(locale, "access.PrintAction"));
        }
        this.putValue("icon", UIManager.getIcon("PrintAction.icon"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.handler != null) {
            JHelp jHelp = (JHelp)this.getControl();
            URL[] uRLArray = null;
            TreeItem[] treeItemArray = jHelp.getSelectedItems();
            if (treeItemArray != null) {
                uRLArray = new URL[treeItemArray.length];
                for (int i = 0; i < treeItemArray.length; ++i) {
                    uRLArray[i] = treeItemArray[i].getURL();
                }
            }
            if (uRLArray != null && uRLArray.length > 0) {
                this.handler.print(uRLArray);
            } else {
                this.handler.print(jHelp.getModel().getCurrentURL());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        }
    }
}

