/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorNot
extends SpelNodeImpl {
    public OperatorNot(int pos, SpelNodeImpl operand) {
        super(pos, operand);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        try {
            TypedValue typedValue = this.children[0].getValueInternal(state);
            if (TypedValue.NULL.equals(typedValue)) {
                throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
            }
            boolean value = (Boolean)state.convertValue(typedValue, TypeDescriptor.valueOf(Boolean.class));
            return BooleanTypedValue.forValue(!value);
        }
        catch (SpelEvaluationException see) {
            see.setPosition(this.getChild(0).getStartPosition());
            throw see;
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("!").append(this.getChild(0).toStringAST());
        return sb.toString();
    }
}

