/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.protocol;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.nuiton.i18n.I18n;

public class TuttiProtocols {
    public static void toFile(TuttiProtocol protocol, File file) {
        String id = protocol.getId();
        BufferedWriter fileWriter = null;
        try {
            fileWriter = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            YamlWriter writer = new YamlWriter((Writer)fileWriter, TuttiProtocols.createConfig());
            writer.write((Object)protocol);
            writer.close();
            fileWriter.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.persistence.protocol.fromFile.error", (Object[])new Object[]{id, file}), e);
        }
        finally {
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    public static TuttiProtocol fromFile(File file) {
        BufferedReader fileReader = null;
        try {
            fileReader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
            YamlReader reader = new YamlReader((Reader)fileReader, TuttiProtocols.createConfig());
            TuttiProtocol result = (TuttiProtocol)reader.read(TuttiBeanFactory.typeOfTuttiProtocol());
            ((Reader)fileReader).close();
            TuttiProtocol tuttiProtocol = result;
            return tuttiProtocol;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.persistence.protocol.fromFile.error", (Object[])new Object[]{file}), e);
        }
        finally {
            IOUtils.closeQuietly((Reader)fileReader);
        }
    }

    protected static YamlConfig createConfig() {
        YamlConfig result = new YamlConfig();
        result.setClassTag(SpeciesProtocol.class.getSimpleName(), TuttiBeanFactory.typeOfSpeciesProtocol());
        result.writeConfig.setAlwaysWriteClassname(false);
        result.writeConfig.setWriteRootTags(false);
        return result;
    }

    public static boolean isSpeciesBatchValid(TuttiProtocol protocol, SpeciesBatch batch, List<SpeciesBatchFrequency> frequencies) {
        List<SpeciesProtocol> speciesProtocols;
        Species species;
        SpeciesProtocol speciesProtocol;
        boolean result = true;
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesProtocol(species = batch.getSpecies(), speciesProtocols = protocol.getSpecies())) != null) {
            List<SampleCategoryEnum> mandatoryCategories = TuttiProtocols.getMandatoryCategories(speciesProtocol);
            SpeciesBatch browsingBatch = batch;
            while (browsingBatch.getParentBatch() != null) {
                mandatoryCategories.remove(browsingBatch.getSampleCategoryType());
                browsingBatch = browsingBatch.getParentBatch();
            }
            result = mandatoryCategories.isEmpty() && (!speciesProtocol.isCountIfNoFrequencyEnabled() || CollectionUtils.isNotEmpty(frequencies) || batch.getNumber() != null);
        }
        return result;
    }

    public static boolean isBenthosBatchValid(TuttiProtocol protocol, BenthosBatch batch, List<BenthosBatchFrequency> frequencies) {
        List<SpeciesProtocol> speciesProtocols;
        Species species;
        SpeciesProtocol speciesProtocol;
        boolean result = true;
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesProtocol(species = batch.getSpecies(), speciesProtocols = protocol.getBenthos())) != null) {
            List<SampleCategoryEnum> mandatoryCategories = TuttiProtocols.getMandatoryCategories(speciesProtocol);
            BenthosBatch browsingBatch = batch;
            while (browsingBatch.getParentBatch() != null) {
                mandatoryCategories.remove(browsingBatch.getSampleCategoryType());
                browsingBatch = browsingBatch.getParentBatch();
            }
            result = mandatoryCategories.isEmpty() && (!speciesProtocol.isCountIfNoFrequencyEnabled() || CollectionUtils.isNotEmpty(frequencies) || batch.getNumber() != null);
        }
        return result;
    }

    protected static SpeciesProtocol getSpeciesProtocol(Species species, List<SpeciesProtocol> speciesProtocols) {
        for (SpeciesProtocol speciesProtocol : speciesProtocols) {
            if (!species.getReferenceTaxonId().equals(speciesProtocol.getSpeciesReferenceTaxonId())) continue;
            return speciesProtocol;
        }
        return null;
    }

    protected static List<SampleCategoryEnum> getMandatoryCategories(SpeciesProtocol speciesProtocol) {
        ArrayList mandatoryCategories = Lists.newArrayList();
        if (speciesProtocol.isSizeEnabled()) {
            mandatoryCategories.add(SampleCategoryEnum.size);
        }
        if (speciesProtocol.isSexEnabled()) {
            mandatoryCategories.add(SampleCategoryEnum.sex);
        }
        if (speciesProtocol.isMaturityEnabled()) {
            mandatoryCategories.add(SampleCategoryEnum.maturity);
        }
        if (speciesProtocol.isAgeEnabled()) {
            mandatoryCategories.add(SampleCategoryEnum.age);
        }
        return mandatoryCategories;
    }
}

