/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.profile;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.namespace.BaseNamespaceComponent;
import org.andromda.core.profile.ProfileException;

public class Profile
extends BaseNamespaceComponent {
    private static Profile instance;
    private final Map elements = new LinkedHashMap();
    private final Map allElements = new LinkedHashMap();
    static /* synthetic */ Class class$org$andromda$core$profile$Profile;

    public static Profile instance() {
        if (instance == null) {
            instance = new Profile();
        }
        return instance;
    }

    public void addElement(String name, String value) {
        this.elements.put(name, value);
    }

    public String get(String name) {
        String value = (String)this.elements.get(name = name != null ? name.trim() : null);
        if (value == null || value.trim().length() == 0) {
            Map namespaceElements = this.getNamespaceElements(this.getNamespace());
            if (namespaceElements != null) {
                value = (String)namespaceElements.get(name);
            }
            if (value == null && (namespaceElements = this.getNamespaceElements("default")) != null) {
                value = (String)namespaceElements.get(name);
            }
        }
        return value != null ? value : name;
    }

    public void initialize() {
        Collection profiles = ComponentContainer.instance().findComponentsOfType(class$org$andromda$core$profile$Profile == null ? (class$org$andromda$core$profile$Profile = Profile.class$("org.andromda.core.profile.Profile")) : class$org$andromda$core$profile$Profile);
        Iterator iterator = profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            String namespace = profile.getNamespace();
            if (Namespaces.instance().isShared(namespace)) {
                profile.setNamespace("default");
            }
            this.addElements(profile);
        }
    }

    public void refresh() {
        this.elements.clear();
        try {
            String mappingsUriValue;
            Property mappingsUri = Namespaces.instance().getProperty("default", "profileMappingsUri", false);
            String string = mappingsUriValue = mappingsUri != null ? mappingsUri.getValue() : null;
            if (mappingsUriValue != null) {
                XmlObjectFactory factory = XmlObjectFactory.getInstance(class$org$andromda$core$profile$Profile == null ? (class$org$andromda$core$profile$Profile = Profile.class$("org.andromda.core.profile.Profile")) : class$org$andromda$core$profile$Profile);
                Profile profile = (Profile)factory.getObject(new URL(mappingsUriValue.trim()));
                this.elements.putAll(profile.elements);
            }
        }
        catch (Throwable throwable) {
            throw new ProfileException(throwable);
        }
    }

    private void addElements(Profile profile) {
        Set elements;
        Set set = elements = profile != null ? profile.elements.keySet() : null;
        if (elements != null) {
            String namespace = profile.getNamespace();
            Map namespaceElements = this.getNamespaceElements(namespace);
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                namespaceElements.put(name, profile.elements.get(name));
            }
        }
    }

    public void addElement(String namespace, String name, String value) {
        Map namespaceElements = this.getNamespaceElements(namespace);
        namespaceElements.put(name, value);
    }

    private Map getNamespaceElements(String namespace) {
        LinkedHashMap namespaceElements = (LinkedHashMap)this.allElements.get(namespace);
        if (namespaceElements == null) {
            namespaceElements = new LinkedHashMap();
            this.allElements.put(namespace, namespaceElements);
        }
        return namespaceElements;
    }

    public void shutdown() {
        instance = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

