/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.andromda.core.common.ClassUtilsException;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    public static final String CLASS_EXTENSION = ".class";
    static /* synthetic */ Class class$org$andromda$core$common$ClassUtils;

    public static Object newInstance(String className) {
        try {
            return ClassUtils.loadClass(className).newInstance();
        }
        catch (Throwable throwable) {
            throw new ClassUtilsException(throwable);
        }
    }

    public static Object newInstance(Class type) {
        try {
            return type != null ? type.newInstance() : null;
        }
        catch (Throwable throwable) {
            throw new ClassUtilsException(throwable);
        }
    }

    public static Class loadClass(String className) {
        Class<?> loadedClass;
        ExceptionUtils.checkEmpty("className", className);
        className = StringUtils.trimToNull((String)className);
        className = StringUtils.replace((String)className, (String)"[]", (String)"");
        ClassLoader loader = ClassUtils.getClassLoader();
        try {
            loadedClass = ClassUtils.isPrimitiveType(className) ? ClassUtils.getPrimitiveClass(className, loader) : loader.loadClass(className);
        }
        catch (Throwable throwable) {
            throw new ClassUtilsException(throwable);
        }
        return loadedClass;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = (class$org$andromda$core$common$ClassUtils == null ? (class$org$andromda$core$common$ClassUtils = ClassUtils.class$("org.andromda.core.common.ClassUtils")) : class$org$andromda$core$common$ClassUtils).getClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
        }
        return loader;
    }

    protected static Class getPrimitiveClass(String name, ClassLoader loader) {
        ExceptionUtils.checkEmpty("name", name);
        ExceptionUtils.checkNull("loader", loader);
        Class primitiveClass = null;
        if (ClassUtils.isPrimitiveType(name) && !name.equals("void")) {
            String className = "char".equals(name) ? "java.lang.Character" : ("int".equals(name) ? "java.lang.Integer" : "java.lang." + StringUtils.capitalize((String)name));
            try {
                if (StringUtils.isNotEmpty((String)className)) {
                    Field field = loader.loadClass(className).getField("TYPE");
                    primitiveClass = (Class)field.get(null);
                }
            }
            catch (Exception exception) {
                throw new ClassUtilsException(exception);
            }
        }
        return primitiveClass;
    }

    public static Collection getStaticFieldValues(Class clazz, Class type) throws IllegalAccessException {
        ExceptionUtils.checkNull("clazz", clazz);
        Field[] fields = clazz.getFields();
        int fieldsNum = fields.length;
        ArrayList<Object> values = new ArrayList<Object>();
        for (int ctr = 0; ctr < fieldsNum; ++ctr) {
            Field field = fields[ctr];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            if (type != null) {
                if (type != field.getType()) continue;
                values.add(fields[ctr].get(null));
                continue;
            }
            values.add(fields[ctr].get(null));
        }
        return values;
    }

    public static List getInterfaces(String className) {
        ArrayList interfaces = new ArrayList();
        if (className != null && className.trim().length() > 0) {
            interfaces.addAll(ClassUtils.getInterfaces(ClassUtils.loadClass(className.trim())));
        }
        return interfaces;
    }

    public static List getInterfaces(Class clazz) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        if (clazz != null) {
            interfaces.addAll(org.apache.commons.lang.ClassUtils.getAllInterfaces((Class)clazz));
            if (clazz.isInterface()) {
                interfaces.add(0, clazz);
            }
        }
        return interfaces;
    }

    public static Class[] getInterfacesReversed(String className) {
        Object[] interfaces = ClassUtils.getInterfaces(className).toArray(new Class[0]);
        if (interfaces != null && interfaces.length > 0) {
            CollectionUtils.reverseArray((Object[])interfaces);
        }
        return interfaces;
    }

    protected static boolean isPrimitiveType(String name) {
        return "void".equals(name) || "char".equals(name) || "byte".equals(name) || "short".equals(name) || "int".equals(name) || "long".equals(name) || "float".equals(name) || "double".equals(name) || "boolean".equals(name);
    }

    public static Class findClassOfType(URL[] directoryUris, Class type) {
        Class<?> found = null;
        if (directoryUris != null && directoryUris.length > 0) {
            int numberOfDirectoryUris = directoryUris.length;
            block2: for (int ctr = 0; ctr < numberOfDirectoryUris; ++ctr) {
                URL directoryUri = directoryUris[ctr];
                List contents = ResourceUtils.getDirectoryContents(directoryUri, false, null);
                Iterator iterator = contents.iterator();
                while (iterator.hasNext()) {
                    String path = (String)iterator.next();
                    if (!path.endsWith(CLASS_EXTENSION)) continue;
                    String typeName = StringUtils.replace((String)ResourceUtils.normalizePath(path).replace('/', '.'), (String)CLASS_EXTENSION, (String)"");
                    try {
                        Class<?> loadedClass = ClassUtils.getClassLoader().loadClass(typeName);
                        if (!type.isAssignableFrom(loadedClass)) continue;
                        found = loadedClass;
                        continue block2;
                    }
                    catch (ClassNotFoundException exception) {
                    }
                }
            }
        }
        return found;
    }

    public static List getAllMethods(Class clazz) {
        LinkedHashSet methods = new LinkedHashSet();
        ClassUtils.loadMethods(clazz, methods);
        return new ArrayList(methods);
    }

    private static void loadMethods(Class clazz, Set methods) {
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (clazz.getSuperclass() != null) {
            ClassUtils.loadMethods(clazz.getSuperclass(), methods);
        }
    }

    public static boolean isClassOfTypePresent(URL[] directoryUris, Class type) {
        return ClassUtils.findClassOfType(directoryUris, type) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

