/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.Validator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.xwork2.XWork2ScopeValidator;

public class XWork2ValidatorUtil {
    private static final Log log = LogFactory.getLog(XWork2ValidatorUtil.class);
    private static ValueStack sharedValueStack;

    public static ValueStack getSharedValueStack() {
        if (sharedValueStack == null) {
            sharedValueStack = XWork2ValidatorUtil.createValuestack();
            if (log.isDebugEnabled()) {
                log.debug((Object)("init shared value stack " + sharedValueStack));
            }
        }
        return sharedValueStack;
    }

    public static ValueStack createValuestack() {
        ConfigurationManager confManager = new ConfigurationManager();
        Configuration conf = confManager.getConfiguration();
        Container container = conf.getContainer();
        ValueStackFactory stackFactory = (ValueStackFactory)container.getInstance(ValueStackFactory.class);
        ValueStack vs = stackFactory.createValueStack();
        return vs;
    }

    public static <O> XWork2ScopeValidator<O> newXWorkScopeValidator(Class<O> beanClass, String contextName, Set<String> fields) {
        return XWork2ValidatorUtil.newXWorkScopeValidator(beanClass, contextName, fields, XWork2ValidatorUtil.getSharedValueStack());
    }

    public static <O> XWork2ScopeValidator<O> newXWorkScopeValidator(Class<O> beanClass, String contextName, Set<String> fields, ValueStack vs) {
        return new XWork2ScopeValidator<O>(beanClass, contextName, fields, vs);
    }

    public static String getContextForScope(String context, NuitonValidatorScope scope) {
        return (context == null ? "" : context + "-") + scope.name().toLowerCase();
    }

    protected static ActionValidatorManager newValidationManager(ValueStack vs) {
        if (vs == null) {
            vs = XWork2ValidatorUtil.createValuestack();
            if (log.isDebugEnabled()) {
                log.debug((Object)("create a standalone value stack " + vs));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("use given value stack " + vs));
        }
        ActionContext context = new ActionContext(vs.getContext());
        ActionContext.setContext((ActionContext)context);
        Container container = context.getContainer();
        ActionValidatorManager validatorManager = (ActionValidatorManager)container.getInstance(ActionValidatorManager.class, "no-annotations");
        return validatorManager;
    }

    public static <O> Map<NuitonValidatorScope, String[]> detectFields(Class<O> type, String context, NuitonValidatorScope[] scopeUniverse) {
        Set availableFields = BeanUtil.getReadableProperties(type);
        ActionValidatorManager validatorManager = XWork2ValidatorUtil.newValidationManager(null);
        TreeMap<NuitonValidatorScope, String[]> fields = new TreeMap<NuitonValidatorScope, String[]>();
        for (NuitonValidatorScope scope : scopeUniverse) {
            Set<String> fieldNames = XWork2ValidatorUtil.detectFieldsForScope(validatorManager, type, scope, context, availableFields, false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected validator fields for scope " + (Object)((Object)scope) + ":" + context + " : " + fieldNames));
            }
            if (fieldNames.isEmpty()) continue;
            fields.put(scope, fieldNames.toArray(new String[fieldNames.size()]));
        }
        return fields;
    }

    protected static Set<String> detectFieldsForScope(ActionValidatorManager validator, Class<?> type, NuitonValidatorScope scope, String context, Set<String> availableFields, boolean includeDefaultContext) {
        String scopeContext = XWork2ValidatorUtil.getContextForScope(context, scope);
        HashSet<String> fields = new HashSet<String>();
        int skip = 0;
        if (scopeContext != null && !includeDefaultContext) {
            for (Validator v : validator.getValidators(type, null)) {
                if (!(v instanceof FieldValidator)) continue;
                ++skip;
            }
        }
        for (Validator v : validator.getValidators(type, scopeContext)) {
            String fName;
            if (!(v instanceof FieldValidator)) continue;
            if (skip > 0) {
                --skip;
                continue;
            }
            FieldValidator fieldValidator = (FieldValidator)v;
            if (log.isDebugEnabled()) {
                log.debug((Object)("context " + context + " - field " + fieldValidator.getFieldName()));
            }
            if (availableFields.contains(fName = fieldValidator.getFieldName())) {
                fields.add(fName);
                continue;
            }
            if (BeanUtil.isNestedReadableProperty(type, (String)fName)) {
                fields.add(fName);
                continue;
            }
            String message = "Field " + fName + " in scope [" + scopeContext + "] is not a readable property of " + type.getName();
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new IllegalStateException(message);
        }
        return fields;
    }
}

