/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.AbstractCharCollection;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.CharListIterator;

public abstract class RandomAccessCharList
extends AbstractCharCollection
implements CharList {
    private int _modCount = 0;

    protected RandomAccessCharList() {
    }

    public abstract char get(int var1);

    public abstract int size();

    public char removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    public char set(int index, char element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, char element) {
        throw new UnsupportedOperationException();
    }

    public boolean add(char element) {
        this.add(this.size(), element);
        return true;
    }

    public boolean addAll(int index, CharCollection collection) {
        boolean modified = false;
        CharIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            modified = true;
        }
        return modified;
    }

    public int indexOf(char element) {
        int i = 0;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(char element) {
        CharListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != element) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    public CharIterator iterator() {
        return this.listIterator();
    }

    public CharListIterator listIterator() {
        return this.listIterator(0);
    }

    public CharListIterator listIterator(int index) {
        return new RandomAccessCharListIterator(this, index);
    }

    public CharList subList(int fromIndex, int toIndex) {
        return new RandomAccessCharSubList(this, fromIndex, toIndex);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof CharList) {
            CharList thatList = (CharList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            CharIterator thatIter = thatList.iterator();
            CharIterator thisIter = this.iterator();
            while (thisIter.hasNext()) {
                if (thisIter.next() == thatIter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            hash = 31 * hash + iter.next();
        }
        return hash;
    }

    public String toString() {
        return new String(this.toArray());
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessCharSubList
    extends RandomAccessCharList
    implements CharList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessCharList _list = null;
        private ComodChecker _comod = null;

        RandomAccessCharSubList(RandomAccessCharList list, int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._offset = fromIndex;
            this._limit = toIndex - fromIndex;
            this._comod = new ComodChecker(list);
            this._comod.resyncModCount();
        }

        public char get(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(index));
        }

        public char removeElementAt(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            char val = this._list.removeElementAt(this.toUnderlyingIndex(index));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return val;
        }

        public char set(int index, char element) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            char val = this._list.set(this.toUnderlyingIndex(index), element);
            this.incrModCount();
            this._comod.resyncModCount();
            return val;
        }

        public void add(int index, char element) {
            this.checkRangeIncludingEndpoint(index);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(index), element);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int index) {
            return index + this._offset;
        }
    }

    protected static class RandomAccessCharListIterator
    extends ComodChecker
    implements CharListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessCharListIterator(RandomAccessCharList list, int index) {
            super(list);
            if (index < 0 || index > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + index + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = index;
            this.resyncModCount();
        }

        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        public char next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char val = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return val;
        }

        public char previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            char val = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return val;
        }

        public void add(char value) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, value);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        public void remove() {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().removeElementAt(this._lastReturnedIndex);
            this._lastReturnedIndex = -1;
            --this._nextIndex;
            this.resyncModCount();
        }

        public void set(char value) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, value);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessCharList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessCharList source) {
            this._source = source;
            this.resyncModCount();
        }

        protected RandomAccessCharList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

