package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TabContentModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collection;
import java.util.List;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class IndividualObservationBatchUIModel extends AbstractTuttiBatchUIModel<IndividualObservationBatchRowModel, IndividualObservationBatchUIModel>
        implements AttachmentModelAware, TabContentModel {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_REMOVE_BATCH_ENABLED = "removeBatchEnabled";

    protected final List<Attachment> attachment = Lists.newArrayList();

    /** Can user remove a selected batch? */
    protected boolean removeBatchEnabled;

    private String rootBatchId;

    public IndividualObservationBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel);
    }

    public boolean isRemoveBatchEnabled() {
        return removeBatchEnabled;
    }

    public void setRemoveBatchEnabled(boolean removeBatchEnabled) {
        Object oldValue = isRemoveBatchEnabled();
        this.removeBatchEnabled = removeBatchEnabled;
        firePropertyChange(PROPERTY_REMOVE_BATCH_ENABLED, oldValue, removeBatchEnabled);
    }

    public void setRootBatchId(String rootBatchId) {
        String oldValue = getObjectId();
        this.rootBatchId = rootBatchId;
        firePropertyChange(PROPERTY_OBJECT_ID, oldValue, getObjectId());
    }

    public String getRootBatchId() {
        return rootBatchId;
    }

    //------------------------------------------------------------------------//
    //-- AttachmentModelAware                                               --//
    //------------------------------------------------------------------------//

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.CATCH_BATCH;
    }

    @Override
    public String getObjectId() {
        return rootBatchId;
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    //------------------------------------------------------------------------//
    //-- TabContentModel                                                    --//
    //------------------------------------------------------------------------//

    @Override
    public boolean isEmpty() {
        boolean result = CollectionUtils.isEmpty(getAttachment());
        if (result && CollectionUtils.isNotEmpty(getRows())) {

            // check if every line is not valid
            for (IndividualObservationBatchRowModel row : rows) {
                if (row.isValid()) {

                    // found a valid row so not empty
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public String getTitle() {
        return "tutti.label.tab.individualObservations";
    }

    @Override
    public String getIcon() {
        return null;
    }
}
