package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCatchesUIModel.java 773 2013-04-13 20:09:01Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/EditCatchesUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TabContentModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditCatchesUIModel extends AbstractTuttiBeanUIModel<CatchBatch, EditCatchesUIModel> implements AttachmentModelAware, TabContentModel, CatchBatch {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CATCH_BATCH = "catchBatch";

    protected static final Binder<CatchBatch, EditCatchesUIModel> fromBeanBinder = BinderFactory.newBinder(CatchBatch.class, EditCatchesUIModel.class);

    protected static final Binder<EditCatchesUIModel, CatchBatch> toBeanBinder = BinderFactory.newBinder(EditCatchesUIModel.class, CatchBatch.class);

    protected Float speciesTotalComputedWeight;

    protected TuttiComputedOrNotData<Float> speciesTotalSortedComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected Float speciesTotalUnsortedComputedWeight;

    protected Float speciesTotalSampleSortedComputedWeight;

    protected TuttiComputedOrNotData<Float> speciesTotalInertComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected TuttiComputedOrNotData<Float> speciesTotalLivingNotItemizedComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected Float benthosTotalComputedWeight;

    protected TuttiComputedOrNotData<Float> benthosTotalSortedComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected Float benthosTotalUnsortedComputedWeight;

    protected Float benthosTotalSampleSortedComputedWeight;

    protected TuttiComputedOrNotData<Float> benthosTotalInertComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected TuttiComputedOrNotData<Float> benthosTotalLivingNotItemizedComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected Float planktonTotalWeight;

    protected Float planktonTotalSampleWeight;

    protected TuttiComputedOrNotData<Float> marineLitterTotalComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    ;

    protected TuttiComputedOrNotData<Float> catchTotalComputedOrNotWeight
            = new TuttiComputedOrNotData<Float>();

    protected Float catchTotalSortedComputedWeight;

    protected Float catchTotalUnsortedComputedWeight;

    protected Float catchTotalSortedTremisWeight;

    protected Float catchTotalSortedCarousselWeight;

    protected TuttiComputedOrNotData<Float> catchTotalRejectedComputedOrNotWeight
            = new TuttiComputedOrNotData<Float>();

    protected FishingOperation fishingOperation;

    protected CatchBatch catchBatch;

    protected final List<Attachment> attachment = Lists.newArrayList();

    /**
     * Species already used in some batches.
     *
     * @since 0.3
     */
    protected final Multimap<CaracteristicQualitativeValue, Species>
            speciesUsed = ArrayListMultimap.create();

    /**
     * Categories already used in some batches.
     *
     * @since 1.4
     */
    protected final Multimap<CaracteristicQualitativeValue, CaracteristicQualitativeValue>
            marineLitterCategoriesUsed = ArrayListMultimap.create();

    public EditCatchesUIModel() {
        super(CatchBatch.class, fromBeanBinder, toBeanBinder);
        speciesTotalSortedComputedOrNotWeight.addPropagateListener(
                PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT, this);
        speciesTotalInertComputedOrNotWeight.addPropagateListener(
                PROPERTY_SPECIES_TOTAL_INERT_WEIGHT, this);
        speciesTotalLivingNotItemizedComputedOrNotWeight.addPropagateListener(
                PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT, this);

        benthosTotalSortedComputedOrNotWeight.addPropagateListener(
                PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT, this);
        benthosTotalInertComputedOrNotWeight.addPropagateListener(
                PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT, this);
        benthosTotalLivingNotItemizedComputedOrNotWeight.addPropagateListener(
                PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT, this);

        marineLitterTotalComputedOrNotWeight.addPropagateListener(
                PROPERTY_MARINE_LITTER_TOTAL_WEIGHT, this);

        catchTotalComputedOrNotWeight.addPropagateListener(
                PROPERTY_CATCH_TOTAL_WEIGHT, this);
        catchTotalRejectedComputedOrNotWeight.addPropagateListener(
                PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT, this);
    }

    @Override
    public String getTitle() {
        return _("tutti.label.tab.catchesCaracteristics");
    }

    @Override
    protected CatchBatch newEntity() {
        return catchBatch;
    }

    @Override
    public boolean isEmpty() {
        return getCatchTotalWeight() == null
               && getCatchTotalRejectedWeight() == null
               && CollectionUtils.isEmpty(getAttachment());
    }

    @Override
    public String getIcon() {
        return null;
    }

    public CatchBatch getCatchBatch() {
        return catchBatch;
    }

    public void setCatchBatch(CatchBatch catchBatch) {
        Object oldValue = getCatchBatch();
        Object oldObjectId = getObjectId();
        this.catchBatch = catchBatch;
        firePropertyChange(PROPERTY_CATCH_BATCH, oldValue, catchBatch);
        firePropertyChange(PROPERTY_OBJECT_ID, oldObjectId, getObjectId());
    }

    @Override
    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
        Object oldValue = getFishingOperation();
        this.fishingOperation = fishingOperation;
        firePropertyChange(PROPERTY_FISHING_OPERATION, oldValue, fishingOperation);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return speciesUsed;
    }

    public Multimap<CaracteristicQualitativeValue, CaracteristicQualitativeValue> getMarineLitterCategoriesUsed() {
        return marineLitterCategoriesUsed;
    }

    //------------------------------------------------------------------------//
    //-- Total                                                              --//
    //------------------------------------------------------------------------//

    public TuttiComputedOrNotData<Float> getCatchTotalComputedOrNotWeight() {
        return catchTotalComputedOrNotWeight;
    }

    @Override
    public Float getCatchTotalWeight() {
        return catchTotalComputedOrNotWeight.getData();
    }

    @Override
    public void setCatchTotalWeight(Float catchTotalWeight) {
        Object oldValue = getCatchTotalWeight();
        this.catchTotalComputedOrNotWeight.setData(catchTotalWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_WEIGHT, oldValue, catchTotalWeight);
    }

    @Override
    public Float getCatchTotalComputedWeight() {
        return catchTotalComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setCatchTotalComputedWeight(Float catchTotalComputedWeight) {
        Object oldValue = getCatchTotalComputedWeight();
        this.catchTotalComputedOrNotWeight.setComputedData(catchTotalComputedWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_COMPUTED_WEIGHT, oldValue, catchTotalComputedWeight);
    }

    @Override
    public Float getCatchTotalSortedComputedWeight() {
        return catchTotalSortedComputedWeight;
    }

    @Override
    public void setCatchTotalSortedComputedWeight(Float catchTotalSortedComputedWeight) {
        Object oldValue = getCatchTotalSortedComputedWeight();
        this.catchTotalSortedComputedWeight = catchTotalSortedComputedWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_COMPUTED_WEIGHT, oldValue, catchTotalSortedComputedWeight);
    }

    @Override
    public Float getCatchTotalUnsortedComputedWeight() {
        return catchTotalUnsortedComputedWeight;
    }

    @Override
    public void setCatchTotalUnsortedComputedWeight(Float catchTotalUnsortedComputedWeight) {
        Object oldValue = getCatchTotalUnsortedComputedWeight();
        this.catchTotalUnsortedComputedWeight = catchTotalUnsortedComputedWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_UNSORTED_COMPUTED_WEIGHT, oldValue, catchTotalUnsortedComputedWeight);
    }

    @Override
    public Float getCatchTotalSortedTremisWeight() {
        return catchTotalSortedTremisWeight;
    }

    @Override
    public void setCatchTotalSortedTremisWeight(Float catchTotalSortedTremisWeight) {
        Object oldValue = getCatchTotalSortedTremisWeight();
        this.catchTotalSortedTremisWeight = catchTotalSortedTremisWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT, oldValue, catchTotalSortedTremisWeight);
    }

    @Override
    public Float getCatchTotalSortedCarousselWeight() {
        return catchTotalSortedCarousselWeight;
    }

    @Override
    public void setCatchTotalSortedCarousselWeight(Float catchTotalSortedCarousselWeight) {
        Object oldValue = getCatchTotalSortedCarousselWeight();
        this.catchTotalSortedCarousselWeight = catchTotalSortedCarousselWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT, oldValue, catchTotalSortedCarousselWeight);
    }

    public TuttiComputedOrNotData<Float> getCatchTotalRejectedComputedOrNotWeight() {
        return catchTotalRejectedComputedOrNotWeight;
    }

    @Override
    public Float getCatchTotalRejectedWeight() {
        return catchTotalRejectedComputedOrNotWeight.getData();
    }

    @Override
    public void setCatchTotalRejectedWeight(Float catchTotalRejectedWeight) {
        Object oldValue = getCatchTotalRejectedWeight();
        this.catchTotalRejectedComputedOrNotWeight.setData(catchTotalRejectedWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT, oldValue, catchTotalRejectedWeight);
    }

    @Override
    public Float getCatchTotalRejectedComputedWeight() {
        return catchTotalRejectedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setCatchTotalRejectedComputedWeight(Float catchTotalRejectedComputedWeight) {
        Object oldValue = getCatchTotalRejectedComputedWeight();
        this.catchTotalRejectedComputedOrNotWeight.setComputedData(catchTotalRejectedComputedWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_REJECTED_COMPUTED_WEIGHT, oldValue, catchTotalRejectedComputedWeight);
    }

    //------------------------------------------------------------------------//
    //-- Species                                                            --//
    //------------------------------------------------------------------------//

    @Override
    public Float getSpeciesTotalComputedWeight() {
        return speciesTotalComputedWeight;
    }

    @Override
    public void setSpeciesTotalComputedWeight(Float speciesTotalComputedWeight) {
        Object oldValue = getSpeciesTotalComputedWeight();
        this.speciesTotalComputedWeight = speciesTotalComputedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_COMPUTED_WEIGHT, oldValue, speciesTotalComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalSortedComputedOrNotWeight() {
        return speciesTotalSortedComputedOrNotWeight;
    }

    @Override
    public Float getSpeciesTotalSortedWeight() {
        return speciesTotalSortedComputedOrNotWeight.getData();
    }

    @Override
    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        Object oldValue = getSpeciesTotalSortedWeight();
        this.speciesTotalSortedComputedOrNotWeight.setData(speciesTotalSortedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT, oldValue, speciesTotalSortedWeight);
    }

    @Override
    public Float getSpeciesTotalSortedComputedWeight() {
        return speciesTotalSortedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setSpeciesTotalSortedComputedWeight(Float speciesTotalSortedComputedWeight) {
        Object oldValue = getSpeciesTotalSortedComputedWeight();
        this.speciesTotalSortedComputedOrNotWeight.setComputedData(speciesTotalSortedComputedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SORTED_COMPUTED_WEIGHT, oldValue, speciesTotalSortedComputedWeight);
    }

    @Override
    public Float getSpeciesTotalSampleSortedComputedWeight() {
        return speciesTotalSampleSortedComputedWeight;
    }

    @Override
    public void setSpeciesTotalSampleSortedComputedWeight(Float speciesTotalSampleSortedComputedWeight) {
        Object oldValue = getSpeciesTotalSampleSortedComputedWeight();
        this.speciesTotalSampleSortedComputedWeight = speciesTotalSampleSortedComputedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT, oldValue, speciesTotalSampleSortedComputedWeight);
    }

    @Override
    public Float getSpeciesTotalUnsortedComputedWeight() {
        return speciesTotalUnsortedComputedWeight;
    }

    @Override
    public void setSpeciesTotalUnsortedComputedWeight(Float speciesTotalUnsortedComputedWeight) {
        Object oldValue = getSpeciesTotalUnsortedComputedWeight();
        this.speciesTotalUnsortedComputedWeight = speciesTotalUnsortedComputedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_UNSORTED_COMPUTED_WEIGHT, oldValue, speciesTotalUnsortedComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalInertComputedOrNotWeight() {
        return speciesTotalInertComputedOrNotWeight;
    }

    @Override
    public Float getSpeciesTotalInertWeight() {
        return speciesTotalInertComputedOrNotWeight.getData();
    }

    @Override
    public void setSpeciesTotalInertWeight(Float speciesTotalInertWeight) {
        Object oldValue = getSpeciesTotalInertWeight();
        this.speciesTotalInertComputedOrNotWeight.setData(speciesTotalInertWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_INERT_WEIGHT, oldValue, speciesTotalInertWeight);
    }

    @Override
    public Float getSpeciesTotalInertComputedWeight() {
        return speciesTotalInertComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setSpeciesTotalInertComputedWeight(Float speciesTotalInertComputedWeight) {
        Object oldValue = getSpeciesTotalInertComputedWeight();
        this.speciesTotalInertComputedOrNotWeight.setComputedData(speciesTotalInertComputedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_INERT_COMPUTED_WEIGHT, oldValue, speciesTotalInertComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalLivingNotItemizedComputedOrNotWeight() {
        return speciesTotalLivingNotItemizedComputedOrNotWeight;
    }

    @Override
    public Float getSpeciesTotalLivingNotItemizedWeight() {
        return speciesTotalLivingNotItemizedComputedOrNotWeight.getData();
    }

    @Override
    public void setSpeciesTotalLivingNotItemizedWeight(Float speciesTotalLivingNotItemizedWeight) {
        Object oldValue = getSpeciesTotalLivingNotItemizedComputedWeight();
        this.speciesTotalLivingNotItemizedComputedOrNotWeight.setData(speciesTotalLivingNotItemizedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT, oldValue, speciesTotalLivingNotItemizedWeight);
    }

    @Override
    public Float getSpeciesTotalLivingNotItemizedComputedWeight() {
        return speciesTotalLivingNotItemizedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setSpeciesTotalLivingNotItemizedComputedWeight(Float speciesTotalLivingNotItemizedComputedWeight) {
        Object oldValue = getSpeciesTotalLivingNotItemizedComputedWeight();
        this.speciesTotalLivingNotItemizedComputedOrNotWeight.setComputedData(speciesTotalLivingNotItemizedComputedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT, oldValue, speciesTotalLivingNotItemizedComputedWeight);
    }

    //------------------------------------------------------------------------//
    //-- Benthos                                                            --//
    //------------------------------------------------------------------------//

    @Override
    public Float getBenthosTotalComputedWeight() {
        return benthosTotalComputedWeight;
    }

    @Override
    public void setBenthosTotalComputedWeight(Float benthosTotalComputedWeight) {
        Object oldValue = getBenthosTotalComputedWeight();
        this.benthosTotalComputedWeight = benthosTotalComputedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_COMPUTED_WEIGHT, oldValue, benthosTotalComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getBenthosTotalSortedComputedOrNotWeight() {
        return benthosTotalSortedComputedOrNotWeight;
    }

    @Override
    public Float getBenthosTotalSortedWeight() {
        return benthosTotalSortedComputedOrNotWeight.getData();
    }

    @Override
    public void setBenthosTotalSortedWeight(Float benthosTotalSortedWeight) {
        Object oldValue = getBenthosTotalSortedWeight();
        this.benthosTotalSortedComputedOrNotWeight.setData(benthosTotalSortedWeight);
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT, oldValue, benthosTotalSortedWeight);
    }

    @Override
    public Float getBenthosTotalSortedComputedWeight() {
        return benthosTotalSortedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setBenthosTotalSortedComputedWeight(Float benthosTotalSortedComputedWeight) {
        Object oldValue = getBenthosTotalSortedComputedWeight();
        this.benthosTotalSortedComputedOrNotWeight.setComputedData(benthosTotalSortedComputedWeight);
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_SORTED_COMPUTED_WEIGHT, oldValue, benthosTotalSortedComputedWeight);
    }

    @Override
    public Float getBenthosTotalSampleSortedComputedWeight() {
        return benthosTotalSampleSortedComputedWeight;
    }

    @Override
    public void setBenthosTotalSampleSortedComputedWeight(Float benthosTotalSampleSortedComputedWeight) {
        Object oldValue = getBenthosTotalSampleSortedComputedWeight();
        this.benthosTotalSampleSortedComputedWeight = benthosTotalSampleSortedComputedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT, oldValue, benthosTotalSampleSortedComputedWeight);
    }

    @Override
    public Float getBenthosTotalUnsortedComputedWeight() {
        return benthosTotalUnsortedComputedWeight;
    }

    @Override
    public void setBenthosTotalUnsortedComputedWeight(Float benthosTotalUnsortedComputedWeight) {
        Object oldValue = getBenthosTotalUnsortedComputedWeight();
        this.benthosTotalUnsortedComputedWeight = benthosTotalUnsortedComputedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_UNSORTED_COMPUTED_WEIGHT, oldValue, benthosTotalUnsortedComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getBenthosTotalInertComputedOrNotWeight() {
        return benthosTotalInertComputedOrNotWeight;
    }

    @Override
    public Float getBenthosTotalInertWeight() {
        return benthosTotalInertComputedOrNotWeight.getData();
    }

    @Override
    public void setBenthosTotalInertWeight(Float benthosTotalInertWeight) {
        Object oldValue = getBenthosTotalInertWeight();
        this.benthosTotalInertComputedOrNotWeight.setData(benthosTotalInertWeight);
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT, oldValue, benthosTotalInertWeight);
    }

    @Override
    public Float getBenthosTotalInertComputedWeight() {
        return benthosTotalInertComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setBenthosTotalInertComputedWeight(Float benthosTotalInertComputedWeight) {
        Object oldValue = getBenthosTotalInertComputedWeight();
        this.benthosTotalInertComputedOrNotWeight.setComputedData(benthosTotalInertComputedWeight);
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_INERT_COMPUTED_WEIGHT, oldValue, benthosTotalInertComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getBenthosTotalLivingNotItemizedComputedOrNotWeight() {
        return benthosTotalLivingNotItemizedComputedOrNotWeight;
    }

    @Override
    public Float getBenthosTotalLivingNotItemizedWeight() {
        return benthosTotalLivingNotItemizedComputedOrNotWeight.getData();
    }

    @Override
    public void setBenthosTotalLivingNotItemizedWeight(Float benthosTotalLivingNotItemizedWeight) {
        Object oldValue = getBenthosTotalLivingNotItemizedComputedWeight();
        this.benthosTotalLivingNotItemizedComputedOrNotWeight.setData(benthosTotalLivingNotItemizedWeight);
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT, oldValue, benthosTotalLivingNotItemizedWeight);
    }

    @Override
    public Float getBenthosTotalLivingNotItemizedComputedWeight() {
        return benthosTotalLivingNotItemizedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setBenthosTotalLivingNotItemizedComputedWeight(Float benthosTotalLivingNotItemizedComputedWeight) {
        Object oldValue = getBenthosTotalLivingNotItemizedComputedWeight();
        this.benthosTotalLivingNotItemizedComputedOrNotWeight.setComputedData(benthosTotalLivingNotItemizedComputedWeight);
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT, oldValue, benthosTotalLivingNotItemizedComputedWeight);
    }

    //------------------------------------------------------------------------//
    //-- Plankton                                                           --//
    //------------------------------------------------------------------------//

    @Override
    public Float getPlanktonTotalWeight() {
        return planktonTotalWeight;
    }

    @Override
    public void setPlanktonTotalWeight(Float planktonTotalWeight) {
        Object oldValue = getPlanktonTotalWeight();
        this.planktonTotalWeight = planktonTotalWeight;
        firePropertyChange(PROPERTY_PLANKTON_TOTAL_WEIGHT, oldValue, planktonTotalWeight);
    }

    @Override
    public Float getPlanktonTotalSampleWeight() {
        return planktonTotalSampleWeight;
    }

    @Override
    public void setPlanktonTotalSampleWeight(Float planktonTotalSampleWeight) {
        Object oldValue = getPlanktonTotalSampleWeight();
        this.planktonTotalSampleWeight = planktonTotalSampleWeight;
        firePropertyChange(PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT, oldValue, planktonTotalSampleWeight);
    }

    //------------------------------------------------------------------------//
    //-- Marine Litter                                                      --//
    //------------------------------------------------------------------------//

    public TuttiComputedOrNotData<Float> getMarineLitterTotalComputedOrNotWeight() {
        return marineLitterTotalComputedOrNotWeight;
    }

    @Override
    public Float getMarineLitterTotalWeight() {
        return marineLitterTotalComputedOrNotWeight.getData();
    }

    @Override
    public void setMarineLitterTotalWeight(Float marineLitterTotalWeight) {
        Object oldValue = getMarineLitterTotalWeight();
        this.marineLitterTotalComputedOrNotWeight.setData(marineLitterTotalWeight);
        firePropertyChange(PROPERTY_MARINE_LITTER_TOTAL_WEIGHT, oldValue, marineLitterTotalWeight);
    }

    @Override
    public Float getMarineLitterTotalComputedWeight() {
        return marineLitterTotalComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setMarineLitterTotalComputedWeight(Float marineLitterTotalComputedWeight) {
        Object oldValue = getMarineLitterTotalComputedWeight();
        this.marineLitterTotalComputedOrNotWeight.setComputedData(marineLitterTotalComputedWeight);
        firePropertyChange(PROPERTY_MARINE_LITTER_TOTAL_COMPUTED_WEIGHT, oldValue, marineLitterTotalComputedWeight);
    }

    //------------------------------------------------------------------------//
    //-- Attachment                                                         --//
    //------------------------------------------------------------------------//

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.CATCH_BATCH;
    }

    @Override
    public String getObjectId() {
        return catchBatch == null ? null : catchBatch.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    public void reset() {
        setSpeciesTotalInertComputedWeight(null);
        setSpeciesTotalLivingNotItemizedComputedWeight(null);
        setSpeciesTotalSampleSortedComputedWeight(null);
        setSpeciesTotalSortedComputedWeight(null);
        setSpeciesTotalUnsortedComputedWeight(null);
        setSpeciesTotalComputedWeight(null);
        setBenthosTotalInertComputedWeight(null);
        setBenthosTotalLivingNotItemizedComputedWeight(null);
        setBenthosTotalSampleSortedComputedWeight(null);
        setBenthosTotalSortedComputedWeight(null);
        setBenthosTotalUnsortedComputedWeight(null);
        setBenthosTotalComputedWeight(null);
        setMarineLitterTotalComputedWeight(null);
        setCatchTotalRejectedComputedWeight(null);
        setCatchTotalSortedComputedWeight(null);
        setCatchTotalUnsortedComputedWeight(null);
        setCatchTotalComputedWeight(null);
        removeAllAttachment(getAttachment());
        getSpeciesUsed().clear();
    }
}
