package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getWeightStringValue;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCatchesUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "accidentalTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "benthosTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "benthosTotalSampleSortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "benthosTotalSortedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalSortedWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT = "benthosTotalWeightField.text";
    public static final String BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED = "catchesCaracteristicsAttachmentsButton.enabled";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN = "catchTotalRejectedWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL = "catchTotalRejectedWeightField.model";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalRejectedWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_TEXT = "catchTotalSortedCarousselWeightField.text";
    public static final String BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_TEXT = "catchTotalSortedTremisWeightField.text";
    public static final String BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT = "catchTotalSortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "catchTotalUnsortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN = "catchTotalWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL = "catchTotalWeightField.model";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalWeightField.numberPattern";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "individualObservationTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "marineLitterTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN = "marineLitterTotalWeightField.bean";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL = "marineLitterTotalWeightField.model";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "marineLitterTotalWeightField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "speciesTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "speciesTotalSortedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";
    public static final String BINDING_TREMIE_CARROUSEL_ROW_VISIBLE = "tremieCarrouselRow.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel CaracteristicMapEditorReminderLabel;
    protected TabInfo accidentalTab;
    protected AccidentalBatchUI accidentalTabContent;
    protected CreateAccidentalBatchUI accidentalTabCreateBatch;
    protected JXTitledPanel accidentalTabCreateBatchReminderLabel;
    protected JXTitledPanel accidentalTabFishingOperationReminderLabel;
    protected JPanel accidentalTabPanel;
    protected CardLayout2Ext accidentalTabPanelLayout;
    protected TabInfo benthosTab;
    protected BenthosBatchUI benthosTabContent;
    protected CreateBenthosBatchUI benthosTabCreateBatch;
    protected JXTitledPanel benthosTabCreateBatchReminderLabel;
    protected JXTitledPanel benthosTabFishingOperationReminderLabel;
    protected BenthosFrequencyUI benthosTabFrequencyEditor;
    protected JXTitledPanel benthosTabFrequencyEditorReminderLabel;
    protected JPanel benthosTabPanel;
    protected CardLayout2Ext benthosTabPanelLayout;
    protected SplitBenthosBatchUI benthosTabSplitBatch;
    protected JXTitledPanel benthosTabSplitBatchReminderLabel;
    protected Table benthosTable;
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected TuttiComputedOrNotDataEditor benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected CaracteristicMapEditorUI caracteristicMapEditor;
    protected Table catchTable;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalRejectedWeight",  editorName = "catchTotalRejectedWeightField")
    protected TuttiComputedOrNotDataEditor catchTotalRejectedWeightField;
    protected JLabel catchTotalRejectedWeightLabel;
    protected JTextField catchTotalSortedCarousselWeightField;
    protected JLabel catchTotalSortedCarousselWeightLabel;
    protected JTextField catchTotalSortedTremisWeightField;
    protected JLabel catchTotalSortedTremisWeightLabel;
    protected JTextField catchTotalSortedWeightField;
    protected JLabel catchTotalSortedWeightLabel;
    protected JTextField catchTotalUnsortedWeightField;
    protected JLabel catchTotalUnsortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalWeight",  editorName = "catchTotalWeightField")
    protected TuttiComputedOrNotDataEditor catchTotalWeightField;
    protected JLabel catchTotalWeightLabel;
    protected ButtonAttachment catchesCaracteristicsAttachmentsButton;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JScrollPane catchesCaracteristicsTabScrollPane;
    protected JToolBar catchesCaracteristicsTabToolBar;
    protected Table catchesForm;
    protected JButton computeSpeciesBatchButton;
    protected JPanel createFishingOperationActions;
    protected EditCatchesUI editCatchesTopPanel = this;
    protected EditCatchesUIHandler handler;
    protected JButton importPupitriButton;
    protected TabInfo individualObservationTab;
    protected IndividualObservationBatchUI individualObservationTabContent;
    protected CreateIndividualObservationBatchUI individualObservationTabCreateBatch;
    protected JXTitledPanel individualObservationTabCreateBatchReminderLabel;
    protected JXTitledPanel individualObservationTabFishingOperationReminderLabel;
    protected JPanel individualObservationTabPanel;
    protected CardLayout2Ext individualObservationTabPanelLayout;
    protected TabInfo marineLitterTab;
    protected MarineLitterBatchUI marineLitterTabContent;
    protected CreateMarineLitterBatchUI marineLitterTabCreateBatch;
    protected JXTitledPanel marineLitterTabCreateBatchReminderLabel;
    protected JXTitledPanel marineLitterTabFishingOperationReminderLabel;
    protected JPanel marineLitterTabPanel;
    protected CardLayout2Ext marineLitterTabPanelLayout;
    protected Table marineLitterTable;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterTotalWeight",  editorName = "marineLitterTotalWeightField")
    protected TuttiComputedOrNotDataEditor marineLitterTotalWeightField;
    protected JLabel marineLitterTotalWeightLabel;
    protected EditCatchesUIModel model;
    protected TabInfo planktonTab;
    protected JButton saveButton;
    protected TabInfo speciesTab;
    protected SpeciesBatchUI speciesTabContent;
    protected CreateSpeciesBatchUI speciesTabCreateBatch;
    protected JXTitledPanel speciesTabCreateBatchReminderLabel;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected SpeciesFrequencyUI speciesTabFrequencyEditor;
    protected JXTitledPanel speciesTabFrequencyEditorReminderLabel;
    protected JPanel speciesTabPanel;
    protected CardLayout2Ext speciesTabPanelLayout;
    protected SplitSpeciesBatchUI speciesTabSplitBatch;
    protected JXTitledPanel speciesTabSplitBatchReminderLabel;
    protected Table speciesTable;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected TuttiComputedOrNotDataEditor speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JTabbedPane tabPane;
    protected Table tremieCarrouselRow;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditCatchesUIHandler handler = new EditCatchesUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public AccidentalBatchUI getAccidentalTabContent() {
        return accidentalTabContent;
    }

    public CreateAccidentalBatchUI getAccidentalTabCreateBatch() {
        return accidentalTabCreateBatch;
    }

    public JXTitledPanel getAccidentalTabCreateBatchReminderLabel() {
        return accidentalTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getAccidentalTabFishingOperationReminderLabel() {
        return accidentalTabFishingOperationReminderLabel;
    }

    public JPanel getAccidentalTabPanel() {
        return accidentalTabPanel;
    }

    public CardLayout2Ext getAccidentalTabPanelLayout() {
        return accidentalTabPanelLayout;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public BenthosBatchUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public CreateBenthosBatchUI getBenthosTabCreateBatch() {
        return benthosTabCreateBatch;
    }

    public JXTitledPanel getBenthosTabCreateBatchReminderLabel() {
        return benthosTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getBenthosTabFishingOperationReminderLabel() {
        return benthosTabFishingOperationReminderLabel;
    }

    public BenthosFrequencyUI getBenthosTabFrequencyEditor() {
        return benthosTabFrequencyEditor;
    }

    public JXTitledPanel getBenthosTabFrequencyEditorReminderLabel() {
        return benthosTabFrequencyEditorReminderLabel;
    }

    public JPanel getBenthosTabPanel() {
        return benthosTabPanel;
    }

    public CardLayout2Ext getBenthosTabPanelLayout() {
        return benthosTabPanelLayout;
    }

    public SplitBenthosBatchUI getBenthosTabSplitBatch() {
        return benthosTabSplitBatch;
    }

    public JXTitledPanel getBenthosTabSplitBatchReminderLabel() {
        return benthosTabSplitBatchReminderLabel;
    }

    public Table getBenthosTable() {
        return benthosTable;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public CaracteristicMapEditorUI getCaracteristicMapEditor() {
        return caracteristicMapEditor;
    }

    public JXTitledPanel getCaracteristicMapEditorReminderLabel() {
        return CaracteristicMapEditorReminderLabel;
    }

    public Table getCatchTable() {
        return catchTable;
    }

    public TuttiComputedOrNotDataEditor getCatchTotalRejectedWeightField() {
        return catchTotalRejectedWeightField;
    }

    public JLabel getCatchTotalRejectedWeightLabel() {
        return catchTotalRejectedWeightLabel;
    }

    public JTextField getCatchTotalSortedCarousselWeightField() {
        return catchTotalSortedCarousselWeightField;
    }

    public JLabel getCatchTotalSortedCarousselWeightLabel() {
        return catchTotalSortedCarousselWeightLabel;
    }

    public JTextField getCatchTotalSortedTremisWeightField() {
        return catchTotalSortedTremisWeightField;
    }

    public JLabel getCatchTotalSortedTremisWeightLabel() {
        return catchTotalSortedTremisWeightLabel;
    }

    public JTextField getCatchTotalSortedWeightField() {
        return catchTotalSortedWeightField;
    }

    public JLabel getCatchTotalSortedWeightLabel() {
        return catchTotalSortedWeightLabel;
    }

    public JTextField getCatchTotalUnsortedWeightField() {
        return catchTotalUnsortedWeightField;
    }

    public JLabel getCatchTotalUnsortedWeightLabel() {
        return catchTotalUnsortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getCatchTotalWeightField() {
        return catchTotalWeightField;
    }

    public JLabel getCatchTotalWeightLabel() {
        return catchTotalWeightLabel;
    }

    public ButtonAttachment getCatchesCaracteristicsAttachmentsButton() {
        return catchesCaracteristicsAttachmentsButton;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JScrollPane getCatchesCaracteristicsTabScrollPane() {
        return catchesCaracteristicsTabScrollPane;
    }

    public JToolBar getCatchesCaracteristicsTabToolBar() {
        return catchesCaracteristicsTabToolBar;
    }

    public Table getCatchesForm() {
        return catchesForm;
    }

    public JButton getComputeSpeciesBatchButton() {
        return computeSpeciesBatchButton;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public TabInfo getIndividualObservationTab() {
        return individualObservationTab;
    }

    public IndividualObservationBatchUI getIndividualObservationTabContent() {
        return individualObservationTabContent;
    }

    public CreateIndividualObservationBatchUI getIndividualObservationTabCreateBatch() {
        return individualObservationTabCreateBatch;
    }

    public JXTitledPanel getIndividualObservationTabCreateBatchReminderLabel() {
        return individualObservationTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getIndividualObservationTabFishingOperationReminderLabel() {
        return individualObservationTabFishingOperationReminderLabel;
    }

    public JPanel getIndividualObservationTabPanel() {
        return individualObservationTabPanel;
    }

    public CardLayout2Ext getIndividualObservationTabPanelLayout() {
        return individualObservationTabPanelLayout;
    }

    public TabInfo getMarineLitterTab() {
        return marineLitterTab;
    }

    public MarineLitterBatchUI getMarineLitterTabContent() {
        return marineLitterTabContent;
    }

    public CreateMarineLitterBatchUI getMarineLitterTabCreateBatch() {
        return marineLitterTabCreateBatch;
    }

    public JXTitledPanel getMarineLitterTabCreateBatchReminderLabel() {
        return marineLitterTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getMarineLitterTabFishingOperationReminderLabel() {
        return marineLitterTabFishingOperationReminderLabel;
    }

    public JPanel getMarineLitterTabPanel() {
        return marineLitterTabPanel;
    }

    public CardLayout2Ext getMarineLitterTabPanelLayout() {
        return marineLitterTabPanelLayout;
    }

    public Table getMarineLitterTable() {
        return marineLitterTable;
    }

    public TuttiComputedOrNotDataEditor getMarineLitterTotalWeightField() {
        return marineLitterTotalWeightField;
    }

    public JLabel getMarineLitterTotalWeightLabel() {
        return marineLitterTotalWeightLabel;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public TabInfo getPlanktonTab() {
        return planktonTab;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public CreateSpeciesBatchUI getSpeciesTabCreateBatch() {
        return speciesTabCreateBatch;
    }

    public JXTitledPanel getSpeciesTabCreateBatchReminderLabel() {
        return speciesTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public SpeciesFrequencyUI getSpeciesTabFrequencyEditor() {
        return speciesTabFrequencyEditor;
    }

    public JXTitledPanel getSpeciesTabFrequencyEditorReminderLabel() {
        return speciesTabFrequencyEditorReminderLabel;
    }

    public JPanel getSpeciesTabPanel() {
        return speciesTabPanel;
    }

    public CardLayout2Ext getSpeciesTabPanelLayout() {
        return speciesTabPanelLayout;
    }

    public SplitSpeciesBatchUI getSpeciesTabSplitBatch() {
        return speciesTabSplitBatch;
    }

    public JXTitledPanel getSpeciesTabSplitBatchReminderLabel() {
        return speciesTabSplitBatchReminderLabel;
    }

    public Table getSpeciesTable() {
        return speciesTable;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTremieCarrouselRow() {
        return tremieCarrouselRow;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabCreateBatchReminderLabel.add(accidentalTabCreateBatch);
    }

    protected void addChildrenToAccidentalTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabFishingOperationReminderLabel.add(accidentalTabContent);
    }

    protected void addChildrenToAccidentalTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabPanel.add(accidentalTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        accidentalTabPanel.add(accidentalTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
    }

    protected void addChildrenToBenthosTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabCreateBatchReminderLabel.add(benthosTabCreateBatch);
    }

    protected void addChildrenToBenthosTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFishingOperationReminderLabel.add(benthosTabContent);
    }

    protected void addChildrenToBenthosTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFrequencyEditorReminderLabel.add(benthosTabFrequencyEditor);
    }

    protected void addChildrenToBenthosTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabPanel.add(benthosTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        benthosTabPanel.add(benthosTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        benthosTabPanel.add(benthosTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        benthosTabPanel.add(benthosTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToBenthosTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabSplitBatchReminderLabel.add(benthosTabSplitBatch);
    }

    protected void addChildrenToBenthosTable() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTable.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCaracteristicMapEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        CaracteristicMapEditorReminderLabel.add(caracteristicMapEditor);
    }

    protected void addChildrenToCatchTable() {
        if (!allComponentsCreated) {
            return;
        }
        catchTable.add(catchTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalWeightField), new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightField, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(tremieCarrouselRow, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightField, new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalRejectedWeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalRejectedWeightField), new GridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(catchesCaracteristicsTabScrollPane);
    }

    protected void addChildrenToCatchesCaracteristicsTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabScrollPane.getViewport().add($JPanel0);
    }

    protected void addChildrenToCatchesCaracteristicsTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabToolBar.add(importPupitriButton);
        catchesCaracteristicsTabToolBar.add(catchesCaracteristicsAttachmentsButton);
    }

    protected void addChildrenToCatchesForm() {
        if (!allComponentsCreated) {
            return;
        }
        catchesForm.add(catchTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(speciesTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(benthosTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(marineLitterTable, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
        createFishingOperationActions.add(computeSpeciesBatchButton);
    }

    protected void addChildrenToEditCatchesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(catchesCaracteristicsTabToolBar);
        add(tabPane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void addChildrenToIndividualObservationTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabCreateBatchReminderLabel.add(individualObservationTabCreateBatch);
    }

    protected void addChildrenToIndividualObservationTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabFishingOperationReminderLabel.add(individualObservationTabContent);
    }

    protected void addChildrenToIndividualObservationTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabPanel.add(individualObservationTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        individualObservationTabPanel.add(individualObservationTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        individualObservationTabPanel.add(CaracteristicMapEditorReminderLabel, EditCatchesUIHandler.EDIT_CARACTERISTICS_CARD);
    }

    protected void addChildrenToMarineLitterTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabCreateBatchReminderLabel.add(marineLitterTabCreateBatch);
    }

    protected void addChildrenToMarineLitterTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabFishingOperationReminderLabel.add(marineLitterTabContent);
    }

    protected void addChildrenToMarineLitterTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabPanel.add(marineLitterTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        marineLitterTabPanel.add(marineLitterTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
    }

    protected void addChildrenToMarineLitterTable() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTable.add(marineLitterTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        marineLitterTable.add(SwingUtil.boxComponentWithJxLayer(marineLitterTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSpeciesTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabCreateBatchReminderLabel.add(speciesTabCreateBatch);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFrequencyEditorReminderLabel.add(speciesTabFrequencyEditor);
    }

    protected void addChildrenToSpeciesTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabPanel.add(speciesTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        speciesTabPanel.add(speciesTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        speciesTabPanel.add(speciesTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        speciesTabPanel.add(speciesTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToSpeciesTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabSplitBatchReminderLabel.add(speciesTabSplitBatch);
    }

    protected void addChildrenToSpeciesTable() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTable.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabPanel);
        tabPane.add(benthosTabPanel);
        tabPane.add(marineLitterTabPanel);
        tabPane.add(accidentalTabPanel);
        tabPane.add(individualObservationTabPanel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        marineLitterTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, _("tutti.label.tab.marineLitter"));
        accidentalTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        individualObservationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
    }

    protected void addChildrenToTremieCarrouselRow() {
        if (!allComponentsCreated) {
            return;
        }
        tremieCarrouselRow.add(catchTotalSortedCarousselWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        tremieCarrouselRow.add(catchTotalSortedCarousselWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        tremieCarrouselRow.add(catchTotalSortedTremisWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        tremieCarrouselRow.add(catchTotalSortedTremisWeightField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
    }

    protected void createAccidentalTabContent() {
        $objectMap.put("accidentalTabContent", accidentalTabContent = new AccidentalBatchUI(this));
        
        accidentalTabContent.setName("accidentalTabContent");
    }

    protected void createAccidentalTabCreateBatch() {
        $objectMap.put("accidentalTabCreateBatch", accidentalTabCreateBatch = new CreateAccidentalBatchUI(this));
        
        accidentalTabCreateBatch.setName("accidentalTabCreateBatch");
    }

    protected void createAccidentalTabCreateBatchReminderLabel() {
        $objectMap.put("accidentalTabCreateBatchReminderLabel", accidentalTabCreateBatchReminderLabel = new JXTitledPanel());
        
        accidentalTabCreateBatchReminderLabel.setName("accidentalTabCreateBatchReminderLabel");
    }

    protected void createAccidentalTabFishingOperationReminderLabel() {
        $objectMap.put("accidentalTabFishingOperationReminderLabel", accidentalTabFishingOperationReminderLabel = new JXTitledPanel());
        
        accidentalTabFishingOperationReminderLabel.setName("accidentalTabFishingOperationReminderLabel");
    }

    protected void createAccidentalTabPanel() {
        $objectMap.put("accidentalTabPanel", accidentalTabPanel = new JPanel());
        
        accidentalTabPanel.setName("accidentalTabPanel");
        accidentalTabPanel.setLayout(accidentalTabPanelLayout);
    }

    protected void createAccidentalTabPanelLayout() {
        $objectMap.put("accidentalTabPanelLayout", accidentalTabPanelLayout = new CardLayout2Ext(this, "accidentalTabPanel"));
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosBatchUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createBenthosTabCreateBatch() {
        $objectMap.put("benthosTabCreateBatch", benthosTabCreateBatch = new CreateBenthosBatchUI(this));
        
        benthosTabCreateBatch.setName("benthosTabCreateBatch");
    }

    protected void createBenthosTabCreateBatchReminderLabel() {
        $objectMap.put("benthosTabCreateBatchReminderLabel", benthosTabCreateBatchReminderLabel = new JXTitledPanel());
        
        benthosTabCreateBatchReminderLabel.setName("benthosTabCreateBatchReminderLabel");
    }

    protected void createBenthosTabFishingOperationReminderLabel() {
        $objectMap.put("benthosTabFishingOperationReminderLabel", benthosTabFishingOperationReminderLabel = new JXTitledPanel());
        
        benthosTabFishingOperationReminderLabel.setName("benthosTabFishingOperationReminderLabel");
    }

    protected void createBenthosTabFrequencyEditor() {
        $objectMap.put("benthosTabFrequencyEditor", benthosTabFrequencyEditor = new BenthosFrequencyUI(benthosTabContent));
        
        benthosTabFrequencyEditor.setName("benthosTabFrequencyEditor");
    }

    protected void createBenthosTabFrequencyEditorReminderLabel() {
        $objectMap.put("benthosTabFrequencyEditorReminderLabel", benthosTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        benthosTabFrequencyEditorReminderLabel.setName("benthosTabFrequencyEditorReminderLabel");
    }

    protected void createBenthosTabPanel() {
        $objectMap.put("benthosTabPanel", benthosTabPanel = new JPanel());
        
        benthosTabPanel.setName("benthosTabPanel");
        benthosTabPanel.setLayout(benthosTabPanelLayout);
    }

    protected void createBenthosTabPanelLayout() {
        $objectMap.put("benthosTabPanelLayout", benthosTabPanelLayout = new CardLayout2Ext(this, "benthosTabPanel"));
    }

    protected void createBenthosTabSplitBatch() {
        $objectMap.put("benthosTabSplitBatch", benthosTabSplitBatch = new SplitBenthosBatchUI(this));
        
        benthosTabSplitBatch.setName("benthosTabSplitBatch");
    }

    protected void createBenthosTabSplitBatchReminderLabel() {
        $objectMap.put("benthosTabSplitBatchReminderLabel", benthosTabSplitBatchReminderLabel = new JXTitledPanel());
        
        benthosTabSplitBatchReminderLabel.setName("benthosTabSplitBatchReminderLabel");
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new Table());
        
        benthosTable.setName("benthosTable");
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setDecimalNumber(3);
        benthosTotalSortedWeightField.setUseFloat(true);
        benthosTotalSortedWeightField.setShowReset(true);
        benthosTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalSortedWeight"));
        benthosTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalUnsortedWeight"));
        benthosTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalWeight"));
        benthosTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalWeight.help");
        benthosTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCatchBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.editCatchBatch.action.cancelEditCatchBatch"));
        cancelButton.setToolTipText(_("tutti.editCatchBatch.action.cancelEditCatchBatch.tip"));
        cancelButton.putClientProperty("help", "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        cancelButton.putClientProperty("tuttiAction", CancelEditCatchBatchAction.class);
    }

    protected void createCaracteristicMapEditor() {
        $objectMap.put("caracteristicMapEditor", caracteristicMapEditor = new CaracteristicMapEditorUI(individualObservationTabContent));
        
        caracteristicMapEditor.setName("caracteristicMapEditor");
    }

    protected void createCaracteristicMapEditorReminderLabel() {
        $objectMap.put("CaracteristicMapEditorReminderLabel", CaracteristicMapEditorReminderLabel = new JXTitledPanel());
        
        CaracteristicMapEditorReminderLabel.setName("CaracteristicMapEditorReminderLabel");
    }

    protected void createCatchTable() {
        $objectMap.put("catchTable", catchTable = new Table());
        
        catchTable.setName("catchTable");
    }

    protected void createCatchTotalRejectedWeightField() {
        $objectMap.put("catchTotalRejectedWeightField", catchTotalRejectedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        catchTotalRejectedWeightField.setName("catchTotalRejectedWeightField");
        catchTotalRejectedWeightField.setDecimalNumber(3);
        catchTotalRejectedWeightField.setUseFloat(true);
        catchTotalRejectedWeightField.setShowReset(true);
        catchTotalRejectedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createCatchTotalRejectedWeightLabel() {
        $objectMap.put("catchTotalRejectedWeightLabel", catchTotalRejectedWeightLabel = new JLabel());
        
        catchTotalRejectedWeightLabel.setName("catchTotalRejectedWeightLabel");
        catchTotalRejectedWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalRejectedWeight"));
        catchTotalRejectedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
    }

    protected void createCatchTotalSortedCarousselWeightField() {
        $objectMap.put("catchTotalSortedCarousselWeightField", catchTotalSortedCarousselWeightField = new JTextField());
        
        catchTotalSortedCarousselWeightField.setName("catchTotalSortedCarousselWeightField");
        catchTotalSortedCarousselWeightField.setColumns(15);
        catchTotalSortedCarousselWeightField.setEnabled(false);
    }

    protected void createCatchTotalSortedCarousselWeightLabel() {
        $objectMap.put("catchTotalSortedCarousselWeightLabel", catchTotalSortedCarousselWeightLabel = new JLabel());
        
        catchTotalSortedCarousselWeightLabel.setName("catchTotalSortedCarousselWeightLabel");
        catchTotalSortedCarousselWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalSortedCarousselWeight"));
        catchTotalSortedCarousselWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
    }

    protected void createCatchTotalSortedTremisWeightField() {
        $objectMap.put("catchTotalSortedTremisWeightField", catchTotalSortedTremisWeightField = new JTextField());
        
        catchTotalSortedTremisWeightField.setName("catchTotalSortedTremisWeightField");
        catchTotalSortedTremisWeightField.setColumns(15);
        catchTotalSortedTremisWeightField.setEnabled(false);
    }

    protected void createCatchTotalSortedTremisWeightLabel() {
        $objectMap.put("catchTotalSortedTremisWeightLabel", catchTotalSortedTremisWeightLabel = new JLabel());
        
        catchTotalSortedTremisWeightLabel.setName("catchTotalSortedTremisWeightLabel");
        catchTotalSortedTremisWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalSortedTremisWeight"));
        catchTotalSortedTremisWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
    }

    protected void createCatchTotalSortedWeightField() {
        $objectMap.put("catchTotalSortedWeightField", catchTotalSortedWeightField = new JTextField());
        
        catchTotalSortedWeightField.setName("catchTotalSortedWeightField");
        catchTotalSortedWeightField.setColumns(15);
        catchTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalSortedWeightLabel() {
        $objectMap.put("catchTotalSortedWeightLabel", catchTotalSortedWeightLabel = new JLabel());
        
        catchTotalSortedWeightLabel.setName("catchTotalSortedWeightLabel");
        catchTotalSortedWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalSortedWeight"));
        catchTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
    }

    protected void createCatchTotalUnsortedWeightField() {
        $objectMap.put("catchTotalUnsortedWeightField", catchTotalUnsortedWeightField = new JTextField());
        
        catchTotalUnsortedWeightField.setName("catchTotalUnsortedWeightField");
        catchTotalUnsortedWeightField.setColumns(15);
        catchTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalUnsortedWeightLabel() {
        $objectMap.put("catchTotalUnsortedWeightLabel", catchTotalUnsortedWeightLabel = new JLabel());
        
        catchTotalUnsortedWeightLabel.setName("catchTotalUnsortedWeightLabel");
        catchTotalUnsortedWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalUnsortedWeight"));
        catchTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
    }

    protected void createCatchTotalWeightField() {
        $objectMap.put("catchTotalWeightField", catchTotalWeightField = new TuttiComputedOrNotDataEditor(this));
        
        catchTotalWeightField.setName("catchTotalWeightField");
        catchTotalWeightField.setDecimalNumber(3);
        catchTotalWeightField.setUseFloat(true);
        catchTotalWeightField.setShowReset(true);
        catchTotalWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createCatchTotalWeightLabel() {
        $objectMap.put("catchTotalWeightLabel", catchTotalWeightLabel = new JLabel());
        
        catchTotalWeightLabel.setName("catchTotalWeightLabel");
        catchTotalWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalWeight"));
        catchTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalWeight.help");
        catchTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createCatchesCaracteristicsAttachmentsButton() {
        $objectMap.put("catchesCaracteristicsAttachmentsButton", catchesCaracteristicsAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        catchesCaracteristicsAttachmentsButton.setName("catchesCaracteristicsAttachmentsButton");
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabScrollPane() {
        $objectMap.put("catchesCaracteristicsTabScrollPane", catchesCaracteristicsTabScrollPane = new JScrollPane());
        
        catchesCaracteristicsTabScrollPane.setName("catchesCaracteristicsTabScrollPane");
    }

    protected void createCatchesCaracteristicsTabToolBar() {
        $objectMap.put("catchesCaracteristicsTabToolBar", catchesCaracteristicsTabToolBar = new JToolBar());
        
        catchesCaracteristicsTabToolBar.setName("catchesCaracteristicsTabToolBar");
        catchesCaracteristicsTabToolBar.setFloatable(false);
        catchesCaracteristicsTabToolBar.setOpaque(false);
        catchesCaracteristicsTabToolBar.setBorderPainted(false);
    }

    protected void createCatchesForm() {
        $objectMap.put("catchesForm", catchesForm = new Table());
        
        catchesForm.setName("catchesForm");
    }

    protected void createComputeSpeciesBatchButton() {
        $objectMap.put("computeSpeciesBatchButton", computeSpeciesBatchButton = new JButton());
        
        computeSpeciesBatchButton.setName("computeSpeciesBatchButton");
        computeSpeciesBatchButton.setText(_("tutti.editCatchBatch.action.computeWeights"));
        computeSpeciesBatchButton.setToolTipText(_("tutti.editCatchBatch.action.computeWeights.tip"));
        computeSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.computeWeights.help");
        computeSpeciesBatchButton.putClientProperty("tuttiAction", ComputeWeightsAction.class);
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCatchesUIHandler.class));
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(_("tutti.editCatchBatch.action.importPupitri"));
        importPupitriButton.setToolTipText(_("tutti.editCatchBatch.action.importPupitri.tip"));
        importPupitriButton.putClientProperty("help", "tutti.editCatchBatch.action.importPupitri.help");
        importPupitriButton.putClientProperty("tuttiAction", ImportPupitriAction.class);
    }

    protected void createIndividualObservationTab() {
        $objectMap.put("individualObservationTab", individualObservationTab = new TabInfo());
    }

    protected void createIndividualObservationTabContent() {
        $objectMap.put("individualObservationTabContent", individualObservationTabContent = new IndividualObservationBatchUI(this));
        
        individualObservationTabContent.setName("individualObservationTabContent");
    }

    protected void createIndividualObservationTabCreateBatch() {
        $objectMap.put("individualObservationTabCreateBatch", individualObservationTabCreateBatch = new CreateIndividualObservationBatchUI(this));
        
        individualObservationTabCreateBatch.setName("individualObservationTabCreateBatch");
    }

    protected void createIndividualObservationTabCreateBatchReminderLabel() {
        $objectMap.put("individualObservationTabCreateBatchReminderLabel", individualObservationTabCreateBatchReminderLabel = new JXTitledPanel());
        
        individualObservationTabCreateBatchReminderLabel.setName("individualObservationTabCreateBatchReminderLabel");
    }

    protected void createIndividualObservationTabFishingOperationReminderLabel() {
        $objectMap.put("individualObservationTabFishingOperationReminderLabel", individualObservationTabFishingOperationReminderLabel = new JXTitledPanel());
        
        individualObservationTabFishingOperationReminderLabel.setName("individualObservationTabFishingOperationReminderLabel");
    }

    protected void createIndividualObservationTabPanel() {
        $objectMap.put("individualObservationTabPanel", individualObservationTabPanel = new JPanel());
        
        individualObservationTabPanel.setName("individualObservationTabPanel");
        individualObservationTabPanel.setLayout(individualObservationTabPanelLayout);
    }

    protected void createIndividualObservationTabPanelLayout() {
        $objectMap.put("individualObservationTabPanelLayout", individualObservationTabPanelLayout = new CardLayout2Ext(this, "individualObservationTabPanel"));
    }

    protected void createMarineLitterTab() {
        $objectMap.put("marineLitterTab", marineLitterTab = new TabInfo());
        
        marineLitterTab.setTitle(_("tutti.label.tab.marineLitter"));
    }

    protected void createMarineLitterTabContent() {
        $objectMap.put("marineLitterTabContent", marineLitterTabContent = new MarineLitterBatchUI(this));
        
        marineLitterTabContent.setName("marineLitterTabContent");
    }

    protected void createMarineLitterTabCreateBatch() {
        $objectMap.put("marineLitterTabCreateBatch", marineLitterTabCreateBatch = new CreateMarineLitterBatchUI(this));
        
        marineLitterTabCreateBatch.setName("marineLitterTabCreateBatch");
    }

    protected void createMarineLitterTabCreateBatchReminderLabel() {
        $objectMap.put("marineLitterTabCreateBatchReminderLabel", marineLitterTabCreateBatchReminderLabel = new JXTitledPanel());
        
        marineLitterTabCreateBatchReminderLabel.setName("marineLitterTabCreateBatchReminderLabel");
    }

    protected void createMarineLitterTabFishingOperationReminderLabel() {
        $objectMap.put("marineLitterTabFishingOperationReminderLabel", marineLitterTabFishingOperationReminderLabel = new JXTitledPanel());
        
        marineLitterTabFishingOperationReminderLabel.setName("marineLitterTabFishingOperationReminderLabel");
    }

    protected void createMarineLitterTabPanel() {
        $objectMap.put("marineLitterTabPanel", marineLitterTabPanel = new JPanel());
        
        marineLitterTabPanel.setName("marineLitterTabPanel");
        marineLitterTabPanel.setLayout(marineLitterTabPanelLayout);
    }

    protected void createMarineLitterTabPanelLayout() {
        $objectMap.put("marineLitterTabPanelLayout", marineLitterTabPanelLayout = new CardLayout2Ext(this, "marineLitterTabPanel"));
    }

    protected void createMarineLitterTable() {
        $objectMap.put("marineLitterTable", marineLitterTable = new Table());
        
        marineLitterTable.setName("marineLitterTable");
    }

    protected void createMarineLitterTotalWeightField() {
        $objectMap.put("marineLitterTotalWeightField", marineLitterTotalWeightField = new TuttiComputedOrNotDataEditor(this));
        
        marineLitterTotalWeightField.setName("marineLitterTotalWeightField");
        marineLitterTotalWeightField.setDecimalNumber(3);
        marineLitterTotalWeightField.setUseFloat(true);
        marineLitterTotalWeightField.setShowReset(true);
        marineLitterTotalWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createMarineLitterTotalWeightLabel() {
        $objectMap.put("marineLitterTotalWeightLabel", marineLitterTotalWeightLabel = new JLabel());
        
        marineLitterTotalWeightLabel.setName("marineLitterTotalWeightLabel");
        marineLitterTotalWeightLabel.setText(_("tutti.editCatchBatch.field.marineLitterTotalWeight"));
        marineLitterTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.marineLitterTotalWeight.help");
        marineLitterTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createPlanktonTab() {
        $objectMap.put("planktonTab", planktonTab = new TabInfo());
        
        planktonTab.setTitle(_("tutti.label.tab.plancton"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editCatchBatch.action.saveCatchBatch"));
        saveButton.setToolTipText(_("tutti.editCatchBatch.action.saveCatchBatch.tip"));
        saveButton.putClientProperty("help", "tutti.editCatchBatch.action.saveCatchBatch.help");
        saveButton.putClientProperty("tuttiAction", SaveCatchBatchAction.class);
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabCreateBatch() {
        $objectMap.put("speciesTabCreateBatch", speciesTabCreateBatch = new CreateSpeciesBatchUI(this));
        
        speciesTabCreateBatch.setName("speciesTabCreateBatch");
    }

    protected void createSpeciesTabCreateBatchReminderLabel() {
        $objectMap.put("speciesTabCreateBatchReminderLabel", speciesTabCreateBatchReminderLabel = new JXTitledPanel());
        
        speciesTabCreateBatchReminderLabel.setName("speciesTabCreateBatchReminderLabel");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTabFrequencyEditor() {
        $objectMap.put("speciesTabFrequencyEditor", speciesTabFrequencyEditor = new SpeciesFrequencyUI(speciesTabContent));
        
        speciesTabFrequencyEditor.setName("speciesTabFrequencyEditor");
    }

    protected void createSpeciesTabFrequencyEditorReminderLabel() {
        $objectMap.put("speciesTabFrequencyEditorReminderLabel", speciesTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        speciesTabFrequencyEditorReminderLabel.setName("speciesTabFrequencyEditorReminderLabel");
    }

    protected void createSpeciesTabPanel() {
        $objectMap.put("speciesTabPanel", speciesTabPanel = new JPanel());
        
        speciesTabPanel.setName("speciesTabPanel");
        speciesTabPanel.setLayout(speciesTabPanelLayout);
    }

    protected void createSpeciesTabPanelLayout() {
        $objectMap.put("speciesTabPanelLayout", speciesTabPanelLayout = new CardLayout2Ext(this, "speciesTabPanel"));
    }

    protected void createSpeciesTabSplitBatch() {
        $objectMap.put("speciesTabSplitBatch", speciesTabSplitBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabSplitBatch.setName("speciesTabSplitBatch");
    }

    protected void createSpeciesTabSplitBatchReminderLabel() {
        $objectMap.put("speciesTabSplitBatchReminderLabel", speciesTabSplitBatchReminderLabel = new JXTitledPanel());
        
        speciesTabSplitBatchReminderLabel.setName("speciesTabSplitBatchReminderLabel");
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new Table());
        
        speciesTable.setName("speciesTable");
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setDecimalNumber(3);
        speciesTotalSortedWeightField.setUseFloat(true);
        speciesTotalSortedWeightField.setShowReset(true);
        speciesTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalSortedWeight"));
        speciesTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalUnsortedWeight"));
        speciesTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalWeight"));
        speciesTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalWeight.help");
        speciesTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTremieCarrouselRow() {
        $objectMap.put("tremieCarrouselRow", tremieCarrouselRow = new Table());
        
        tremieCarrouselRow.setName("tremieCarrouselRow");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCatchesTopPanel();
        addChildrenToValidator();
        addChildrenToCatchesCaracteristicsTabToolBar();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToCatchesCaracteristicsTabScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(catchesForm, BorderLayout.NORTH);
        addChildrenToCatchesForm();
        addChildrenToCatchTable();
        addChildrenToTremieCarrouselRow();
        addChildrenToSpeciesTable();
        addChildrenToBenthosTable();
        addChildrenToMarineLitterTable();
        addChildrenToSpeciesTabPanel();
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToSpeciesTabCreateBatchReminderLabel();
        addChildrenToSpeciesTabSplitBatchReminderLabel();
        addChildrenToSpeciesTabFrequencyEditorReminderLabel();
        addChildrenToBenthosTabPanel();
        addChildrenToBenthosTabFishingOperationReminderLabel();
        addChildrenToBenthosTabCreateBatchReminderLabel();
        addChildrenToBenthosTabSplitBatchReminderLabel();
        addChildrenToBenthosTabFrequencyEditorReminderLabel();
        addChildrenToMarineLitterTabPanel();
        addChildrenToMarineLitterTabFishingOperationReminderLabel();
        addChildrenToMarineLitterTabCreateBatchReminderLabel();
        addChildrenToAccidentalTabPanel();
        addChildrenToAccidentalTabFishingOperationReminderLabel();
        addChildrenToAccidentalTabCreateBatchReminderLabel();
        addChildrenToIndividualObservationTabPanel();
        addChildrenToIndividualObservationTabFishingOperationReminderLabel();
        addChildrenToIndividualObservationTabCreateBatchReminderLabel();
        addChildrenToCaracteristicMapEditorReminderLabel();
        // inline complete setup of $JPanel1
        $JPanel1.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 33 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 68 property setters
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        importPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.importPupitri.mnemonic"),'Z'));
        catchesCaracteristicsTabPane.setRightDecoration(catchesCaracteristicsTabToolBar);
        catchTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.total")));
        catchTotalWeightLabel.setLabelFor(catchTotalWeightField);
        catchTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalWeight.tip"));
        catchTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        catchTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedWeightLabel.setLabelFor(catchTotalSortedWeightField);
        catchTotalSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalSortedWeight.tip"));
        catchTotalSortedCarousselWeightLabel.setLabelFor(catchTotalSortedCarousselWeightField);
        catchTotalSortedCarousselWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.tip"));
        catchTotalSortedTremisWeightLabel.setLabelFor(catchTotalSortedTremisWeightField);
        catchTotalSortedTremisWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalSortedTremisWeight.tip"));
        catchTotalUnsortedWeightLabel.setLabelFor(catchTotalUnsortedWeightField);
        catchTotalUnsortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalUnsortedWeight.tip"));
        catchTotalRejectedWeightLabel.setLabelFor(catchTotalRejectedWeightField);
        catchTotalRejectedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalRejectedWeight.tip"));
        catchTotalRejectedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalRejectedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        catchTotalRejectedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.species")));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalWeight.tip"));
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalSortedWeight.tip"));
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalSampleSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.tip"));
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalUnsortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalUnsortedWeight.tip"));
        benthosTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.benthos")));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalWeight.tip"));
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalSortedWeight.tip"));
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalSampleSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.tip"));
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        benthosTotalUnsortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalUnsortedWeight.tip"));
        marineLitterTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.marineLitter")));
        marineLitterTotalWeightLabel.setLabelFor(marineLitterTotalWeightField);
        marineLitterTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.marineLitterTotalWeight.tip"));
        marineLitterTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        marineLitterTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.cancelEditCatchBatch.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.saveCatchBatch.mnemonic"),'Z'));
        computeSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("generate"));
        computeSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.computeWeights.mnemonic"),'Z'));
        planktonTab.setEnabled(false);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCatchesTopPanel, "tutti.editCatchBatch.help");
        registerHelpId(_broker, importPupitriButton, "tutti.editCatchBatch.action.importPupitri.help");
        registerHelpId(_broker, catchTotalWeightLabel, "tutti.editCatchBatch.field.catchTotalWeight.help");
        registerHelpId(_broker, catchTotalSortedWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
        registerHelpId(_broker, catchTotalSortedCarousselWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
        registerHelpId(_broker, catchTotalSortedTremisWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
        registerHelpId(_broker, catchTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
        registerHelpId(_broker, catchTotalRejectedWeightLabel, "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
        registerHelpId(_broker, speciesTotalWeightLabel, "tutti.editCatchBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalWeightLabel, "tutti.editCatchBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, marineLitterTotalWeightLabel, "tutti.editCatchBatch.field.marineLitterTotalWeight.help");
        registerHelpId(_broker, cancelButton, "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        registerHelpId(_broker, saveButton, "tutti.editCatchBatch.action.saveCatchBatch.help");
        registerHelpId(_broker, computeSpeciesBatchButton, "tutti.editCatchBatch.action.computeWeights.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editCatchesTopPanel", editCatchesTopPanel);
        createHandler();
        createModel();
        createValidator();
        createSpeciesTabPanelLayout();
        createBenthosTabPanelLayout();
        createMarineLitterTabPanelLayout();
        createAccidentalTabPanelLayout();
        createIndividualObservationTabPanelLayout();
        createBroker();
        createCatchesCaracteristicsTabToolBar();
        createImportPupitriButton();
        createCatchesCaracteristicsAttachmentsButton();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createCatchesCaracteristicsTabScrollPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCatchesForm();
        createCatchTable();
        createCatchTotalWeightLabel();
        createCatchTotalWeightField();
        createCatchTotalSortedWeightLabel();
        createCatchTotalSortedWeightField();
        createTremieCarrouselRow();
        createCatchTotalSortedCarousselWeightLabel();
        createCatchTotalSortedCarousselWeightField();
        createCatchTotalSortedTremisWeightLabel();
        createCatchTotalSortedTremisWeightField();
        createCatchTotalUnsortedWeightLabel();
        createCatchTotalUnsortedWeightField();
        createCatchTotalRejectedWeightLabel();
        createCatchTotalRejectedWeightField();
        createSpeciesTable();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createBenthosTable();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createMarineLitterTable();
        createMarineLitterTotalWeightLabel();
        createMarineLitterTotalWeightField();
        createSpeciesTabPanel();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createSpeciesTabCreateBatchReminderLabel();
        createSpeciesTabCreateBatch();
        createSpeciesTabSplitBatchReminderLabel();
        createSpeciesTabSplitBatch();
        createSpeciesTabFrequencyEditorReminderLabel();
        createSpeciesTabFrequencyEditor();
        createBenthosTabPanel();
        createBenthosTabFishingOperationReminderLabel();
        createBenthosTabContent();
        createBenthosTabCreateBatchReminderLabel();
        createBenthosTabCreateBatch();
        createBenthosTabSplitBatchReminderLabel();
        createBenthosTabSplitBatch();
        createBenthosTabFrequencyEditorReminderLabel();
        createBenthosTabFrequencyEditor();
        createMarineLitterTabPanel();
        createMarineLitterTabFishingOperationReminderLabel();
        createMarineLitterTabContent();
        createMarineLitterTabCreateBatchReminderLabel();
        createMarineLitterTabCreateBatch();
        createAccidentalTabPanel();
        createAccidentalTabFishingOperationReminderLabel();
        createAccidentalTabContent();
        createAccidentalTabCreateBatchReminderLabel();
        createAccidentalTabCreateBatch();
        createIndividualObservationTabPanel();
        createIndividualObservationTabFishingOperationReminderLabel();
        createIndividualObservationTabContent();
        createIndividualObservationTabCreateBatchReminderLabel();
        createIndividualObservationTabCreateBatch();
        createCaracteristicMapEditorReminderLabel();
        createCaracteristicMapEditor();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createComputeSpeciesBatchButton();
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createMarineLitterTab();
        createPlanktonTab();
        createAccidentalTab();
        createIndividualObservationTab();
        // inline creation of editCatchesTopPanel
        setName("editCatchesTopPanel");
        setLayout(new BorderLayout());
        editCatchesTopPanel.putClientProperty("help", "tutti.editCatchBatch.help");
        
        // registers 33 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 33 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesCaracteristicsAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setModel(model.getCatchTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setBean(model.getCatchTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedWeightField, getWeightStringValue(model.getCatchTotalSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TREMIE_CARROUSEL_ROW_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getFishingOperation() != null && handler != null && handler.getConfig() != null) {
                    tremieCarrouselRow.setVisible(model.getFishingOperation().getVessel() != null && model.getFishingOperation().getVessel().getId().equals(handler.getConfig().getTremieCarousselVesselId()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedCarousselWeightField, getWeightStringValue(model.getCatchTotalSortedCarousselWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedTremisWeightField, getWeightStringValue(model.getCatchTotalSortedTremisWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalUnsortedWeightField, getWeightStringValue(model.getCatchTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setModel(model.getCatchTotalRejectedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setBean(model.getCatchTotalRejectedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalRejectedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, getWeightStringValue(model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setBean(model.getSpeciesTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSortedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, getWeightStringValue(model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getWeightStringValue(model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalWeightField, getWeightStringValue(model.getBenthosTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setModel(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setBean(model.getBenthosTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalSortedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalSampleSortedWeightField, getWeightStringValue(model.getBenthosTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, getWeightStringValue(model.getBenthosTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setModel(model.getMarineLitterTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setBean(model.getMarineLitterTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                marineLitterTotalWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.addPropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabFishingOperationReminderLabel.setRightDecoration(speciesTabContent.getSpeciesBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.removePropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.addPropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabFishingOperationReminderLabel.setRightDecoration(benthosTabContent.getBenthosBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.removePropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.addPropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabFishingOperationReminderLabel.setRightDecoration(marineLitterTabContent.getMarineLitterBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.removePropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.addPropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabFishingOperationReminderLabel.setRightDecoration(accidentalTabContent.getAccidentalBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.removePropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.addPropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabFishingOperationReminderLabel.setRightDecoration(individualObservationTabContent.getIndividualObservationBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.removePropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
    }

}