/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.order;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.order.OrderItem;
import fr.ifremer.adagio.core.dao.referential.order.OrderItemDao;
import fr.ifremer.adagio.core.dao.referential.order.OrderItemImpl;
import fr.ifremer.adagio.core.dao.referential.order.OrderType;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class OrderItemDaoBase
extends HibernateDaoSupport
implements OrderItemDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("OrderItem.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(OrderItemImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (OrderItem)entity);
    }

    @Override
    public OrderItem load(Integer id) {
        return (OrderItem)this.load(0, id);
    }

    @Override
    public Collection<OrderItem> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(OrderItemImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public OrderItem create(OrderItem orderItem) {
        return (OrderItem)this.create(0, orderItem);
    }

    @Override
    public Object create(int transform, OrderItem orderItem) {
        if (orderItem == null) {
            throw new IllegalArgumentException("OrderItem.create - 'orderItem' can not be null");
        }
        this.getHibernateTemplate().save((Object)orderItem);
        return this.transformEntity(transform, orderItem);
    }

    @Override
    public Collection<OrderItem> create(Collection<OrderItem> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<OrderItem> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("OrderItem.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    OrderItemDaoBase.this.create(transform, (OrderItem)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public OrderItem create(Integer objectId, Integer rank, Timestamp updateDate, OrderType orderType) {
        return (OrderItem)this.create(0, objectId, rank, updateDate, orderType);
    }

    @Override
    public Object create(int transform, Integer objectId, Integer rank, Timestamp updateDate, OrderType orderType) {
        OrderItemImpl entity = new OrderItemImpl();
        entity.setObjectId(objectId);
        entity.setRank(rank);
        entity.setUpdateDate(updateDate);
        entity.setOrderType(orderType);
        return this.create(transform, entity);
    }

    @Override
    public OrderItem create(Integer objectId, OrderType orderType, Integer rank) {
        return (OrderItem)this.create(0, objectId, orderType, rank);
    }

    @Override
    public Object create(int transform, Integer objectId, OrderType orderType, Integer rank) {
        OrderItemImpl entity = new OrderItemImpl();
        entity.setObjectId(objectId);
        entity.setOrderType(orderType);
        entity.setRank(rank);
        return this.create(transform, entity);
    }

    @Override
    public void update(OrderItem orderItem) {
        if (orderItem == null) {
            throw new IllegalArgumentException("OrderItem.update - 'orderItem' can not be null");
        }
        this.getHibernateTemplate().update((Object)orderItem);
    }

    @Override
    public void update(final Collection<OrderItem> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("OrderItem.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    OrderItemDaoBase.this.update((OrderItem)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(OrderItem orderItem) {
        if (orderItem == null) {
            throw new IllegalArgumentException("OrderItem.remove - 'orderItem' can not be null");
        }
        this.getHibernateTemplate().delete((Object)orderItem);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("OrderItem.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        OrderItem entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<OrderItem> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("OrderItem.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, OrderItem entity) {
        OrderItem target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected OrderItem toEntity(Object[] row) {
        OrderItem target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof OrderItem)) continue;
                target = (OrderItem)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), OrderItemImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), OrderItemImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<OrderItem> search(Search search) {
        return this.search(0, search);
    }
}

