/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.protocol;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class TuttiProtocols {
    public static void toFile(TuttiProtocol protocol, File file) throws IOException {
        String id = protocol.getId();
        BufferedWriter fileWriter = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            YamlWriter writer = new YamlWriter((Writer)fileWriter, TuttiProtocols.createConfig());
            writer.write((Object)protocol);
            writer.close();
            fileWriter.close();
        }
        catch (YamlException e) {
            throw new IOException("Could not transform protocol " + id + " to file " + file, e);
        }
        finally {
            Closeables.closeQuietly((Closeable)fileWriter);
        }
    }

    public static TuttiProtocol fromFile(File file) throws IOException {
        BufferedReader fileReader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        try {
            YamlReader reader = new YamlReader((Reader)fileReader, TuttiProtocols.createConfig());
            TuttiProtocol result = (TuttiProtocol)reader.read(TuttiProtocol.class);
            ((Reader)fileReader).close();
            TuttiProtocol tuttiProtocol = result;
            return tuttiProtocol;
        }
        catch (YamlException e) {
            throw new IOException("Could not import protocol from file " + file, e);
        }
        finally {
            Closeables.closeQuietly((Closeable)fileReader);
        }
    }

    protected static YamlConfig createConfig() {
        YamlConfig result = new YamlConfig();
        result.setClassTag(SpeciesProtocol.class.getSimpleName(), SpeciesProtocol.class);
        result.writeConfig.setAlwaysWriteClassname(false);
        result.writeConfig.setWriteRootTags(false);
        return result;
    }
}

