/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.bean;

import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.JXPathDecorator;
import org.nuiton.util.decorator.MultiJXPathDecorator;

public class BeanDoubleListHandler<O> {
    private static final Log log = LogFactory.getLog(BeanDoubleListHandler.class);
    protected Method mutator;
    protected BeanDoubleList<O> ui;
    protected MultiJXPathDecorator<O> decorator;

    public BeanDoubleListHandler(BeanDoubleList<O> ui) {
        this.ui = ui;
    }

    public void init(JXPathDecorator<O> decorator, List<O> universe, List<O> selected) {
        this.decorator = BeanUIUtil.createDecorator(decorator);
        this.ui.getModel().setUniverse(universe);
        this.ui.getModel().setSelected(selected);
        JList universeList = this.ui.getUniverseList();
        JList selectedList = this.ui.getSelectedList();
        universeList.setCellRenderer(new DecoratorListCellRenderer(decorator));
        selectedList.setCellRenderer(new DecoratorListCellRenderer(decorator));
        universeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                BeanDoubleListHandler.this.ui.getModel().setAddEnabled(!source.isSelectionEmpty());
            }
        });
        selectedList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                BeanDoubleListHandler.this.ui.getModel().setRemoveEnabled(!source.isSelectionEmpty());
            }
        });
        selectedList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }
        });
    }

    public void onUniverseListClicked(MouseEvent event) {
        JList universeList = this.ui.getUniverseList();
        if (event.getClickCount() == 2) {
            int index = universeList.locationToIndex(event.getPoint());
            Object item = universeList.getModel().getElementAt(index);
            this.ui.getModel().addToSelected(item);
        }
    }

    public void onSelectedListClicked(MouseEvent event) {
        JList selectedList = this.ui.getSelectedList();
        if (event.getClickCount() == 2) {
            int index = selectedList.locationToIndex(event.getPoint());
            Object item = selectedList.getModel().getElementAt(index);
            this.ui.getModel().removeFromSelected(item);
        }
    }

    public void select() {
        List<Object> selection = Arrays.asList(this.ui.getUniverseList().getSelectedValues());
        this.ui.getModel().addToSelected(selection);
    }

    public void unselect() {
        List<Object> selection = Arrays.asList(this.ui.getSelectedList().getSelectedValues());
        this.ui.getModel().removeFromSelected(selection);
    }

    protected void fireSelectionUpdate() {
        if (this.ui.getBean() != null && this.getMutator() != null) {
            try {
                this.getMutator().invoke(this.ui.getBean(), this.ui.getModel().getSelected());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Method getMutator() {
        if (this.mutator == null && this.ui.getBackground() != null && this.ui.getProperty() != null) {
            this.mutator = BeanUIUtil.getMutator(this.ui.getBean(), this.ui.getProperty());
        }
        return this.mutator;
    }
}

