/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.service.TuttiBusinessException;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.i18n.I18n;

public class TuttiErrorHelper
implements ErrorReporter {
    protected TuttiUIContext context;

    public TuttiErrorHelper(TuttiUIContext context) {
        this.context = context;
    }

    public void showErrorDialog(String message, Throwable cause) {
        if (cause instanceof TuttiBusinessException) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), cause.getMessage(), I18n._((String)"tutti.ui.common.error", (Object[])new Object[0]), 0);
        } else {
            JXErrorPane pane = new JXErrorPane();
            ErrorInfo info = new ErrorInfo(I18n._((String)"tutti.common.error", (Object[])new Object[0]), I18n._((String)"tutti.error.errorpane.htmlmessage", (Object[])new Object[]{message}), null, null, cause, null, null);
            pane.setErrorInfo(info);
            pane.setErrorReporter((ErrorReporter)this);
            JXErrorPane.showDialog((Component)this.context.getMainUI(), (JXErrorPane)pane);
        }
    }

    public void showErrorDialog(String message) {
        this.showErrorDialog(message, null);
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        this.showErrorDialog(errorInfo.getBasicErrorMessage(), errorInfo.getErrorException());
    }
}

