/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.text.ParseException;
import org.nuiton.util.csv.ImportableExportableColumn;
import org.nuiton.util.csv.ValueFormatter;
import org.nuiton.util.csv.ValueGetter;
import org.nuiton.util.csv.ValueGetterSetter;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ValueParserFormatter;
import org.nuiton.util.csv.ValueSetter;

public class Column<E, T>
implements ImportableExportableColumn<E, T> {
    protected String headerName;
    protected boolean mandatory = true;
    protected boolean ignored;
    protected ValueParser<T> valueParser;
    protected ValueFormatter<T> valueFormatter;
    protected ValueGetter<E, T> valueGetter;
    protected ValueSetter<E, T> valueSetter;

    public static <E, T> Column<E, T> newExportableColumn(String headerName, ValueGetter<E, T> valueGetter, ValueFormatter<T> valueFormatter, boolean ignored) {
        return new Column<E, T>(headerName, valueGetter, valueFormatter, null, null, ignored);
    }

    public static <E, T> Column<E, T> newImportableColumn(String headerName, ValueParser<T> valueParser, ValueSetter<E, T> valueSetter, boolean ignored) {
        return new Column<E, T>(headerName, null, null, valueParser, valueSetter, ignored);
    }

    public static <E, T> Column<E, T> newImportableExportableColumn(String headerName, ValueGetter<E, T> valueGetter, ValueFormatter<T> valueFormatter, ValueParser<T> valueParser, ValueSetter<E, T> valueSetter, boolean ignored) {
        return new Column<E, T>(headerName, valueGetter, valueFormatter, valueParser, valueSetter, ignored);
    }

    public static <E, T> Column<E, T> newImportableExportableColumn(String headerName, ValueGetterSetter<E, T> valueGetterSetter, ValueParserFormatter<T> valueParserFormatter, boolean ignored) {
        return Column.newImportableExportableColumn(headerName, valueGetterSetter, valueParserFormatter, valueParserFormatter, valueGetterSetter, ignored);
    }

    protected Column(String headerName, ValueGetter<E, T> valueGetter, ValueFormatter<T> valueFormatter, ValueParser<T> valueParser, ValueSetter<E, T> valueSetter, boolean ignored) {
        this.headerName = headerName;
        this.valueGetter = valueGetter;
        this.valueFormatter = valueFormatter;
        this.valueSetter = valueSetter;
        this.valueParser = valueParser;
        this.ignored = ignored;
        this.mandatory = !ignored;
    }

    @Override
    public String getHeaderName() {
        return this.headerName;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    @Override
    public String formatValue(T value) {
        if (this.valueFormatter == null) {
            throw new UnsupportedOperationException("no formatter provided for " + this);
        }
        return this.valueFormatter.format(value);
    }

    @Override
    public T parseValue(String value) throws ParseException {
        if (this.valueParser == null) {
            throw new UnsupportedOperationException("no parser provided for " + this);
        }
        return this.valueParser.parse(value);
    }

    @Override
    public T getValue(E object) throws Exception {
        if (this.valueGetter == null) {
            throw new UnsupportedOperationException("no getter provided for " + this);
        }
        return this.valueGetter.get(object);
    }

    @Override
    public void setValue(E object, T value) throws Exception {
        if (!this.isIgnored()) {
            if (this.valueSetter == null) {
                throw new UnsupportedOperationException("no setter provided for " + this);
            }
            this.valueSetter.set(object, value);
        }
    }

    public String toString() {
        return "{headerName='" + this.headerName + '\'' + ", mandatory=" + this.mandatory + ", ignored=" + this.ignored + '}';
    }
}

