/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.impl;

import fr.ifremer.adagio.core.service.technical.CacheService;
import javax.annotation.Resource;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Component;

@Component(value="cacheService")
public class CacheServiceImpl
implements CacheService {
    private static final Log logger = LogFactory.getLog(CacheServiceImpl.class);
    @Resource(name="cacheManager")
    private org.springframework.cache.CacheManager cacheManager;
    @Resource(name="ehcache")
    private CacheManager ehCacheManager;

    @Override
    public void clearAllCaches() {
        logger.info((Object)"Clearing all caches...");
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            cache.clear();
        }
        this.ehCacheManager.clearAll();
    }

    @Override
    public void clearCache(String cacheName) {
        logger.info((Object)("Clearing cache " + cacheName + "..."));
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            cache.clear();
            return;
        }
        net.sf.ehcache.Cache ehCache = this.ehCacheManager.getCache(cacheName);
        if (ehCache != null) {
            ehCache.removeAll();
            return;
        }
        logger.warn((Object)("Unable to clear cache. Cache with name '" + cacheName + "' could not found."));
    }
}

