/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final long serialVersionUID = 1L;

    public RemoveSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, "removeSpeciesProtocol", "batch-delete", I18n._((String)"tutti.action.removeSpeciesProtocol", (Object[])new Object[0]), I18n._((String)"tutti.action.removeSpeciesProtocol.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected void doAction(ActionEvent event) {
        EditProtocolUIHandler handler = (EditProtocolUIHandler)this.getHandler();
        int rowIndex = handler.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove species if no species selected");
        EditProtocolSpeciesTableModel tableModel = handler.getTableModel();
        EditProtocolSpeciesRowModel selectedRow = (EditProtocolSpeciesRowModel)tableModel.getEntry(rowIndex);
        Species species = selectedRow.getSpecies();
        BeanComboBox<Species> combo = ((EditProtocolUI)this.getUI()).getSpeciesComboBox();
        combo.getData().add(species);
        combo.getHandler().sortData();
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        Integer taxonId = species.getReferenceTaxonId();
        ArrayList allSynonyms = Lists.newArrayList(model.getAllSynonyms(String.valueOf(taxonId)));
        allSynonyms.remove(species);
        model.getAllSynonyms().addAll(allSynonyms);
        Collections.sort(model.getAllSynonyms(), new Comparator<Species>(){

            @Override
            public int compare(Species o1, Species o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        tableModel.removeRow(rowIndex);
        String speciesStr = this.getDecorator(Species.class, "byCruiseCode").toString((Object)selectedRow.getSpecies());
        this.sendMessage(I18n._((String)"tutti.flash.information.species.remove.from.protocol", (Object[])new Object[]{speciesStr}));
    }
}

