package fr.ifremer.tutti.ui.swing.content.operation.fishing.environment;

/*
 * #%L
 * Tutti :: UI
 * $Id: EnvironmentTabUIHandler.java 349 2013-02-06 10:54:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/environment/EnvironmentTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicTabUIHandler;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

import java.util.List;

/**
 * @author kmorin
 * @since 0.3
 */
public class EnvironmentTabUIHandler extends CaracteristicTabUIHandler<EnvironmentRowModel, EnvironmentTabUIModel, EnvironmentTableModel, EnvironmentTabUI> {

    private final static Log log =
            LogFactory.getLog(EnvironmentTabUIHandler.class);

    public EnvironmentTabUIHandler(EditFishingOperationUI parentUi,
                                   EnvironmentTabUI ui) {
        super(parentUi, ui, EnvironmentRowModel.PROPERTY_VALUE);
    }

    //------------------------------------------------------------------------//
    //-- CaracteristicTabUIHandler methods                                  --//
    //------------------------------------------------------------------------//

    @Override
    protected BeanComboBox<Caracteristic> getKeyCombo() {
        return ui.getNewRowKey();
    }

    @Override
    protected EnvironmentTabUIModel createModel() {
        return new EnvironmentTabUIModel();
    }

    @Override
    protected CaracteristicMap getCaracteristics(FishingOperation operation) {
        return operation.getEnvironmentCaracteristics();
    }

    @Override
    protected List<String> getProtocolPmfmIds(TuttiProtocol protocol) {
        return protocol.getEnvironmentPmfmId();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiTableUIHandler methods                                --//
    //------------------------------------------------------------------------//

    @Override
    public JXTable getTable() {
        return ui.getEnvironmentTable();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void afterInitUI() {
        super.afterInitUI();

        JXTable table = getTable();

        // create table column model
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();

        {

            addColumnToModel(columnModel,
                             null,
                             newTableCellRender(Caracteristic.class, DecoratorService.CARACTERISTIC_WITH_UNIT),
                             EnvironmentTableModel.KEY);
        }

        {

            addColumnToModel(columnModel,
                             new CaracteristicValueEditor(context),
                             new CaracteristicValueRenderer(context),
                             EnvironmentTableModel.VALUE);
        }

        // create table model
        EnvironmentTableModel tableModel =
                new EnvironmentTableModel(columnModel);

        table.setModel(tableModel);
        table.setColumnModel(columnModel);
        initTable(table);
    }

}
