package fr.ifremer.tutti.ui.swing.content.operation.catches.plankton;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class PlanktonBatchUI extends JPanel implements TuttiUI<PlanktonBatchUIModel, PlanktonBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PLANKTON_TOTAL_SAMPLE_WEIGHT_FIELD_MODEL = "planktonTotalSampleWeightField.model";
    public static final String BINDING_PLANKTON_TOTAL_WEIGHT_FIELD_MODEL = "planktonTotalWeightField.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSemDiJ0yYpjQgpLVWgIrSqWHOKEKmgiRO3DpvUZF2IyCGMvRN70/HOMvO22cgK4k/gT4A7FyRunBAHzhy4IP4FhDhwRbyZtb27iROnIpa8Ws2873u/Zr633/1J8kqSNw5oFFky9MFrM2tjZWfnSf2ANWCNqYb0AhCSxL+RHMntkituf10BubNra3ixCy+WRDsQPvNT6GWbTCo44ky1GAMgr2cRDaWKTn97OQpC2WPtBzWI9Zu//8p97X71bY6QKMDopjGVhWGoJJNRm+Q8F8h19PScFjn1mxiG9Pwmxjul10qcKrVF2+wL8iUZt8lYQCWSAXnz4ikbDoOPAiCFlmizKvUZB2LvS8vbl6zNpAUhgGeFnqUO0b/VED4gnSUCJil4wrcaFBotpqwAw3wGuFDtvqzqjaeVIDBOxoCMt6jvciaBOJfp4HHMmvjJt4Wr0/j4Mr1sas7ExwyTUsgarXO2GXt7kOnvc8o9l2K5uw4d/fykt7jJlKJNlsAT4kIfCeT+C1AmDNNc+M0ai2Dd9QzN0tl1CMHjFjN2lp2BPa1oukKf9RoFoI1WG6vW433vYrwrJ4AnmUf3hWwDmc8kG9OYAmWt53sNqgmg/FPmNVtg07ruwHV9M6IudMMsatDtc7Flj3G8aosDvHfj3wrbdSbj2LN8tzN8Dm0HnKUi0lZ3LoowcWirxSxiBnQNnIYUnOvrCeTVTJrJTrZOeYMDclPIpnWAuohegxgUWRs7/creD1CbbmayR9WzEtVLZGlkl+RliMtYyd3TQrmNW7FEzp+QSE1odv+dm/3txz9+KPd0cRx9vzLQNCXrqFeB1BcVPO16JhZFfcKKmzRY3iUFxTjOBKP5twYE5nS3MTj097KGxwf0MVUtpMiP//7Tz3Of//oSyZXJJBfULVNtXyEFaEmsguBuFHz40ER09XACn9fwP4pHt86oj8LWMYpzjLeXhiCqIghRUYudrt5ZTQYl4e97zbv3LE+t9EzSB+vuPY1GV4fbTOlJNAoyxOLP6CVjvYo3DFWLvHsGrYOGacbYHnkj7MitAR3pl6Ve+OWfWef7h72ujGCVbpxpnnQm/xkZ83zu+czMq+4oGjifrgSKha5IRs6gIUSwaFfTKXQ1bck83z/VgByQCa4vWlmr0Wuds273sa4mChuQt2OZMqBTip+CRaH2uGZqod/K5BzhCYaEOZpMpIX4oOjOVU+zmTMw5ZsCVFFumcR2z3UqW7W9pb21yqNKzdmrrtRq69tbaDgRKlbGw4pp5fcpx0NDJrr35AjI7P/IyhRtWFbZ4i90zhe2pAXvDG1BGjwo5CGq+wLtWDyjHWnOy2zKjUvK80INwjynYmHEzxv9kQHkrY7tKXDSi9xyKluP7PU9Z91eL9UqT0wWCnsaj49eFrN9Kuw3a0oR+jg1pzolwXFErtorpY+O01artPGsZzXW8UPOjwflGE+pYamMIAenRwJPDpl+gJ87dKHu+S6Osg9OkY7o5yQy/gfcoB04QgwAAA==";
    private static final Log log = LogFactory.getLog(PlanktonBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AttachmentEditorUI attachmentEditor;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected Table form;
    protected PlanktonBatchUIHandler handler;
    protected PlanktonBatchUI homePanel = this;
    protected LongTextEditorUI longTextEditor;
    protected PlanktonBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "planktonTotalSampleWeight",  editorName = "planktonTotalSampleWeightField")
    protected NumberEditor planktonTotalSampleWeightField;
    protected JLabel planktonTotalSampleWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "planktonTotalWeight",  editorName = "planktonTotalWeightField")
    protected NumberEditor planktonTotalWeightField;
    protected JLabel planktonTotalWeightLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<PlanktonBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PlanktonBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            PlanktonBatchUIHandler handler = new PlanktonBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public PlanktonBatchUI() {
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PlanktonBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PlanktonBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PlanktonBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI getAttachmentEditor() {
        return attachmentEditor;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public Table getForm() {
        return form;
    }

    public PlanktonBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public PlanktonBatchUIModel getModel() {
        return model;
    }

    public NumberEditor getPlanktonTotalSampleWeightField() {
        return planktonTotalSampleWeightField;
    }

    public JLabel getPlanktonTotalSampleWeightLabel() {
        return planktonTotalSampleWeightLabel;
    }

    public NumberEditor getPlanktonTotalWeightField() {
        return planktonTotalWeightField;
    }

    public JLabel getPlanktonTotalWeightLabel() {
        return planktonTotalWeightLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<PlanktonBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(planktonTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(planktonTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(planktonTotalSampleWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(planktonTotalSampleWeightField), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(longTextEditor);
        add(attachmentEditor);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentEditor() {
        $objectMap.put("attachmentEditor", attachmentEditor = new AttachmentEditorUI());
        
        attachmentEditor.setName("attachmentEditor");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(PlanktonBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(PlanktonBatchUIModel.class));
    }

    protected void createPlanktonTotalSampleWeightField() {
        $objectMap.put("planktonTotalSampleWeightField", planktonTotalSampleWeightField = new NumberEditor(this));
        
        planktonTotalSampleWeightField.setName("planktonTotalSampleWeightField");
        planktonTotalSampleWeightField.setProperty("planktonTotalSampleWeight");
        planktonTotalSampleWeightField.setUseFloat(false);
        planktonTotalSampleWeightField.setShowReset(true);
    }

    protected void createPlanktonTotalSampleWeightLabel() {
        $objectMap.put("planktonTotalSampleWeightLabel", planktonTotalSampleWeightLabel = new JLabel());
        
        planktonTotalSampleWeightLabel.setName("planktonTotalSampleWeightLabel");
        planktonTotalSampleWeightLabel.setText(_("tutti.label.catches.planktonTotalSampleWeight"));
    }

    protected void createPlanktonTotalWeightField() {
        $objectMap.put("planktonTotalWeightField", planktonTotalWeightField = new NumberEditor(this));
        
        planktonTotalWeightField.setName("planktonTotalWeightField");
        planktonTotalWeightField.setProperty("planktonTotalWeight");
        planktonTotalWeightField.setUseFloat(false);
        planktonTotalWeightField.setShowReset(true);
    }

    protected void createPlanktonTotalWeightLabel() {
        $objectMap.put("planktonTotalWeightLabel", planktonTotalWeightLabel = new JLabel());
        
        planktonTotalWeightLabel.setName("planktonTotalWeightLabel");
        planktonTotalWeightLabel.setText(_("tutti.label.catches.planktonTotalWeight"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(PlanktonBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToTableScrollPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        planktonTotalWeightLabel.setLabelFor(planktonTotalWeightField);
        planktonTotalWeightField.setBean(model);
        planktonTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        planktonTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
        planktonTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        planktonTotalSampleWeightLabel.setLabelFor(planktonTotalSampleWeightField);
        planktonTotalSampleWeightField.setBean(model);
        planktonTotalSampleWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        planktonTotalSampleWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
        planktonTotalSampleWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createLongTextEditor();
        createAttachmentEditor();
        createForm();
        createPlanktonTotalWeightLabel();
        createPlanktonTotalWeightField();
        createPlanktonTotalSampleWeightLabel();
        createPlanktonTotalSampleWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PLANKTON_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("planktonTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    planktonTotalWeightField.setModel(model.getPlanktonTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("planktonTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PLANKTON_TOTAL_SAMPLE_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("planktonTotalSampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    planktonTotalSampleWeightField.setModel(model.getPlanktonTotalSampleWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("planktonTotalSampleWeight", this);
                }
            }
        });
    }

}