package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id: SelectCruiseAction.java 330 2013-02-05 09:19:16Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/SelectCruiseAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * Opens the cruise selection screen (home).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class SelectCruiseAction extends AbstractChangeScreenAction {

    private static final long serialVersionUID = 1L;

    public SelectCruiseAction(MainUIHandler handler) {
        super(handler,
              "selectCruise",
              "home",
              _("tutti.action.selectCruise"),
              _("tutti.action.selectCruise.tip"),
              true
        );
        setMnemonic('S');
    }

    @Override
    protected void doAction(ActionEvent e) {
//        Preconditions.checkNotNull(getContext().isCruiseFilled());
        getContext().setScreen(getNextScreen());
    }

    @Override
    protected TuttiScreen getNextScreen() {
        return TuttiScreen.SELECT_CRUISE;
    }
}
