/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RuleType implements Enumerator
{
    FILTER_LITERAL(0, "Filter", "Filter"),
    SUPPRESS_LITERAL(1, "Suppress", "Suppress"),
    LINK_LITERAL(2, "Link", "Link");

    public static final int FILTER = 0;
    public static final int SUPPRESS = 1;
    public static final int LINK = 2;
    private static final RuleType[] VALUES_ARRAY;
    public static final List<RuleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RuleType[]{FILTER_LITERAL, SUPPRESS_LITERAL, LINK_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RuleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleType get(int value) {
        switch (value) {
            case 0: {
                return FILTER_LITERAL;
            }
            case 1: {
                return SUPPRESS_LITERAL;
            }
            case 2: {
                return LINK_LITERAL;
            }
        }
        return null;
    }

    private RuleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

