/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.services;

import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import fr.ifremer.suiviobsmer.entity.WaoUser;
import java.lang.annotation.Annotation;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.RelativePosition;
import org.apache.tapestry5.services.BeanModelSource;
import org.nuiton.topia.persistence.TopiaEntity;

/**
 * ContactModelFactory
 *
 * Created: 18 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 283 $
 *
 * Mise a jour: $Date: 2010-01-27 17:09:19 +0100 (mer., 27 janv. 2010) $
 * par : $Author: fdesbois $
 */
public class ContactModelFactory {

    /**
     * @param beanModelSource used to construct BeanModel<Contact>
     * @param resources used to construct BeanModel<Contact>
     * @return BeanModel<Contact> with new params
     */
    public BeanModel<Contact> buildContactModel(BeanModelSource beanModelSource, ComponentResources resources) {
        BeanModel<Contact> contactModel = beanModelSource.createDisplayModel(Contact.class, resources.getMessages());

        // New properties for contactModel
        contactModel.add("createdBy", null);
//        contactModel.add(Contact.SAMPLE_ROW, getSampleRowPropertyConduit());
//        contactModel.add(Contact.BOAT, getBoatPropertyConduit());
        contactModel.add(Contact.SAMPLE_ROW, null);
        contactModel.add(Contact.BOAT, null);
        contactModel.add("mammals", null);
        contactModel.add("validation", null);
        contactModel.add("actions", null);

        contactModel.include(
                    "createdBy",
                    TopiaEntity.TOPIA_CREATE_DATE,
                    Contact.SAMPLE_ROW,
                    Contact.BOAT,
                    Contact.STATE,
                    Contact.TIDE_BEGIN_DATE,
                    Contact.TIDE_END_DATE,
                    Contact.NB_OBSERVANTS,
                    "mammals",
                    Contact.DATA_INPUT_DATE,
                    Contact.COMMENT,
                    "validation",
                    "actions");

        contactModel.get(TopiaEntity.TOPIA_CREATE_DATE).sortable(false);
        contactModel.get(Contact.STATE).sortable(false);
        contactModel.get(Contact.TIDE_BEGIN_DATE).sortable(false);
        contactModel.get(Contact.TIDE_END_DATE).sortable(false);
        contactModel.get(Contact.NB_OBSERVANTS).sortable(false);
        contactModel.get(Contact.DATA_INPUT_DATE).sortable(false);
        contactModel.get(Contact.COMMENT).sortable(false);
        
        return contactModel;
    }

    public BeanModel<Contact> buildAdminContactModel(BeanModelSource beanModelSource, ComponentResources resources) {
        BeanModel<Contact> contactModel = buildContactModel(beanModelSource, resources);
        contactModel.exclude("createdBy");
        contactModel.add(RelativePosition.AFTER, TopiaEntity.TOPIA_CREATE_DATE, "observer", getUserPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "observer", WaoUser.COMPANY, getCompanyPropertyConduit());
        contactModel.add(RelativePosition.AFTER, Contact.SAMPLE_ROW, "program", getProgramPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "program", "professionCode", getProfessionCodePropertyConduit());
        contactModel.add(RelativePosition.AFTER, "professionCode", "professionLibelle", getProfessionLibellePropertyConduit());
        contactModel.add(RelativePosition.AFTER, "professionLibelle", "professionSpecies", getProfessionSpeciesPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "professionSpecies", "fishingZoneFacade", getFishingZoneFacadePropertyConduit());
        contactModel.add(RelativePosition.AFTER, "fishingZoneFacade", "fishingZoneSector", getFishingZoneSectorPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "fishingZoneSector", "fishingZoneDivision", getFishingZoneDivisionPropertyConduit());
        contactModel.add(RelativePosition.AFTER, Contact.BOAT, "boatImmatriculation", getBoatImmatriculationPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "boatImmatriculation", "boatDistrictCode", getBoatDistrictCodePropertyConduit());

        contactModel.get("observer").sortable(false);
        contactModel.get(WaoUser.COMPANY).sortable(false);
        contactModel.get("program").sortable(false);
        contactModel.get("professionCode").sortable(false);
        contactModel.get("professionLibelle").sortable(false);
        contactModel.get("professionSpecies").sortable(false);
        contactModel.get("fishingZoneFacade").sortable(false);
        contactModel.get("fishingZoneSector").sortable(false);
        contactModel.get("fishingZoneDivision").sortable(false);
        contactModel.get("boatImmatriculation").sortable(false);
        contactModel.get("boatDistrictCode").sortable(false);

//        contactModel.add(RelativePosition.AFTER, TopiaEntity.TOPIA_CREATE_DATE, "observer", null);
//        contactModel.add(RelativePosition.AFTER, "observer", User.COMPANY, null);
//        contactModel.add(RelativePosition.AFTER, Contact.SAMPLE_ROW, "program", null);
//        contactModel.add(RelativePosition.AFTER, "program", "professionCode", null);
//        contactModel.add(RelativePosition.AFTER, "professionCode", "professionLibelle", null);
//        contactModel.add(RelativePosition.AFTER, "professionLibelle", "professionSpecies", null);
//        contactModel.add(RelativePosition.AFTER, "professionSpecies", "fishingZoneFacade", null);
//        contactModel.add(RelativePosition.AFTER, "fishingZoneFacade", "fishingZoneSector", null);
//        contactModel.add(RelativePosition.AFTER, "fishingZoneSector", "fishingZoneDivision", null);
//        contactModel.add(RelativePosition.AFTER, Contact.BOAT, "boatImmatriculation", null);
//        contactModel.add(RelativePosition.AFTER, "boatImmatriculation", "boatDistrictCode", null);
        return contactModel;
    }

    public PropertyConduit getUserPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getObserver().getFullName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }
    
    public PropertyConduit getCompanyPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getObserver().getCompany().getName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    } 
    
    public PropertyConduit getSampleRowPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getCode();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getBoatPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getBoat().getName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProgramPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProgramName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProfessionCodePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProfession().getCode();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProfessionLibellePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProfession().getLibelle();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProfessionSpeciesPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProfession().getSpecies();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getFishingZoneFacadePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getFacade();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getFishingZoneSectorPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getSectors();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getFishingZoneDivisionPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    String result = "";
                    for (FishingZone zone : contact.getSampleRow().getFishingZone()) {
                        result += zone.getDistrictCode() + " ";
                    }
                    return result;
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getBoatImmatriculationPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getBoat().getImmatriculation();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getBoatDistrictCodePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getBoat().getDistrictCode();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }
}
