/* *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*/

package fr.ifremer.suiviobsmer.ui.components;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import java.io.OutputStream;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Response;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

/**
 * Composant qui affiche un graphe de type PieChart.
 *
 * <pre>
 * Utilisation :
 * &lt;t:chart width=&quot;210&quot; height=&quot;190&quot; values=&quot;choice&quot; title=&quot;title&quot; type=&quot;1&quot;/&gt;
 * - choice est une liste de chaînes représentant les labels et leur valeurs respectives. ({&quot;val1&quot;, &quot;20&quot;, &quot;val2&quot;, &quot;10&quot;}...)
 * - type est le type de représentation du diagramme (1:PIE, 2:PIE3D...)
 * Pour généraliser à d'autres types de graphes il faudrait passer un JFreeChart :
 * Persist Parameter(required=true)
 * private JFreeChart _chart;
 * </pre>
 *
 * @author rannou
 * @version $Id: Chart.java 222 2010-01-17 19:49:21Z fdesbois $
 */
public class Chart {

//    /** diagramme de type PIE */
//    public static final int PIE = 1;
//    /** diagramme de type PIE3D */
//    public static final int PIE3D = 2;
//    /** diagramme de type RING */
//    public static final int RING = 3;

    /** titre du diagramme */
    @Parameter
    private String _title = "";

    @Parameter(required = true)
    private JFreeChart _chart;

    /** type de représentation du diagramme */
//    @Parameter(required = true)
//    private int _type;

    @Parameter(required = true)
    private int _width;

    @Parameter(required = true)
    private int _height;

    @Persist
    private JFreeChart currentChart;

    /**
     * list(array) of paired values(label,value):
     * [String,Number,String,Number,...]
     */
//    @Parameter(required = true)
//    private List<Object> _values;

    @Inject
    private ComponentResources _resources;

    void beginRender(MarkupWriter writer) {

        currentChart = _chart;

        // event link params
        Object[] params = new Object[] { _title, _width, _height };
//        params = ArrayUtil.concat(params, _values.toArray());

        // generate event link
        Link link = _resources.createEventLink("chart", params);
        Element img = writer.element("img", "src", link);

        _resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public StreamResponse onChart(final String title, final int width, final int height) {

        // return the image
        return new StreamResponse() {
            public String getContentType() {
                return "image/png";
            }

            public InputStream getStream() throws IOException {
//                String alea = SuiviObsmerContext.createRandomString(8);
//                String path = SuiviObsmerContext.getProperty(SuiviObsmerContext.PROP_PATH_CHARTS);
//                File file = new File(path, "chart_" + alea + ".png");
//                file.getParentFile().mkdirs();

                ByteArrayOutputStream output = new ByteArrayOutputStream();
                ChartUtilities.writeChartAsPNG(output, currentChart, width, height);
                return new ByteArrayInputStream(output.toByteArray());
            }

            public void prepareResponse(Response response) {
            }
        };
    }
}
