/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public abstract class AbstractCheckInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -7169251953113201351L;
    private static final Log log = LogFactory.getLog(AbstractCheckInterceptor.class);
    protected String redirectAction;

    public void setRedirectAction(String redirectAction) {
        this.redirectAction = redirectAction;
    }

    protected abstract boolean doCheck(ActionInvocation var1);

    public String intercept(ActionInvocation invocation) throws Exception {
        boolean check = this.doCheck(invocation);
        if (!check) {
            String redirectUrl = this.getRedirectUrl();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will redirect to " + redirectUrl));
            }
            this.redirect(redirectUrl);
            return null;
        }
        return invocation.invoke();
    }

    protected String getRedirectUrl() {
        return this.redirectAction;
    }

    protected void redirect(String url) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();
        String path = request.getContextPath();
        if (!url.startsWith("/")) {
            path = path + "/";
        }
        response.sendRedirect(path + url);
    }
}

