/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.entities.EchoBaseUserTopiaApplicationContext;
import fr.ifremer.echobase.entities.EchoBaseUserTopiaPersistenceContext;
import fr.ifremer.echobase.ui.EchoBaseSession;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.web.filter.TypedTopiaTransactionFilter;

public class EchoBaseUserDbTransactionFilter
extends TypedTopiaTransactionFilter<EchoBaseUserPersistenceContext> {
    private static final Log log = LogFactory.getLog(EchoBaseUserDbTransactionFilter.class);
    public static final String USER_TRANSACTION = "userTransaction";

    public EchoBaseUserDbTransactionFilter() {
        super(EchoBaseUserPersistenceContext.class);
    }

    public static EchoBaseUserPersistenceContext getPersistenceContext(ActionContext context) {
        HttpServletRequest request = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        return (EchoBaseUserPersistenceContext)request.getAttribute(USER_TRANSACTION);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.setRequestAttributeName(USER_TRANSACTION);
    }

    public EchoBaseUserPersistenceContext beginTransaction(ServletRequest request) {
        HttpSession session = ((HttpServletRequest)request).getSession();
        Preconditions.checkNotNull((Object)session);
        EchoBaseSession userSession = EchoBaseSession.getEchoBaseSession((HttpSession)session);
        Preconditions.checkNotNull((Object)userSession);
        EchoBaseUserTopiaApplicationContext rootContext = userSession.getUserDbApplicationContext();
        Preconditions.checkNotNull((Object)rootContext);
        EchoBaseUserTopiaPersistenceContext transaction = rootContext.newPersistenceContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starts a new working db transaction " + transaction));
        }
        return transaction;
    }
}

