/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportMap;

import fr.ifremer.echobase.services.service.exportMap.ExportMapConfiguration;
import fr.ifremer.echobase.services.service.exportMap.ExportMapService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Export
extends AbstractWaitAndExecAction<ExportMapConfiguration, ExportMapService> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Export.class);

    public Export() {
        super(ExportMapConfiguration.class, ExportMapService.class);
    }

    protected void startAction(ExportMapService service, ExportMapConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start export map for mission" + model.getMissionId()));
        }
        service.doExport(model);
    }

    protected String getSuccesMessage() {
        return this.t("echobase.info.exportMap.succeded", new Object[0]);
    }

    protected String getErrorMessage() {
        return this.t("echobase.info.exportMap.failed", new Object[0]);
    }

    public String getActionResumeTitle() {
        return this.t("echobase.legend.exportMap.resume", new Object[0]);
    }

    protected String getResultMessage(ExportMapConfiguration model) {
        String result = this.t("echobase.message.exportMap.result", new Object[]{model.getExportFile().getName(), model.getActionTime()});
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + result));
        }
        return result;
    }
}

