package fr.ifremer.echobase.ui.actions.removeData;

/*
 * #%L
 * EchoBase :: UI
 * $Id: ImportLogs.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/removeData/ImportLogs.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.service.WorkingDbPersistenceService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

import java.util.Map;

/**
 * To display imports logs page.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ImportLogs extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected Map<String, String> voyages;

    protected String voyageId;

    public Map<String, String> getVoyages() {
        return voyages;
    }

    public String getVoyageId() {
        return voyageId;
    }

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    @Override
    public String execute() throws Exception {

        voyages = workingDbPersistenceService.loadSortAndDecorate(Voyage.class);

        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient WorkingDbPersistenceService workingDbPersistenceService;

    public void setWorkingDbPersistenceService(WorkingDbPersistenceService workingDbPersistenceService) {
        this.workingDbPersistenceService = workingDbPersistenceService;
    }
}
