<%--
  #%L
  EchoBase :: UI
  $Id: showDataMap.jsp 843 2013-08-20 06:07:41Z tchemit $
  $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.2/echobase-ui/src/main/webapp/WEB-INF/jsp/spatial/showDataMap.jsp $
  %%
  Copyright (C) 2011 - 2013 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-0.6.4/leaflet.css" />
<!--[if lte IE 8]>
<link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-0.6.4/leaflet.ie.css" />
<![endif]-->

<sj:head jqueryui="true" jquerytheme="echobase-theme" debug="true" compressed="false" />

<%--<script type="text/javascript"--%>
        <%--src="http://cdn.leafletjs.com/leaflet-0.6.4/leaflet.js"></script>--%>
<script type="text/javascript"
        src="<s:url value='/js/leaflet-src.js' />"></script>

<%--<script type="text/javascript"--%>
        <%--src="<s:url value='/js/gridHelper.js' />"></script>--%>

<script type="text/javascript">

  jQuery(document).ready(function () {

    console.info("LL2= "+L);

    jQuery.getJSON(
      '<s:url action="getSpatialData" namespace="/spatial"/>',
      {
        "model.voyageId": '<s:property value="model.voyageId"/>',
        "model.dataMetadataId": '<s:property value="model.dataMetadataId"/>',
        "model.speciesId": '<s:property value="model.speciesId"/>',
        "model.echotypeId": '<s:property value="model.echotypeId"/>'
      },
      function (result) {

        console.info("LL3= "+L);

        // create a map in the "map" div, set the view to a given place and zoom
        var map = L.map('map').setView([51.505, -0.09], 13);

        // add an OpenStreetMap tile layer
        L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
          attribution: '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);

        // get geoJson object
        var geoJson = result.data;

        // add it to map
        L.geoJson(geoJson).addTo(map);
      });

  });
</script>
<div id="map">
Loading...
</div>

